/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.action;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.ClipboardActionsApi;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardUtils;

@ParametersAreNonnullByDefault
public class ClipboardTextActions
implements ClipboardActionsApi {
    public static final String EDIT_SELECT_ALL_ACTION_ID = "editSelectAllAction";
    public static final String EDIT_DELETE_ACTION_ID = "editDeleteAction";
    public static final String EDIT_PASTE_ACTION_ID = "editPasteAction";
    public static final String EDIT_COPY_ACTION_ID = "editCopyAction";
    public static final String EDIT_CUT_ACTION_ID = "editCutAction";
    public static final String DELETE_ACTION = "delete";
    public static final String SELECT_ALL_ACTION = "selectAll";
    private ResourceBundle resourceBundle;
    private ActionMap actionMap;
    private Component actionFocusOwner = null;
    private JComponent lastFocusOwner = null;
    private boolean isValidClipboardFlavor = false;
    private CaretListener textComponentCaretListener;
    private PropertyChangeListener textComponentPCL;
    private ClipboardActionsHandler clipboardHandler;
    private Action cutTextAction;
    private Action copyTextAction;
    private Action pasteTextAction;
    private Action deleteTextAction;
    private Action selectAllTextAction;

    public void setup(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.initializeTextActions();
    }

    private void initializeTextActions() {
        this.actionMap = new ActionMap();
    }

    public void performCut(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            ActionUtils.invokeTextAction((JTextComponent)((JTextComponent)src), (String)"cut-to-clipboard");
        }
    }

    public void performCopy(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            ActionUtils.invokeTextAction((JTextComponent)((JTextComponent)src), (String)"copy-to-clipboard");
        }
    }

    public void performPaste(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            ActionUtils.invokeTextAction((JTextComponent)((JTextComponent)src), (String)"paste-from-clipboard");
        }
    }

    @Nonnull
    public Action getCutAction() {
        if (this.cutTextAction == null) {
            this.cutTextAction = new PassingTextAction(new DefaultEditorKit.CutAction());
            ActionUtils.setupAction((Action)this.cutTextAction, (ResourceBundle)this.resourceBundle, (String)EDIT_CUT_ACTION_ID);
            this.cutTextAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, ActionUtils.getMetaMask()));
            this.cutTextAction.setEnabled(false);
            this.actionMap.put(TransferHandler.getCutAction().getValue("Name"), this.cutTextAction);
        }
        return this.cutTextAction;
    }

    @Nonnull
    public Action getCopyAction() {
        if (this.copyTextAction == null) {
            this.copyTextAction = new PassingTextAction(new DefaultEditorKit.CopyAction());
            ActionUtils.setupAction((Action)this.copyTextAction, (ResourceBundle)this.resourceBundle, (String)EDIT_COPY_ACTION_ID);
            this.copyTextAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, ActionUtils.getMetaMask()));
            this.copyTextAction.setEnabled(false);
            this.actionMap.put(TransferHandler.getCopyAction().getValue("Name"), this.copyTextAction);
        }
        return this.copyTextAction;
    }

    @Nonnull
    public Action getPasteAction() {
        if (this.pasteTextAction == null) {
            this.pasteTextAction = new PassingTextAction(new DefaultEditorKit.PasteAction());
            ActionUtils.setupAction((Action)this.pasteTextAction, (ResourceBundle)this.resourceBundle, (String)EDIT_PASTE_ACTION_ID);
            this.pasteTextAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, ActionUtils.getMetaMask()));
            this.pasteTextAction.setEnabled(false);
            this.actionMap.put(TransferHandler.getPasteAction().getValue("Name"), this.pasteTextAction);
        }
        return this.pasteTextAction;
    }

    @Nonnull
    public Action getDeleteAction() {
        if (this.deleteTextAction == null) {
            this.deleteTextAction = new PassingTextAction(new TextAction(DELETE_ACTION){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component src = ClipboardTextActions.this.actionFocusOwner;
                    if (src instanceof JTextComponent) {
                        ActionUtils.invokeTextAction((JTextComponent)((JTextComponent)src), (String)"delete-next");
                    }
                }
            });
            ActionUtils.setupAction((Action)this.deleteTextAction, (ResourceBundle)this.resourceBundle, (String)EDIT_DELETE_ACTION_ID);
            this.deleteTextAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.deleteTextAction.setEnabled(false);
            this.actionMap.put(DELETE_ACTION, this.deleteTextAction);
        }
        return this.deleteTextAction;
    }

    @Nonnull
    public Action getSelectAllAction() {
        if (this.selectAllTextAction == null) {
            this.selectAllTextAction = new PassingTextAction(new TextAction(SELECT_ALL_ACTION){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component src = ClipboardTextActions.this.actionFocusOwner;
                    if (src instanceof JTextComponent) {
                        SwingUtilities.invokeLater(() -> {
                            JTextComponent txtComp = (JTextComponent)src;
                            txtComp.requestFocus();
                            ActionUtils.invokeTextAction((JTextComponent)txtComp, (String)"select-all");
                            int docLength = txtComp.getDocument().getLength();
                            if (txtComp.getSelectionStart() > 0 || txtComp.getSelectionEnd() != docLength) {
                                txtComp.selectAll();
                            }
                        });
                    }
                }
            });
            ActionUtils.setupAction((Action)this.selectAllTextAction, (ResourceBundle)this.resourceBundle, (String)EDIT_SELECT_ALL_ACTION_ID);
            this.selectAllTextAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, ActionUtils.getMetaMask()));
        }
        return this.selectAllTextAction;
    }

    public void setClipboardHandler(ClipboardActionsHandler clipboardHandler) {
        this.clipboardHandler = clipboardHandler;
    }

    private void updateFocusOwner(JComponent oldOwner, JComponent newOwner) {
        JTextComponent text;
        if (oldOwner instanceof JTextComponent) {
            text = (JTextComponent)oldOwner;
            text.removeCaretListener(this.textComponentCaretListener);
            text.removePropertyChangeListener(this.textComponentPCL);
        }
        if (newOwner instanceof JTextComponent) {
            text = (JTextComponent)newOwner;
            text.addCaretListener(this.textComponentCaretListener);
            text.addPropertyChangeListener(this.textComponentPCL);
        } else if (newOwner == null) {
            this.copyTextAction.setEnabled(false);
            this.cutTextAction.setEnabled(false);
            this.pasteTextAction.setEnabled(false);
            this.deleteTextAction.setEnabled(false);
        }
        this.lastFocusOwner = newOwner;
    }

    @Nullable
    private Component getFocusOwner() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    private void updateTextActions(JTextComponent text) {
        Caret caret = text.getCaret();
        boolean selection = caret.getDot() != caret.getMark();
        boolean editable = text.isEditable();
        boolean data = this.isValidClipboardFlavor;
        this.copyTextAction.setEnabled(selection);
        this.cutTextAction.setEnabled(editable && selection);
        this.deleteTextAction.setEnabled(editable && selection);
        this.pasteTextAction.setEnabled(editable && data);
    }

    public void updateClipboardActionsState() {
    }

    private final class TextComponentPCL
    implements PropertyChangeListener {
        private TextComponentPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName == null || "editable".equals(propertyName)) {
                ClipboardTextActions.this.updateTextActions((JTextComponent)e.getSource());
            }
        }
    }

    private final class TextComponentCaretListener
    implements CaretListener {
        private TextComponentCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            ClipboardTextActions.this.updateTextActions((JTextComponent)e.getSource());
        }
    }

    private final class ClipboardListener
    implements FlavorListener {
        private ClipboardListener() {
        }

        @Override
        public void flavorsChanged(FlavorEvent e) {
            JComponent c = (JComponent)ClipboardTextActions.this.getFocusOwner();
            if (c instanceof JTextComponent) {
                ClipboardTextActions.this.isValidClipboardFlavor = ClipboardUtils.getClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
                ClipboardTextActions.this.updateTextActions((JTextComponent)c);
            }
        }
    }

    private final class KeyboardFocusPCL
    implements PropertyChangeListener {
        KeyboardFocusPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JComponent newOwner;
            Component oldOwner = ClipboardTextActions.this.getFocusOwner();
            Object newValue = e.getNewValue();
            JComponent jComponent = newOwner = newValue instanceof JComponent ? (JComponent)newValue : null;
            if (oldOwner instanceof JComponent) {
                ClipboardTextActions.this.updateFocusOwner((JComponent)oldOwner, newOwner);
            }
            if (newOwner != null) {
                ClipboardTextActions.this.actionFocusOwner = newOwner;
            }
        }
    }

    @ParametersAreNonnullByDefault
    public class PassingTextAction
    extends TextAction {
        private final TextAction parentAction;

        public PassingTextAction(TextAction parentAction) {
            super((String)parentAction.getValue("Name"));
            this.parentAction = parentAction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.parentAction.actionPerformed(actionEvent);
        }
    }
}

