/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.action;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.exbin.framework.action.ClipboardActions;
import org.exbin.framework.action.ClipboardTextActions;
import org.exbin.framework.action.MenuHandler;
import org.exbin.framework.action.ToolBarHandler;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.action.api.ToolBarGroup;
import org.exbin.framework.action.api.ToolBarPosition;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.api.XBApplicationModuleRepository;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.popup.api.PopupModuleApi;
import org.exbin.framework.utils.ClipboardActionsApi;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdater;
import org.exbin.framework.utils.ComponentPopupEventDispatcher;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class ActionModule
implements ActionModuleApi {
    private XBApplication application;
    private ClipboardActions clipboardActions = null;
    private ClipboardTextActions clipboardTextActions = null;
    private MenuHandler menuHandler = null;
    private ToolBarHandler toolBarHandler = null;
    private ResourceBundle resourceBundle;

    public void init(XBModuleHandler moduleHandler) {
        this.application = (XBApplication)moduleHandler;
    }

    public void unregisterModule(String moduleId) {
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(ActionModule.class);
        }
        return this.resourceBundle;
    }

    private void ensureSetup() {
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    @Nonnull
    public ClipboardActions getClipboardActions() {
        if (this.clipboardActions == null) {
            this.clipboardActions = new ClipboardActions();
            this.ensureSetup();
            this.clipboardActions.setup(this.resourceBundle);
        }
        return this.clipboardActions;
    }

    @Nonnull
    public ClipboardTextActions getClipboardTextActions() {
        if (this.clipboardTextActions == null) {
            this.clipboardTextActions = new ClipboardTextActions();
            this.ensureSetup();
            this.clipboardTextActions.setup(this.resourceBundle);
        }
        return this.clipboardTextActions;
    }

    public void addComponentPopupEventDispatcher(ComponentPopupEventDispatcher dispatcher) {
        XBApplicationModuleRepository moduleRepository = this.application.getModuleRepository();
        PopupModuleApi popupModule = (PopupModuleApi)moduleRepository.getModuleByInterface(PopupModuleApi.class);
        popupModule.addComponentPopupEventDispatcher(dispatcher);
    }

    public void removeComponentPopupEventDispatcher(ComponentPopupEventDispatcher dispatcher) {
        XBApplicationModuleRepository moduleRepository = this.application.getModuleRepository();
        PopupModuleApi popupModule = (PopupModuleApi)moduleRepository.getModuleByInterface(PopupModuleApi.class);
        popupModule.removeComponentPopupEventDispatcher(dispatcher);
    }

    public void fillPopupMenu(JPopupMenu popupMenu, int position) {
        XBApplicationModuleRepository moduleRepository = this.application.getModuleRepository();
        PopupModuleApi popupModule = (PopupModuleApi)moduleRepository.getModuleByInterface(PopupModuleApi.class);
        popupModule.fillDefaultEditPopupMenu(popupMenu, position);
    }

    @Nonnull
    private MenuHandler getMenuHandler() {
        if (this.menuHandler == null) {
            this.menuHandler = new MenuHandler();
        }
        return this.menuHandler;
    }

    @Nonnull
    private ToolBarHandler getToolBarHandler() {
        if (this.toolBarHandler == null) {
            this.toolBarHandler = new ToolBarHandler();
        }
        return this.toolBarHandler;
    }

    public void buildMenu(JPopupMenu targetMenu, String menuId) {
        this.getMenuHandler().buildMenu(targetMenu, menuId);
    }

    public void buildMenu(JMenuBar targetMenuBar, String menuId) {
        this.getMenuHandler().buildMenu(targetMenuBar, menuId);
    }

    public void registerMenu(String menuId, String pluginId) {
        this.getMenuHandler().registerMenu(menuId, pluginId);
    }

    public void registerMenuGroup(String menuId, MenuGroup menuGroup) {
        this.getMenuHandler().registerMenuGroup(menuId, menuGroup);
    }

    public void registerMenuItem(String menuId, String pluginId, JMenu menu, MenuPosition position) {
        this.getMenuHandler().registerMenuItem(menuId, pluginId, menu, position);
    }

    public void registerMenuItem(String menuId, String pluginId, JMenuItem item, MenuPosition position) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void registerMenuItem(String menuId, String pluginId, Action action, MenuPosition position) {
        this.getMenuHandler().registerMenuItem(menuId, pluginId, action, position);
    }

    public void registerMenuItem(String menuId, String pluginId, String subMenuId, Action subMenuAction, MenuPosition position) {
        this.getMenuHandler().registerMenuItem(menuId, pluginId, subMenuId, subMenuAction, position);
    }

    public void registerMenuItem(String menuId, String pluginId, String subMenuId, String subMenuName, MenuPosition position) {
        this.getMenuHandler().registerMenuItem(menuId, pluginId, subMenuId, subMenuName, position);
    }

    public void registerClipboardMenuItems(String menuId, String moduleId, SeparationMode separationMode) {
        this.registerClipboardMenuItems((ClipboardActionsApi)this.getClipboardActions(), menuId, moduleId, separationMode);
    }

    public void registerClipboardMenuItems(ClipboardActionsApi actions, String menuId, String moduleId, SeparationMode separationMode) {
        this.registerMenuGroup(menuId, new MenuGroup(CLIPBOARD_ACTIONS_MENU_GROUP_ID, new MenuPosition(PositionMode.TOP), separationMode));
        this.registerMenuItem(menuId, moduleId, actions.getCutAction(), new MenuPosition(CLIPBOARD_ACTIONS_MENU_GROUP_ID));
        this.registerMenuItem(menuId, moduleId, actions.getCopyAction(), new MenuPosition(CLIPBOARD_ACTIONS_MENU_GROUP_ID));
        this.registerMenuItem(menuId, moduleId, actions.getPasteAction(), new MenuPosition(CLIPBOARD_ACTIONS_MENU_GROUP_ID));
        this.registerMenuItem(menuId, moduleId, actions.getDeleteAction(), new MenuPosition(CLIPBOARD_ACTIONS_MENU_GROUP_ID));
        this.registerMenuItem(menuId, moduleId, actions.getSelectAllAction(), new MenuPosition(CLIPBOARD_ACTIONS_MENU_GROUP_ID));
    }

    public void registerClipboardTextActions() {
        this.getClipboardTextActions();
        XBApplicationModuleRepository moduleRepository = this.application.getModuleRepository();
        PopupModuleApi popupModule = (PopupModuleApi)moduleRepository.getModuleByInterface(PopupModuleApi.class);
        popupModule.registerDefaultClipboardPopupMenu(this.resourceBundle, ActionModule.class);
    }

    public void buildToolBar(JToolBar targetToolBar, String toolBarId) {
        this.getToolBarHandler().buildToolBar(targetToolBar, toolBarId);
    }

    public void registerToolBar(String toolBarId, String pluginId) {
        this.getToolBarHandler().registerToolBar(toolBarId, pluginId);
    }

    public void registerToolBarGroup(String toolBarId, ToolBarGroup toolBarGroup) {
        this.getToolBarHandler().registerToolBarGroup(toolBarId, toolBarGroup);
    }

    public void registerToolBarItem(String toolBarId, String pluginId, Action action, ToolBarPosition position) {
        this.getToolBarHandler().registerToolBarItem(toolBarId, pluginId, action, position);
    }

    public void registerMenuClipboardActions() {
        this.registerClipboardMenuItems(FrameModuleApi.EDIT_MENU_ID, MODULE_ID, SeparationMode.NONE);
    }

    public void registerToolBarClipboardActions() {
        this.getClipboardActions();
        this.registerToolBarGroup(FrameModuleApi.MAIN_TOOL_BAR_ID, new ToolBarGroup(CLIPBOARD_ACTIONS_TOOL_BAR_GROUP_ID, new ToolBarPosition(PositionMode.TOP)));
        this.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, this.clipboardActions.getCutAction(), new ToolBarPosition(CLIPBOARD_ACTIONS_TOOL_BAR_GROUP_ID));
        this.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, this.clipboardActions.getCopyAction(), new ToolBarPosition(CLIPBOARD_ACTIONS_TOOL_BAR_GROUP_ID));
        this.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, this.clipboardActions.getPasteAction(), new ToolBarPosition(CLIPBOARD_ACTIONS_TOOL_BAR_GROUP_ID));
        this.registerToolBarItem(FrameModuleApi.MAIN_TOOL_BAR_ID, MODULE_ID, this.clipboardActions.getDeleteAction(), new ToolBarPosition(CLIPBOARD_ACTIONS_TOOL_BAR_GROUP_ID));
    }

    public void registerClipboardHandler(ClipboardActionsHandler clipboardHandler) {
        this.getClipboardActions().setClipboardActionsHandler(clipboardHandler);
    }

    public boolean menuGroupExists(String menuId, String groupId) {
        return this.menuHandler.menuGroupExists(menuId, groupId);
    }

    @Nonnull
    public ClipboardActionsUpdater createClipboardActions(ClipboardActionsHandler clipboardActionsHandler) {
        ClipboardActions customClipboardActions = new ClipboardActions();
        customClipboardActions.setup(this.resourceBundle);
        customClipboardActions.setClipboardActionsHandler(clipboardActionsHandler);
        return customClipboardActions;
    }

    public void unregisterMenu(String menuId) {
        this.getMenuHandler().unregisterMenu(menuId);
    }

    public void updateClipboardActionsState() {
        this.clipboardTextActions.updateClipboardActionsState();
    }
}

