/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.support.mode.HistoryRewriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CStationContainerHistoryRewriter
implements HistoryRewriter<Location, CLocationMode> {
    private CControl control;

    public CStationContainerHistoryRewriter(CControl control) {
        this.control = control;
    }

    public CControl getControl() {
        return this.control;
    }

    protected CStation<?> getMatchingStation(Dockable dockable, String root) {
        CStation<?> rootStation = this.control.getStation(root);
        if (rootStation == null) {
            return null;
        }
        CStationContainer rootContainer = this.getContainer(rootStation);
        if (rootContainer == null) {
            return rootStation;
        }
        CStation<?> station = this.getParent(dockable);
        CStationContainer container = this.getContainer(station);
        if (container != null) {
            if (rootContainer == container) {
                return rootStation;
            }
            return container.getMatchingStation(rootContainer, rootStation);
        }
        List history = this.control.getLocationManager().getPropertyHistory(dockable);
        for (int i = history.size() - 1; i >= 0; --i) {
            String historyRoot = ((Location)history.get(i)).getRoot();
            CStation<?> historyStation = this.control.getStation(historyRoot);
            if (historyStation == null || (container = this.getContainer(historyStation)) == null) continue;
            return container.getMatchingStation(rootContainer, rootStation);
        }
        return null;
    }

    protected CStation<?> getMatchingStation(Dockable dockable, ExtendedMode mode) {
        CStation<?> station = this.getParent(dockable);
        CStationContainer container = this.getContainer(station);
        if (container != null) {
            return container.getDefaultStation(mode);
        }
        List history = this.control.getLocationManager().getPropertyHistory(dockable);
        for (int i = history.size() - 1; i >= 0; --i) {
            String historyRoot = ((Location)history.get(i)).getRoot();
            CStation<?> rootStation = this.control.getStation(historyRoot);
            if (rootStation == null || (container = this.getContainer(rootStation)) == null) continue;
            return container.getDefaultStation(mode);
        }
        return null;
    }

    protected CStation<?> getParent(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            if (dockStation instanceof CommonDockStation) {
                return ((CommonDockStation)dockStation).getStation();
            }
            if (dockStation.asDockable() == null) {
                dockStation = null;
                continue;
            }
            dockStation = dockStation.asDockable().getDockParent();
        }
        return null;
    }

    protected CStationContainer getContainer(CStation<?> child) {
        return this.control.getRegister().getContainer(child);
    }

    @Override
    public Location rewrite(Dockable dockable, CLocationMode mode, Location history) {
        CStation<?> replacement = null;
        if (history != null) {
            replacement = this.getMatchingStation(dockable, history.getRoot());
        }
        if (replacement == null) {
            replacement = this.getMatchingStation(dockable, mode.getExtendedMode());
        }
        if (replacement == null) {
            return history;
        }
        if (history == null) {
            return new Location(mode.getUniqueIdentifier(), replacement.getUniqueId(), null);
        }
        return new Location(mode.getUniqueIdentifier(), replacement.getUniqueId(), history.getLocation());
    }
}

