/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.IOException;
import java.util.Optional;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.client.stub.XBPXIconStub;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXIcon;
import org.exbin.xbup.core.catalog.base.service.XBCItemService;
import org.exbin.xbup.core.catalog.base.service.XBCXIconService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;

public class XBPXIconSkeleton
implements XBPCatalogSkeleton {
    private XBAECatalog catalog;

    public XBPXIconSkeleton(XBAECatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void registerProcedures(XBServiceServer remoteServer) {
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXIconStub.OWNER_ICON_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXIconService iconService = (XBCXIconService)XBPXIconSkeleton.this.catalog.getCatalogService(XBCXIconService.class);
                Optional icon = iconService.getItem(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(icon.isPresent() ? new UBNat32(((XBCXIcon)icon.get()).getParent().getId()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXIconStub.MODE_ICON_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXIconService iconService = (XBCXIconService)XBPXIconSkeleton.this.catalog.getCatalogService(XBCXIconService.class);
                Optional icon = iconService.getItem(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(icon.isPresent() ? new UBNat32(((XBCXIcon)icon.get()).getMode().getId()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXIconStub.XBINDEX_ICON_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXIconStub.DEFAULTITEM_ICON_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXIconService iconService = (XBCXIconService)XBPXIconSkeleton.this.catalog.getCatalogService(XBCXIconService.class);
                XBCItemService itemService = (XBCItemService)XBPXIconSkeleton.this.catalog.getCatalogService(XBCItemService.class);
                Optional item = itemService.getItem(index.getNaturalLong());
                XBCXIcon icon = item.isPresent() ? iconService.getDefaultIcon((XBCItem)item.get()) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(icon == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(icon.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXIconStub.FILE_ICON_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXIconService iconService = (XBCXIconService)XBPXIconSkeleton.this.catalog.getCatalogService(XBCXIconService.class);
                Optional icon = iconService.getItem(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(icon.isPresent() ? new UBNat32(((XBCXIcon)icon.get()).getIconFile().getId()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXIconStub.DEFAULTITEMBIG_ICON_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXIconService iconService = (XBCXIconService)XBPXIconSkeleton.this.catalog.getCatalogService(XBCXIconService.class);
                XBCItemService itemService = (XBCItemService)XBPXIconSkeleton.this.catalog.getCatalogService(XBCItemService.class);
                Optional item = itemService.getItem(index.getNaturalLong());
                XBCXIcon icon = item.isPresent() ? iconService.getDefaultBigIcon((XBCItem)item.get()) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(icon == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(icon.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXIconStub.DEFAULTITEMSMALL_ICON_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXIconService iconService = (XBCXIconService)XBPXIconSkeleton.this.catalog.getCatalogService(XBCXIconService.class);
                XBCItemService itemService = (XBCItemService)XBPXIconSkeleton.this.catalog.getCatalogService(XBCItemService.class);
                Optional item = itemService.getItem(index.getNaturalLong());
                XBCXIcon icon = item.isPresent() ? iconService.getDefaultSmallIcon((XBCItem)item.get()) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(icon == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(icon.getId())));
            }
        });
    }

    @Override
    public void setCatalog(XBAECatalog catalog) {
        this.catalog = catalog;
    }
}

