/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.entity.XBEBlockJoin;
import org.exbin.xbup.catalog.entity.XBEBlockListCons;
import org.exbin.xbup.catalog.entity.XBEBlockListJoin;
import org.exbin.xbup.catalog.entity.XBEFormatJoin;
import org.exbin.xbup.catalog.entity.XBEGroupJoin;
import org.exbin.xbup.catalog.entity.XBESpecDef;
import org.exbin.xbup.client.stub.XBPSpecStub;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;

public class XBPSpecSkeleton
implements XBPCatalogSkeleton {
    private XBAECatalog catalog;

    public XBPSpecSkeleton(XBAECatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void registerProcedures(XBServiceServer remoteServer) {
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.SPEC_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                long orderIndex = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBCSpec spec = node.isPresent() ? specService.getSpecByOrder((XBCNode)node.get(), orderIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(spec == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(spec.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.FORMATSPEC_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                long orderIndex = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBCFormatSpec spec = node.isPresent() ? specService.getFormatSpec((XBCNode)node.get(), orderIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(spec == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(spec.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.GROUPSPEC_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                long orderIndex = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBCGroupSpec spec = node.isPresent() ? specService.getGroupSpec((XBCNode)node.get(), orderIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(spec == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(spec.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.BLOCKSPEC_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                long orderIndex = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBCBlockSpec spec = node.isPresent() ? specService.getBlockSpec((XBCNode)node.get(), orderIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(spec == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(spec.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.SPECS_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                List specs = specService.getSpecs((XBCNode)node.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.matchType();
                listener.putAttribute(specs.size());
                for (XBCSpec spec : specs) {
                    listener.putAttribute(spec.getId());
                }
                listener.end();
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.FORMATSPECS_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                List specs = specService.getFormatSpecs((XBCNode)node.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.matchType();
                listener.putAttribute(specs.size());
                for (XBCSpec spec : specs) {
                    listener.putAttribute(spec.getId());
                }
                listener.end();
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.GROUPSPECS_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                List specs = specService.getGroupSpecs((XBCNode)node.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.matchType();
                listener.putAttribute(specs.size());
                for (XBCSpec spec : specs) {
                    listener.putAttribute(spec.getId());
                }
                listener.end();
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.BLOCKSPECS_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                List specs = specService.getBlockSpecs((XBCNode)node.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.matchType();
                listener.putAttribute(specs.size());
                for (XBCSpec spec : specs) {
                    listener.putAttribute(spec.getId());
                }
                listener.end();
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.FINDFORMATSPEC_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                long xbIndex = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBCFormatSpec spec = node.isPresent() ? specService.findFormatSpecByXB((XBCNode)node.get(), xbIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(spec == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(spec.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.FINDGROUPSPEC_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                long xbIndex = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBCGroupSpec spec = node.isPresent() ? specService.findGroupSpecByXB((XBCNode)node.get(), xbIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(spec == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(spec.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.FINDBLOCKSPEC_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                long xbIndex = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBCBlockSpec spec = node.isPresent() ? specService.findBlockSpecByXB((XBCNode)node.get(), xbIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(spec == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(spec.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.MAXFORMATSPEC_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.findMaxFormatSpecXB((XBCNode)node.get()).longValue()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.MAXGROUPSPEC_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.findMaxGroupSpecXB((XBCNode)node.get()).longValue()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.MAXBLOCKSPEC_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.findMaxBlockSpecXB((XBCNode)node.get()).longValue()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.SPECSCOUNT_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.getSpecsCount((XBCNode)node.get())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.FORMATSPECSCOUNT_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.getFormatSpecsCount((XBCNode)node.get())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.GROUPSPECSCOUNT_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.getGroupSpecsCount((XBCNode)node.get())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.BLOCKSPECSCOUNT_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBCNodeService nodeService = (XBCNodeService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.getBlockSpecsCount((XBCNode)node.get())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.BIND_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long specId = provider.pullLongAttribute();
                long xbIndex = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                Optional spec = specService.getItem(specId);
                XBCSpecDef def = spec.isPresent() ? specService.findSpecDefByXB((XBCSpec)spec.get(), xbIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(def == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(def.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.BINDS_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long specId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                Optional spec = specService.getItem(specId);
                List itemList = specService.getSpecDefs((XBCSpec)spec.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.matchType();
                listener.putAttribute(itemList.size());
                for (XBCSpecDef specDef : itemList) {
                    listener.putAttribute(specDef.getId());
                }
                listener.end();
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.BINDSCOUNT_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long specId = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                Optional spec = specService.getItem(specId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(spec.isPresent() ? new UBNat32(specService.getSpecDefsCount((XBCSpec)spec.get())) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.FINDBIND_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long specId = provider.pullLongAttribute();
                long xbIndex = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                Optional spec = specService.getItem(specId);
                XBESpecDef specDef = (XBESpecDef)specService.findSpecDefByXB((XBCSpec)spec.get(), xbIndex);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                if (specDef == null) {
                    listener.process((XBSerializable)XBTEmptyBlock.getEmptyBlock());
                } else {
                    listener.begin();
                    listener.matchType();
                    listener.putAttribute(specDef.getId());
                    int specDefType = 0;
                    if (specDef instanceof XBEBlockJoin || specDef instanceof XBEGroupJoin || specDef instanceof XBEFormatJoin) {
                        specDefType = 1;
                    } else if (specDef instanceof XBEBlockListCons) {
                        specDefType = 2;
                    } else if (specDef instanceof XBEBlockListJoin) {
                        specDefType = 3;
                    }
                    listener.putAttribute(specDefType);
                    listener.end();
                }
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.FORMATSPECSCOUNT_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.getAllFormatSpecsCount().longValue()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.GROUPSPECSCOUNT_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.getAllGroupSpecsCount().longValue()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.BLOCKSPECSCOUNT_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.getAllBlockSpecsCount().longValue()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.SPECSCOUNT_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.getAllSpecsCount().longValue()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.TARGET_BIND_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long index = provider.pullLongAttribute();
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBESpecDef specDef = (XBESpecDef)specService.getSpecDef(index);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(specDef == null || !specDef.getTargetRev().isPresent() ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(((XBCRev)specDef.getTargetRev().get()).getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPSpecStub.BINDSCOUNT_BIND_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCSpecService specService = (XBCSpecService)XBPSpecSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(specService.getItemsCount()));
            }
        });
    }

    @Override
    public void setCatalog(XBAECatalog catalog) {
        this.catalog = catalog;
    }
}

