/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.entity.XBERev;
import org.exbin.xbup.client.stub.XBPRevStub;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;

public class XBPRevSkeleton
implements XBPCatalogSkeleton {
    private XBAECatalog catalog;

    public XBPRevSkeleton(XBAECatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void registerProcedures(XBServiceServer remoteServer) {
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPRevStub.FINDREV_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long specId = provider.pullLongAttribute();
                long xbIndex = provider.pullLongAttribute();
                provider.end();
                XBCRevService revService = (XBCRevService)XBPRevSkeleton.this.catalog.getCatalogService(XBCRevService.class);
                XBCSpecService specService = (XBCSpecService)XBPRevSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                Optional spec = specService.getItem(specId);
                XBERev rev = spec.isPresent() ? (XBERev)revService.findRevByXB((XBCSpec)spec.get(), xbIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(rev == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(rev.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPRevStub.REVSCOUNT_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long specId = provider.pullLongAttribute();
                provider.end();
                XBCRevService revService = (XBCRevService)XBPRevSkeleton.this.catalog.getCatalogService(XBCRevService.class);
                XBCSpecService specService = (XBCSpecService)XBPRevSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                Optional spec = specService.getItem(specId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(revService.getRevsCount((XBCSpec)spec.get())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPRevStub.REV_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long specId = provider.pullLongAttribute();
                long orderIndex = provider.pullLongAttribute();
                provider.end();
                XBCRevService revService = (XBCRevService)XBPRevSkeleton.this.catalog.getCatalogService(XBCRevService.class);
                XBCSpecService specService = (XBCSpecService)XBPRevSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                Optional spec = specService.getItem(specId);
                XBERev rev = spec.isPresent() ? (XBERev)revService.getRev((XBCSpec)spec.get(), orderIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(rev == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(rev.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPRevStub.REVS_SPEC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long specId = provider.pullLongAttribute();
                provider.end();
                XBCRevService revService = (XBCRevService)XBPRevSkeleton.this.catalog.getCatalogService(XBCRevService.class);
                XBCSpecService specService = (XBCSpecService)XBPRevSkeleton.this.catalog.getCatalogService(XBCSpecService.class);
                Optional spec = specService.getItem(specId);
                List revs = revService.getRevs((XBCSpec)spec.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.matchType();
                listener.putAttribute(revs.size());
                for (XBCRev rev : revs) {
                    listener.putAttribute(rev.getId());
                }
                listener.end();
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPRevStub.XBLIMIT_REV_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long revId = provider.pullLongAttribute();
                provider.end();
                XBCRevService revService = (XBCRevService)XBPRevSkeleton.this.catalog.getCatalogService(XBCRevService.class);
                Optional rev = revService.getItem(revId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(rev.isPresent() ? new UBNat32(((XBCRev)rev.get()).getXBLimit()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPRevStub.REVSCOUNT_REV_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCRevService revService = (XBCRevService)XBPRevSkeleton.this.catalog.getCatalogService(XBCRevService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(revService.getItemsCount()));
            }
        });
    }

    @Override
    public void setCatalog(XBAECatalog catalog) {
        this.catalog = catalog;
    }
}

