/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.popup.handler;

import java.awt.datatransfer.StringSelection;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JTable;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.framework.utils.ClipboardUtils;

@ParametersAreNonnullByDefault
public class TablePopupHandler
implements ClipboardActionsHandler {
    private final JTable tableComp;

    public TablePopupHandler(JTable tableComp) {
        this.tableComp = tableComp;
    }

    public void performCut() {
        throw new IllegalStateException();
    }

    public void performCopy() {
        int[] columns;
        StringBuilder builder = new StringBuilder();
        int[] rows = this.tableComp.getSelectedRows();
        if (this.tableComp.getSelectionModel().getSelectionMode() == 0) {
            columns = new int[this.tableComp.getColumnCount()];
            for (int i = 0; i < this.tableComp.getColumnCount(); ++i) {
                columns[i] = i;
            }
        } else {
            columns = this.tableComp.getSelectedColumns();
        }
        boolean empty = true;
        for (int rowIndex : rows) {
            if (!empty) {
                builder.append(System.getProperty("line.separator"));
            } else {
                empty = false;
            }
            boolean columnEmpty = true;
            for (int columnIndex : columns) {
                if (!columnEmpty) {
                    builder.append("\t");
                } else {
                    columnEmpty = false;
                }
                Object value = this.tableComp.getModel().getValueAt(rowIndex, columnIndex);
                if (value == null) continue;
                builder.append(value.toString());
            }
        }
        ClipboardUtils.getClipboard().setContents(new StringSelection(builder.toString()), null);
    }

    public void performPaste() {
        throw new IllegalStateException();
    }

    public void performDelete() {
        throw new IllegalStateException();
    }

    public void performSelectAll() {
        this.tableComp.selectAll();
    }

    public boolean isSelection() {
        return this.tableComp.isEnabled() && (this.tableComp.getSelectedColumn() >= 0 || this.tableComp.getSelectedRow() >= 0);
    }

    public boolean isEditable() {
        return false;
    }

    public boolean canSelectAll() {
        return this.tableComp.isEnabled() && this.tableComp.getSelectionModel().getSelectionMode() != 0 && this.tableComp.getModel().getRowCount() > 0;
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
    }

    public boolean canPaste() {
        return true;
    }

    public boolean canDelete() {
        return false;
    }
}

