/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.popup;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.exbin.framework.popup.ImageActionsHandler;
import org.exbin.framework.popup.LinkActionsHandler;
import org.exbin.framework.popup.PositionImageActionsHandler;
import org.exbin.framework.popup.PositionLinkActionsHandler;
import org.exbin.framework.popup.PositionTextActionsHandler;
import org.exbin.framework.popup.TextActionsHandler;
import org.exbin.framework.popup.handler.EditorPanePopupHandler;
import org.exbin.framework.popup.handler.ListPopupHandler;
import org.exbin.framework.popup.handler.TablePopupHandler;
import org.exbin.framework.popup.handler.TextComponentPopupHandler;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ComponentPopupEventDispatcher;
import org.exbin.framework.utils.LanguageUtils;

@ParametersAreNonnullByDefault
public class DefaultPopupMenu {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(DefaultPopupMenu.class);
    public static final String DELETE_ACTION = "delete";
    public static final String SELECT_ALL_ACTION = "selectAll";
    public static final String POPUP_COPY_ACTION_ID = "popupCopyAction";
    public static final String POPUP_COPY_TEXT_ACTION_ID = "popupCopyTextAction";
    public static final String POPUP_COPY_LINK_ACTION_ID = "popupCopyLinkAction";
    public static final String POPUP_COPY_IMAGE_ACTION_ID = "popupCopyImageAction";
    public static final String POPUP_CUT_ACTION_ID = "popupCutAction";
    public static final String POPUP_PASTE_ACTION_ID = "popupPasteAction";
    public static final String POPUP_DELETE_ACTION_ID = "popupDeleteAction";
    public static final String POPUP_SELECT_ALL_ACTION_ID = "popupSelectAllAction";
    public static final String POPUP_OPEN_LINK_ACTION_ID = "popupOpenLinkAction";
    public static final String POPUP_COPY_TEXT_ACTION_NAME = "copy-text";
    public static final String POPUP_COPY_LINK_ACTION_NAME = "copy-link";
    public static final String POPUP_COPY_IMAGE_ACTION_NAME = "copy-image";
    public static final String POPUP_OPEN_LINK_ACTION_NAME = "open-link";
    protected ActionMap defaultTextActionMap;
    protected DefaultPopupClipboardAction[] defaultTextActions;
    protected DefaultPopupClipboardAction defaultCutAction;
    protected DefaultPopupClipboardAction defaultCopyAction;
    protected DefaultPopupClipboardAction defaultPasteAction;
    protected DefaultPopupClipboardAction defaultDeleteAction;
    protected DefaultPopupClipboardAction defaultSelectAllAction;
    protected DefaultPopupClipboardAction copyTextAction;
    protected DefaultPopupClipboardAction copyLinkAction;
    protected DefaultPopupClipboardAction openLinkAction;
    protected DefaultPopupClipboardAction copyImageAction;
    protected final List<ComponentPopupEventDispatcher> clipboardEventDispatchers = new ArrayList<ComponentPopupEventDispatcher>();
    private static DefaultPopupMenu instance = null;

    protected DefaultPopupMenu() {
    }

    @Nonnull
    public static synchronized DefaultPopupMenu getInstance() {
        if (instance == null) {
            instance = new DefaultPopupMenu();
        }
        return instance;
    }

    public static void register() {
        DefaultPopupMenu defaultPopupMenu = DefaultPopupMenu.getInstance();
        defaultPopupMenu.initDefaultPopupMenu();
        defaultPopupMenu.registerToEventQueue();
    }

    public static void register(ResourceBundle resourceBundle, Class<?> resourceClass) {
        DefaultPopupMenu defaultPopupMenu = DefaultPopupMenu.getInstance();
        defaultPopupMenu.initDefaultPopupMenu(resourceBundle, resourceClass);
        defaultPopupMenu.registerToEventQueue();
    }

    public void appendTextMenu(JMenu menu, TextActionsHandler handler) {
        menu.add(this.createCopyTextMenuAction(handler));
    }

    public void appendTextMenu(JPopupMenu menu, TextActionsHandler handler) {
        menu.add(this.createCopyTextMenuAction(handler));
    }

    @Nonnull
    public Action createCopyTextMenuAction(final TextActionsHandler handler) {
        Class<DefaultPopupMenu> resourceClass = DefaultPopupMenu.class;
        AbstractAction copyImageMenuAction = new AbstractAction(POPUP_COPY_TEXT_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.performCopyText();
            }
        };
        ActionUtils.setupAction((Action)copyImageMenuAction, (ResourceBundle)this.resourceBundle, resourceClass, (String)POPUP_COPY_TEXT_ACTION_ID);
        copyImageMenuAction.setEnabled(handler.isTextSelected());
        return copyImageMenuAction;
    }

    public void appendLinkMenu(JMenu menu, LinkActionsHandler handler) {
        menu.add(this.createCopyLinkMenuAction(handler));
        menu.add(this.createOpenLinkMenuAction(handler));
    }

    public void appendLinkMenu(JPopupMenu menu, LinkActionsHandler handler) {
        menu.add(this.createCopyLinkMenuAction(handler));
        menu.add(this.createOpenLinkMenuAction(handler));
    }

    @Nonnull
    public Action createCopyLinkMenuAction(final LinkActionsHandler handler) {
        Class<DefaultPopupMenu> resourceClass = DefaultPopupMenu.class;
        AbstractAction copyLinkMenuAction = new AbstractAction(POPUP_COPY_LINK_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.performCopyLink();
            }
        };
        ActionUtils.setupAction((Action)copyLinkMenuAction, (ResourceBundle)this.resourceBundle, resourceClass, (String)POPUP_COPY_LINK_ACTION_ID);
        copyLinkMenuAction.setEnabled(handler.isLinkSelected());
        return copyLinkMenuAction;
    }

    @Nonnull
    public Action createOpenLinkMenuAction(final LinkActionsHandler handler) {
        Class<DefaultPopupMenu> resourceClass = DefaultPopupMenu.class;
        DefaultPopupClipboardAction openLinkMenuAction = new DefaultPopupClipboardAction(POPUP_OPEN_LINK_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.performOpenLink();
            }
        };
        ActionUtils.setupAction((Action)openLinkMenuAction, (ResourceBundle)this.resourceBundle, resourceClass, (String)POPUP_OPEN_LINK_ACTION_ID);
        openLinkMenuAction.setEnabled(handler.isLinkSelected());
        return openLinkMenuAction;
    }

    public void appendImageMenu(JMenu menu, ImageActionsHandler handler) {
        menu.add(this.createCopyImageMenuAction(handler));
    }

    public void appendImageMenu(JPopupMenu menu, ImageActionsHandler handler) {
        menu.add(this.createCopyImageMenuAction(handler));
    }

    @Nonnull
    public Action createCopyImageMenuAction(final ImageActionsHandler handler) {
        Class<DefaultPopupMenu> resourceClass = DefaultPopupMenu.class;
        AbstractAction copyImageMenuAction = new AbstractAction(POPUP_COPY_IMAGE_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.performCopyImage();
            }
        };
        ActionUtils.setupAction((Action)copyImageMenuAction, (ResourceBundle)this.resourceBundle, resourceClass, (String)POPUP_COPY_IMAGE_ACTION_ID);
        copyImageMenuAction.setEnabled(handler.isImageSelected());
        return copyImageMenuAction;
    }

    private void registerToEventQueue() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new PopupEventQueue());
    }

    private void initDefaultPopupMenu() {
        this.initDefaultPopupMenu(this.resourceBundle, this.getClass());
    }

    protected void initDefaultPopupMenu(ResourceBundle resourceBundle, Class<?> resourceClass) {
        this.defaultTextActionMap = new ActionMap();
        this.defaultCutAction = new DefaultPopupClipboardAction("cut-to-clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.clipboardHandler.performCut();
            }

            @Override
            public void updateFor(ClipboardActionsHandler clipboardHandler, @Nullable MouseEvent mouseEvent) {
                super.updateFor(clipboardHandler, mouseEvent);
                this.setEnabled(clipboardHandler.isEditable() && clipboardHandler.isSelection());
            }
        };
        ActionUtils.setupAction((Action)this.defaultCutAction, (ResourceBundle)resourceBundle, resourceClass, (String)POPUP_CUT_ACTION_ID);
        this.defaultCutAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, ActionUtils.getMetaMask()));
        this.defaultCutAction.setEnabled(false);
        this.defaultTextActionMap.put(TransferHandler.getCutAction().getValue("Name"), this.defaultCutAction);
        this.defaultCopyAction = new DefaultPopupClipboardAction("copy-to-clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.clipboardHandler.performCopy();
            }

            @Override
            public void updateFor(ClipboardActionsHandler clipboardHandler, @Nullable MouseEvent mouseEvent) {
                super.updateFor(clipboardHandler, mouseEvent);
                this.setEnabled(clipboardHandler.isSelection());
            }
        };
        ActionUtils.setupAction((Action)this.defaultCopyAction, (ResourceBundle)resourceBundle, resourceClass, (String)POPUP_COPY_ACTION_ID);
        this.defaultCopyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, ActionUtils.getMetaMask()));
        this.defaultCopyAction.setEnabled(false);
        this.defaultTextActionMap.put(TransferHandler.getCopyAction().getValue("Name"), this.defaultCopyAction);
        this.defaultPasteAction = new DefaultPopupClipboardAction("paste-from-clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.clipboardHandler.performPaste();
            }

            @Override
            public void updateFor(ClipboardActionsHandler clipboardHandler, @Nullable MouseEvent mouseEvent) {
                super.updateFor(clipboardHandler, mouseEvent);
                this.setEnabled(clipboardHandler.isEditable());
            }
        };
        ActionUtils.setupAction((Action)this.defaultPasteAction, (ResourceBundle)resourceBundle, resourceClass, (String)POPUP_PASTE_ACTION_ID);
        this.defaultPasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, ActionUtils.getMetaMask()));
        this.defaultPasteAction.setEnabled(false);
        this.defaultTextActionMap.put(TransferHandler.getPasteAction().getValue("Name"), this.defaultPasteAction);
        this.defaultDeleteAction = new DefaultPopupClipboardAction("delete-next"){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.clipboardHandler.performDelete();
            }

            @Override
            public void updateFor(ClipboardActionsHandler clipboardHandler, @Nullable MouseEvent mouseEvent) {
                super.updateFor(clipboardHandler, mouseEvent);
                this.setEnabled(clipboardHandler.canDelete() && clipboardHandler.isSelection());
            }
        };
        ActionUtils.setupAction((Action)this.defaultDeleteAction, (ResourceBundle)resourceBundle, resourceClass, (String)POPUP_DELETE_ACTION_ID);
        this.defaultDeleteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        this.defaultDeleteAction.setEnabled(false);
        this.defaultTextActionMap.put(DELETE_ACTION, this.defaultDeleteAction);
        this.defaultSelectAllAction = new DefaultPopupClipboardAction("select-all"){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.clipboardHandler.performSelectAll();
            }

            @Override
            public void updateFor(ClipboardActionsHandler clipboardHandler, @Nullable MouseEvent mouseEvent) {
                super.updateFor(clipboardHandler, mouseEvent);
                this.setEnabled(clipboardHandler.canSelectAll());
            }
        };
        ActionUtils.setupAction((Action)this.defaultSelectAllAction, (ResourceBundle)resourceBundle, resourceClass, (String)POPUP_SELECT_ALL_ACTION_ID);
        this.defaultSelectAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, ActionUtils.getMetaMask()));
        this.defaultTextActionMap.put(SELECT_ALL_ACTION, this.defaultSelectAllAction);
        this.defaultTextActions = new DefaultPopupClipboardAction[]{this.defaultCutAction, this.defaultCopyAction, this.defaultPasteAction, this.defaultDeleteAction, this.defaultSelectAllAction};
        this.copyTextAction = new DefaultPopupClipboardAction(POPUP_COPY_TEXT_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.mouseEvent != null && this.clipboardHandler instanceof PositionTextActionsHandler) {
                    ((PositionTextActionsHandler)this.clipboardHandler).performCopyText(this.mouseEvent.getLocationOnScreen());
                } else {
                    ((TextActionsHandler)this.clipboardHandler).performCopyText();
                }
            }

            @Override
            public void updateFor(ClipboardActionsHandler clipboardHandler, @Nullable MouseEvent mouseEvent) {
                super.updateFor(clipboardHandler, mouseEvent);
                boolean updateEnabled = mouseEvent != null && clipboardHandler instanceof PositionTextActionsHandler ? ((PositionTextActionsHandler)clipboardHandler).isTextSelected(mouseEvent.getLocationOnScreen()) : clipboardHandler instanceof TextActionsHandler && ((TextActionsHandler)clipboardHandler).isTextSelected();
                this.setEnabled(updateEnabled);
            }
        };
        ActionUtils.setupAction((Action)this.copyTextAction, (ResourceBundle)resourceBundle, resourceClass, (String)POPUP_COPY_TEXT_ACTION_ID);
        this.copyLinkAction = new DefaultPopupClipboardAction(POPUP_COPY_LINK_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.mouseEvent != null && this.clipboardHandler instanceof PositionLinkActionsHandler) {
                    ((PositionLinkActionsHandler)this.clipboardHandler).performCopyLink(this.mouseEvent.getLocationOnScreen());
                } else {
                    ((LinkActionsHandler)this.clipboardHandler).performCopyLink();
                }
            }

            @Override
            public void updateFor(ClipboardActionsHandler clipboardHandler, @Nullable MouseEvent mouseEvent) {
                super.updateFor(clipboardHandler, mouseEvent);
                boolean updateEnabled = mouseEvent != null && clipboardHandler instanceof PositionLinkActionsHandler ? ((PositionLinkActionsHandler)clipboardHandler).isLinkSelected(mouseEvent.getLocationOnScreen()) : clipboardHandler instanceof LinkActionsHandler && ((LinkActionsHandler)clipboardHandler).isLinkSelected();
                this.setEnabled(updateEnabled);
            }
        };
        ActionUtils.setupAction((Action)this.copyLinkAction, (ResourceBundle)resourceBundle, resourceClass, (String)POPUP_COPY_LINK_ACTION_ID);
        this.openLinkAction = new DefaultPopupClipboardAction(POPUP_OPEN_LINK_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.mouseEvent != null && this.clipboardHandler instanceof PositionLinkActionsHandler) {
                    ((PositionLinkActionsHandler)this.clipboardHandler).performOpenLink(this.mouseEvent.getLocationOnScreen());
                } else {
                    ((LinkActionsHandler)this.clipboardHandler).performOpenLink();
                }
            }

            @Override
            public void updateFor(ClipboardActionsHandler clipboardHandler, @Nullable MouseEvent mouseEvent) {
                super.updateFor(clipboardHandler, mouseEvent);
                boolean updateEnabled = mouseEvent != null && clipboardHandler instanceof PositionLinkActionsHandler ? ((PositionLinkActionsHandler)clipboardHandler).isLinkSelected(mouseEvent.getLocationOnScreen()) : clipboardHandler instanceof LinkActionsHandler && ((LinkActionsHandler)clipboardHandler).isLinkSelected();
                this.setEnabled(updateEnabled);
            }
        };
        ActionUtils.setupAction((Action)this.openLinkAction, (ResourceBundle)resourceBundle, resourceClass, (String)POPUP_OPEN_LINK_ACTION_ID);
        this.copyImageAction = new DefaultPopupClipboardAction(POPUP_COPY_IMAGE_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.mouseEvent != null && this.clipboardHandler instanceof PositionImageActionsHandler) {
                    ((PositionImageActionsHandler)this.clipboardHandler).performCopyImage(this.mouseEvent.getLocationOnScreen());
                } else {
                    ((ImageActionsHandler)this.clipboardHandler).performCopyImage();
                }
            }

            @Override
            public void updateFor(ClipboardActionsHandler clipboardHandler, @Nullable MouseEvent mouseEvent) {
                super.updateFor(clipboardHandler, mouseEvent);
                boolean updateEnabled = mouseEvent != null && clipboardHandler instanceof PositionImageActionsHandler ? ((PositionImageActionsHandler)clipboardHandler).isImageSelected(mouseEvent.getLocationOnScreen()) : clipboardHandler instanceof ImageActionsHandler && ((ImageActionsHandler)clipboardHandler).isImageSelected();
                this.setEnabled(updateEnabled);
            }
        };
        ActionUtils.setupAction((Action)this.copyImageAction, (ResourceBundle)resourceBundle, resourceClass, (String)POPUP_COPY_IMAGE_ACTION_ID);
    }

    public void fillDefaultPopupMenu(JPopupMenu popupMenu, int position) {
        JMenuItem basicPopupCopyMenuItem = new JMenuItem();
        JMenuItem basicPopupSelectAllMenuItem = new JMenuItem();
        basicPopupCopyMenuItem.setAction(this.defaultCopyAction);
        basicPopupCopyMenuItem.setName("basicEditPopupCopyMenuItem");
        basicPopupSelectAllMenuItem.setAction(this.defaultSelectAllAction);
        basicPopupSelectAllMenuItem.setName("basicEditPopupSelectAllMenuItem");
        if (position >= 0) {
            popupMenu.insert(basicPopupCopyMenuItem, position);
            popupMenu.insert(new JPopupMenu.Separator(), position + 1);
            popupMenu.insert(basicPopupSelectAllMenuItem, position + 2);
        } else {
            popupMenu.add(basicPopupCopyMenuItem);
            popupMenu.addSeparator();
            popupMenu.add(basicPopupSelectAllMenuItem);
        }
    }

    public void fillDefaultEditPopupMenu(JPopupMenu popupMenu, int position) {
        JMenuItem basicPopupCutMenuItem = new JMenuItem();
        JMenuItem basicPopupCopyMenuItem = new JMenuItem();
        JMenuItem basicPopupPasteMenuItem = new JMenuItem();
        JMenuItem basicPopupDeleteMenuItem = new JMenuItem();
        JMenuItem basicPopupSelectAllMenuItem = new JMenuItem();
        basicPopupCutMenuItem.setAction(this.defaultCutAction);
        basicPopupCutMenuItem.setName("basicPopupCutMenuItem");
        basicPopupCopyMenuItem.setAction(this.defaultCopyAction);
        basicPopupCopyMenuItem.setName("basicPopupCopyMenuItem");
        basicPopupPasteMenuItem.setAction(this.defaultPasteAction);
        basicPopupPasteMenuItem.setName("basicPopupPasteMenuItem");
        basicPopupDeleteMenuItem.setAction(this.defaultDeleteAction);
        basicPopupDeleteMenuItem.setName("basicPopupDeleteMenuItem");
        basicPopupSelectAllMenuItem.setAction(this.defaultSelectAllAction);
        basicPopupSelectAllMenuItem.setName("basicPopupSelectAllMenuItem");
        if (position >= 0) {
            popupMenu.insert(basicPopupCutMenuItem, position);
            popupMenu.insert(basicPopupCopyMenuItem, position + 1);
            popupMenu.insert(basicPopupPasteMenuItem, position + 2);
            popupMenu.insert(basicPopupDeleteMenuItem, position + 3);
            popupMenu.insert(new JPopupMenu.Separator(), position + 4);
            popupMenu.insert(basicPopupSelectAllMenuItem, position + 5);
        } else {
            popupMenu.add(basicPopupCutMenuItem);
            popupMenu.add(basicPopupCopyMenuItem);
            popupMenu.add(basicPopupPasteMenuItem);
            popupMenu.add(basicPopupDeleteMenuItem);
            popupMenu.addSeparator();
            popupMenu.add(basicPopupSelectAllMenuItem);
        }
    }

    public void addClipboardEventDispatcher(ComponentPopupEventDispatcher dispatcher) {
        this.clipboardEventDispatchers.add(dispatcher);
    }

    public void removeClipboardEventDispatcher(ComponentPopupEventDispatcher dispatcher) {
        this.clipboardEventDispatchers.remove(dispatcher);
    }

    protected void processAWTEvent(AWTEvent event) {
        KeyEvent keyEvent;
        if (event.getID() == 502 || event.getID() == 501) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (mouseEvent.isPopupTrigger()) {
                if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
                    return;
                }
                for (ComponentPopupEventDispatcher dispatcher : this.clipboardEventDispatchers) {
                    if (!dispatcher.dispatchMouseEvent(mouseEvent)) continue;
                    return;
                }
                Component component = this.getSource(mouseEvent);
                if (component instanceof JViewport) {
                    component = ((JViewport)component).getView();
                }
                if (component instanceof JEditorPane) {
                    this.activateMousePopup(mouseEvent, component, new EditorPanePopupHandler((JEditorPane)component));
                } else if (component instanceof JTextComponent) {
                    this.activateMousePopup(mouseEvent, component, new TextComponentPopupHandler((JTextComponent)component));
                } else if (component instanceof JList) {
                    this.activateMousePopup(mouseEvent, component, new ListPopupHandler((JList)component));
                } else if (component instanceof JTable) {
                    this.activateMousePopup(mouseEvent, component, new TablePopupHandler((JTable)component));
                }
            }
        } else if (event.getID() == 401 && ((keyEvent = (KeyEvent)event).getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown())) {
            Point point;
            if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
                return;
            }
            for (ComponentPopupEventDispatcher dispatcher : this.clipboardEventDispatchers) {
                if (!dispatcher.dispatchKeyEvent(keyEvent)) continue;
                return;
            }
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component instanceof JEditorPane) {
                try {
                    Rectangle relativeRect = ((JEditorPane)component).modelToView(((JTextComponent)component).getCaretPosition());
                    point = relativeRect == null ? null : new Point(relativeRect.x + relativeRect.width, relativeRect.y + relativeRect.height);
                }
                catch (BadLocationException ex) {
                    point = null;
                }
                this.activateKeyPopup(component, point, new EditorPanePopupHandler((JEditorPane)component));
            } else if (component instanceof JTextComponent) {
                try {
                    Rectangle relativeRect = ((JTextComponent)component).modelToView(((JTextComponent)component).getCaretPosition());
                    point = relativeRect == null ? null : new Point(relativeRect.x + relativeRect.width, relativeRect.y + relativeRect.height);
                }
                catch (BadLocationException ex) {
                    point = null;
                }
                this.activateKeyPopup(component, point, new TextComponentPopupHandler((JTextComponent)component));
            } else if (component instanceof JList) {
                point = null;
                int selectedIndex = ((JList)component).getSelectedIndex();
                if (selectedIndex >= 0) {
                    Rectangle cellBounds = ((JList)component).getCellBounds(selectedIndex, selectedIndex);
                    point = new Point(component.getWidth() / 2, cellBounds.y);
                }
                this.activateKeyPopup(component, point, new ListPopupHandler((JList)component));
            } else if (component instanceof JTable) {
                point = null;
                int selectedRow = ((JTable)component).getSelectedRow();
                if (selectedRow >= 0) {
                    int selectedColumn = ((JTable)component).getSelectedColumn();
                    if (selectedColumn < -1) {
                        selectedColumn = 0;
                    }
                    Rectangle cellBounds = ((JTable)component).getCellRect(selectedRow, selectedColumn, false);
                    point = new Point(cellBounds.x, cellBounds.y);
                }
                this.activateKeyPopup(component, point, new TablePopupHandler((JTable)component));
            }
        }
    }

    protected void activateMousePopup(MouseEvent mouseEvent, Component component, ClipboardActionsHandler clipboardHandler) {
        for (DefaultPopupClipboardAction action : this.defaultTextActions) {
            action.updateFor(clipboardHandler, mouseEvent);
            this.copyTextAction.updateFor(clipboardHandler, mouseEvent);
            this.copyLinkAction.updateFor(clipboardHandler, mouseEvent);
            this.openLinkAction.updateFor(clipboardHandler, mouseEvent);
            this.copyImageAction.updateFor(clipboardHandler, mouseEvent);
        }
        Point point = mouseEvent.getLocationOnScreen();
        Point locationOnScreen = component.getLocationOnScreen();
        point.translate(-locationOnScreen.x, -locationOnScreen.y);
        this.showPopupMenu(component, point, clipboardHandler);
    }

    protected void activateKeyPopup(Component component, @Nullable Point point, ClipboardActionsHandler clipboardHandler) {
        for (DefaultPopupClipboardAction action : this.defaultTextActions) {
            action.updateFor(clipboardHandler, null);
            this.copyTextAction.updateFor(clipboardHandler, null);
            this.copyLinkAction.updateFor(clipboardHandler, null);
            this.openLinkAction.updateFor(clipboardHandler, null);
            this.copyImageAction.updateFor(clipboardHandler, null);
        }
        if (point == null) {
            point = component.getParent() instanceof ScrollPane ? new Point(component.getWidth() / 2, component.getHeight() / 2) : new Point(component.getWidth() / 2, component.getHeight() / 2);
        }
        this.showPopupMenu(component, point, clipboardHandler);
    }

    protected void showPopupMenu(Component component, Point point, ClipboardActionsHandler handler) {
        boolean editable = handler.isEditable();
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setName("defaultPopupMenu");
        boolean hasExtra = false;
        if (handler instanceof TextActionsHandler && this.copyTextAction.isEnabled()) {
            JMenuItem copyTextMenuItem = new JMenuItem();
            copyTextMenuItem.setAction(this.copyTextAction);
            copyTextMenuItem.setName("basicCopyTextMenuItem");
            popupMenu.add(copyTextMenuItem);
            hasExtra = true;
        }
        if (handler instanceof ImageActionsHandler && this.copyImageAction.isEnabled()) {
            JMenuItem copyImageMenuItem = new JMenuItem();
            copyImageMenuItem.setAction(this.copyImageAction);
            copyImageMenuItem.setName("basicCopyImageMenuItem");
            popupMenu.add(copyImageMenuItem);
            hasExtra = true;
        }
        if (handler instanceof LinkActionsHandler) {
            if (this.openLinkAction.isEnabled()) {
                JMenuItem openLinkMenuItem = new JMenuItem();
                openLinkMenuItem.setAction(this.openLinkAction);
                openLinkMenuItem.setName("basicOpenLinkMenuItem");
                popupMenu.add(openLinkMenuItem);
                hasExtra = true;
            }
            if (this.copyLinkAction.isEnabled()) {
                JMenuItem copyLinkMenuItem = new JMenuItem();
                copyLinkMenuItem.setAction(this.copyLinkAction);
                copyLinkMenuItem.setName("basicCopyLinkMenuItem");
                popupMenu.add(copyLinkMenuItem);
                hasExtra = true;
            }
        }
        if (hasExtra) {
            popupMenu.addSeparator();
        }
        if (editable) {
            this.fillDefaultEditPopupMenu(popupMenu, -1);
        } else {
            this.fillDefaultPopupMenu(popupMenu, -1);
        }
        popupMenu.show(component, (int)point.getX(), (int)point.getY());
        popupMenu.grabFocus();
    }

    @Nullable
    protected Component getSource(MouseEvent e) {
        return SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY());
    }

    @ParametersAreNonnullByDefault
    protected static abstract class DefaultPopupClipboardAction
    extends AbstractAction {
        protected ClipboardActionsHandler clipboardHandler;
        protected MouseEvent mouseEvent;

        public DefaultPopupClipboardAction(String name) {
            super(name);
        }

        public void updateFor(ClipboardActionsHandler clipboardHandler, @Nullable MouseEvent mouseEvent) {
            this.clipboardHandler = clipboardHandler;
            this.mouseEvent = mouseEvent;
        }
    }

    @ParametersAreNonnullByDefault
    public class PopupEventQueue
    extends EventQueue {
        @Override
        protected void dispatchEvent(AWTEvent event) {
            super.dispatchEvent(event);
            DefaultPopupMenu.this.processAWTEvent(event);
        }
    }
}

