/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.options.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.editor.text.options.TextEncodingOptions;
import org.exbin.framework.editor.text.preferences.TextEncodingPreferences;
import org.exbin.framework.options.api.OptionsData;

@ParametersAreNonnullByDefault
public class TextEncodingOptionsImpl
implements TextEncodingOptions,
OptionsData {
    private String selectedEncoding = "UTF-8";
    private List<String> encodings = new ArrayList<String>();

    @Override
    @Nonnull
    public String getSelectedEncoding() {
        return this.selectedEncoding;
    }

    @Override
    @Nonnull
    public void setSelectedEncoding(String selectedEncoding) {
        this.selectedEncoding = selectedEncoding;
    }

    @Override
    @Nonnull
    public List<String> getEncodings() {
        return this.encodings;
    }

    @Override
    public void setEncodings(List<String> encodings) {
        this.encodings = encodings;
    }

    public void loadFromPreferences(TextEncodingPreferences preferences) {
        this.selectedEncoding = preferences.getSelectedEncoding();
        this.encodings = preferences.getEncodings();
    }

    public void saveToPreferences(TextEncodingPreferences preferences) {
        preferences.setSelectedEncoding(this.selectedEncoding);
        preferences.setEncodings(this.encodings);
    }

    public void setOptions(TextEncodingOptionsImpl options) {
        this.selectedEncoding = options.selectedEncoding;
        this.encodings = new ArrayList<String>();
        this.encodings.addAll(options.encodings);
    }
}

