/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.editor.text.options.gui.TextColorPanel;
import org.exbin.framework.editor.text.options.impl.TextColorOptionsImpl;
import org.exbin.framework.editor.text.service.TextColorService;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

public class TextColorOptionsPanel
extends JPanel
implements OptionsComponent<TextColorOptionsImpl> {
    private OptionsModifiedListener optionsModifiedListener;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(TextColorOptionsPanel.class);
    private TextColorService textColorService;
    private final TextColorPanel colorPanel = new TextColorPanel();
    private JCheckBox defaultColorCheckBox;
    private JPanel defaultColorPanel;
    private JColorChooser jColorChooser1;

    public TextColorOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.colorPanel.setEnabled(false);
        super.add((Component)this.colorPanel, "Center");
    }

    public void setTextColorService(TextColorService textColorService) {
        this.textColorService = textColorService;
        this.colorPanel.setTextColorService(textColorService);
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(TextColorOptionsImpl options) {
        boolean defaultColor = options.isUseDefaultColors();
        this.defaultColorCheckBox.setSelected(defaultColor);
        this.colorPanel.setEnabled(!defaultColor);
        this.colorPanel.loadFromOptions(options);
    }

    public void saveToOptions(TextColorOptionsImpl options) {
        options.setUseDefaultColors(this.defaultColorCheckBox.isSelected());
        this.colorPanel.saveToOptions(options);
    }

    private void initComponents() {
        this.jColorChooser1 = new JColorChooser();
        this.defaultColorPanel = new JPanel();
        this.defaultColorCheckBox = new JCheckBox();
        this.jColorChooser1.setName("jColorChooser1");
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.defaultColorPanel.setName("defaultColorPanel");
        this.defaultColorCheckBox.setSelected(true);
        this.defaultColorCheckBox.setText(this.resourceBundle.getString("defaultColorCheckBox.text"));
        this.defaultColorCheckBox.setName("defaultColorCheckBox");
        this.defaultColorCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextColorOptionsPanel.this.defaultColorCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout defaultColorPanelLayout = new GroupLayout(this.defaultColorPanel);
        this.defaultColorPanel.setLayout(defaultColorPanelLayout);
        defaultColorPanelLayout.setHorizontalGroup(defaultColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultColorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.defaultColorCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        defaultColorPanelLayout.setVerticalGroup(defaultColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultColorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.defaultColorCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.defaultColorPanel, "North");
    }

    private void defaultColorCheckBoxItemStateChanged(ItemEvent evt) {
        boolean checked = evt.getStateChange() != 1;
        this.colorPanel.setEnabled(checked);
        this.setModified(true);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextColorOptionsPanel());
    }

    private void setModified(boolean b) {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
        this.colorPanel.setOptionsModifiedListener(listener);
    }
}

