/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.gui;

import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class TextPanelCompoundUndoManager
extends AbstractUndoableEdit
implements UndoableEditListener {
    private DocumentEvent.EventType lastEditType = null;
    private final ArrayList<MyCompoundEdit> edits = new ArrayList();
    private MyCompoundEdit current;
    private int pointer = -1;
    private int lastOffset = -1;

    TextPanelCompoundUndoManager() {
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        UndoableEdit edit = e.getEdit();
        if (edit instanceof AbstractDocument.DefaultDocumentEvent) {
            DocumentEvent.EventType editType = ((AbstractDocument.DefaultDocumentEvent)edit).getType();
            AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent)edit;
            int offset = event.getOffset();
            boolean isNeedStart = false;
            if (this.current == null) {
                isNeedStart = true;
            } else if (this.lastEditType == null || !this.lastEditType.equals(editType)) {
                isNeedStart = true;
            } else if (this.lastEditType == DocumentEvent.EventType.INSERT) {
                if (offset != this.lastOffset + 1) {
                    isNeedStart = true;
                }
            } else if (this.lastEditType == DocumentEvent.EventType.REMOVE && offset != this.lastOffset - 1) {
                isNeedStart = true;
            }
            while (this.pointer < this.edits.size() - 1) {
                this.edits.remove(this.edits.size() - 1);
                isNeedStart = true;
            }
            if (isNeedStart) {
                this.createCompoundEdit();
            }
            this.current.addEdit(edit);
            this.lastEditType = editType;
            this.lastOffset = offset;
        }
    }

    public void createCompoundEdit() {
        if (this.current == null) {
            this.current = new MyCompoundEdit();
        } else if (this.current.getLength() > 0) {
            this.current = new MyCompoundEdit();
        }
        this.edits.add(this.current);
        ++this.pointer;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        MyCompoundEdit u = this.edits.get(this.pointer);
        u.undo();
        --this.pointer;
        this.lastOffset = -1;
        this.lastEditType = null;
    }

    @Override
    public void redo() throws CannotUndoException {
        if (!this.canRedo()) {
            throw new CannotUndoException();
        }
        ++this.pointer;
        MyCompoundEdit u = this.edits.get(this.pointer);
        u.redo();
        this.lastOffset = -1;
        this.lastEditType = null;
    }

    @Override
    public boolean canUndo() {
        return this.pointer >= 0;
    }

    @Override
    public boolean canRedo() {
        return this.edits.size() > 0 && this.pointer < this.edits.size() - 1;
    }

    class MyCompoundEdit
    extends CompoundEdit {
        boolean isUnDone = false;

        MyCompoundEdit() {
        }

        public int getLength() {
            return this.edits.size();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.isUnDone = true;
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.isUnDone = false;
        }

        @Override
        public boolean canUndo() {
            return this.edits.size() > 0 && !this.isUnDone;
        }

        @Override
        public boolean canRedo() {
            return this.edits.size() > 0 && this.isUnDone;
        }
    }
}

