/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.TextFontApi;
import org.exbin.framework.editor.text.gui.TextFontPanel;
import org.exbin.framework.editor.text.preferences.TextFontPreferences;
import org.exbin.framework.file.api.FileDependentAction;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.OptionsControlPanel;
import org.exbin.framework.utils.handler.OptionsControlHandler;

@ParametersAreNonnullByDefault
public class TextFontAction
extends AbstractAction
implements FileDependentAction {
    public static final String ACTION_ID = "toolsSetFontAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    public void updateForActiveFile() {
        Optional activeFile = this.editorProvider.getActiveFile();
        this.setEnabled(activeFile.isPresent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        TextFontApi textFontApi = (TextFontApi)activeFile.get();
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        TextFontPanel fontPanel = new TextFontPanel();
        fontPanel.setStoredFont(textFontApi.getCurrentFont());
        OptionsControlPanel controlPanel = new OptionsControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)fontPanel, (JPanel)controlPanel);
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), fontPanel.getClass(), (ResourceBundle)fontPanel.getResourceBundle());
        frameModule.setDialogTitle(dialog, fontPanel.getResourceBundle());
        controlPanel.setHandler(actionType -> {
            if (actionType != OptionsControlHandler.ControlActionType.CANCEL) {
                if (actionType == OptionsControlHandler.ControlActionType.SAVE) {
                    TextFontPreferences parameters = new TextFontPreferences(this.application.getAppPreferences());
                    parameters.setUseDefaultFont(false);
                    parameters.setFont(fontPanel.getStoredFont());
                }
                textFontApi.setCurrentFont(fontPanel.getStoredFont());
            }
            dialog.close();
            dialog.dispose();
        });
        dialog.showCentered((Component)frameModule.getFrame());
    }
}

