/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.text.TextEditor;
import org.exbin.framework.editor.text.gui.FindTextPanel;
import org.exbin.framework.editor.text.service.TextSearchService;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;

@ParametersAreNonnullByDefault
public class FindReplaceActions {
    public static final String EDIT_FIND_ACTION_ID = "editFindAction";
    public static final String EDIT_FIND_AGAIN_ACTION_ID = "editFindAgainAction";
    public static final String EDIT_REPLACE_ACTION_ID = "editReplaceAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action editFindAction;
    private Action editFindAgainAction;
    private Action editReplaceAction;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
    }

    public void showFindDialog(boolean shallReplace) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        FindTextPanel findPanel = new FindTextPanel();
        findPanel.setShallReplace(shallReplace);
        findPanel.setSelected();
        DefaultControlPanel controlPanel = new DefaultControlPanel(findPanel.getResourceBundle());
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)findPanel, (JPanel)controlPanel);
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK && this.editorProvider instanceof TextEditor) {
                TextSearchService.FindTextParameters findTextParameters = new TextSearchService.FindTextParameters();
                findTextParameters.setFindText(findPanel.getFindText());
                findTextParameters.setSearchFromStart(findPanel.isSearchFromStart());
                findTextParameters.setShallReplace(findPanel.isShallReplace());
                findTextParameters.setReplaceText(findPanel.getReplaceText());
                ((TextEditor)this.editorProvider).getEditorComponent().findText(findTextParameters);
            }
            dialog.close();
            dialog.dispose();
        });
        WindowUtils.addHeaderPanel((Window)dialog.getWindow(), findPanel.getClass(), (ResourceBundle)findPanel.getResourceBundle());
        frameModule.setDialogTitle(dialog, findPanel.getResourceBundle());
        dialog.showCentered((Component)frameModule.getFrame());
    }

    @Nonnull
    public Action getEditFindAction() {
        if (this.editFindAction == null) {
            this.editFindAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindReplaceActions.this.showFindDialog(false);
                }
            };
            ActionUtils.setupAction((Action)this.editFindAction, (ResourceBundle)this.resourceBundle, (String)EDIT_FIND_ACTION_ID);
            this.editFindAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, ActionUtils.getMetaMask()));
            this.editFindAction.putValue("dialogMode", true);
        }
        return this.editFindAction;
    }

    @Nonnull
    public Action getEditFindAgainAction() {
        if (this.editFindAgainAction == null) {
            this.editFindAgainAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindReplaceActions.this.showFindDialog(false);
                }
            };
            ActionUtils.setupAction((Action)this.editFindAgainAction, (ResourceBundle)this.resourceBundle, (String)EDIT_FIND_AGAIN_ACTION_ID);
            this.editFindAgainAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
        }
        return this.editFindAgainAction;
    }

    @Nonnull
    public Action getEditReplaceAction() {
        if (this.editReplaceAction == null) {
            this.editReplaceAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindReplaceActions.this.showFindDialog(true);
                }
            };
            ActionUtils.setupAction((Action)this.editReplaceAction, (ResourceBundle)this.resourceBundle, (String)EDIT_REPLACE_ACTION_ID);
            this.editReplaceAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, ActionUtils.getMetaMask()));
            this.editReplaceAction.putValue("dialogMode", true);
        }
        return this.editReplaceAction;
    }
}

