/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.options.preferences;

import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.options.options.AppearanceOptions;

@ParametersAreNonnullByDefault
public class AppearancePreferences
implements AppearanceOptions {
    public static final String PREFERENCES_TOOLBAR_VISIBLE = "toolBar.visible";
    public static final String PREFERENCES_TOOLBAR_CAPTIONS = "toolBar.captions";
    public static final String PREFERENCES_STATUSBAR_VISIBLE = "statusBar.visible";
    private final Preferences preferences;

    public AppearancePreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public boolean isShowToolBar() {
        return this.preferences.getBoolean(PREFERENCES_TOOLBAR_VISIBLE, true);
    }

    @Override
    public boolean isShowToolBarCaptions() {
        return this.preferences.getBoolean(PREFERENCES_TOOLBAR_CAPTIONS, true);
    }

    @Override
    public boolean isShowStatusBar() {
        return this.preferences.getBoolean(PREFERENCES_STATUSBAR_VISIBLE, true);
    }

    @Override
    public void setShowToolBar(boolean show) {
        this.preferences.putBoolean(PREFERENCES_TOOLBAR_VISIBLE, show);
    }

    @Override
    public void setShowToolBarCaptions(boolean show) {
        this.preferences.putBoolean(PREFERENCES_TOOLBAR_CAPTIONS, show);
    }

    @Override
    public void setShowStatusBar(boolean show) {
        this.preferences.putBoolean(PREFERENCES_STATUSBAR_VISIBLE, show);
    }
}

