/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.options;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum GuiMacOsAppearance {
    DEFAULT(""),
    LIGHT("light"),
    DARK("dark"),
    SYSTEM("system");

    private final String propertyValue;

    private GuiMacOsAppearance(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    @Nonnull
    public String getPropertyValue() {
        return this.propertyValue;
    }

    @Nonnull
    public static Optional<GuiMacOsAppearance> fromPropertyValue(String propertyValue) {
        for (GuiMacOsAppearance method : GuiMacOsAppearance.values()) {
            if (!propertyValue.equals(method.getPropertyValue())) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    @Nonnull
    public static List<GuiMacOsAppearance> getAvailable() {
        return new ArrayList<GuiMacOsAppearance>(Arrays.asList(GuiMacOsAppearance.values()));
    }
}

