/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.spec.gui;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;

@ParametersAreNonnullByDefault
public class CatalogSelectSpecTreeModel
implements TreeModel {
    private XBCNodeService nodeService = null;
    private XBCSpecService specService = null;
    private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();
    private final CatalogItemType specType;

    public CatalogSelectSpecTreeModel(XBACatalog catalog, CatalogItemType specType) {
        this.specType = specType;
        this.nodeService = catalog == null ? null : (XBCNodeService)catalog.getCatalogService(XBCNodeService.class);
        this.specService = catalog == null ? null : (XBCSpecService)catalog.getCatalogService(XBCSpecService.class);
    }

    @Override
    @Nullable
    public Object getRoot() {
        return this.nodeService == null ? null : this.nodeService.getMainRootNode().get();
    }

    @Override
    public Object getChild(@Nullable Object parent, int index) {
        if (parent == null) {
            return null;
        }
        long subNodesCount = this.nodeService.getSubNodesCount((XBCNode)parent);
        if ((long)index < subNodesCount) {
            return this.nodeService.getSubNodeSeq((XBCNode)parent, (long)index);
        }
        switch (this.specType) {
            case BLOCK: {
                return this.specService.getBlockSpec((XBCNode)parent, (long)index - subNodesCount);
            }
            case GROUP: {
                return this.specService.getGroupSpec((XBCNode)parent, (long)index - subNodesCount);
            }
            case FORMAT: {
                return this.specService.getFormatSpec((XBCNode)parent, (long)index - subNodesCount);
            }
        }
        return null;
    }

    @Override
    public int getChildCount(@Nullable Object parent) {
        if (parent == null) {
            throw new NullPointerException("No parent");
        }
        int childrenCount = (int)this.nodeService.getSubNodesSeq((XBCNode)parent);
        switch (this.specType) {
            case BLOCK: {
                childrenCount = (int)((long)childrenCount + this.specService.getBlockSpecsCount((XBCNode)parent));
                break;
            }
            case GROUP: {
                childrenCount = (int)((long)childrenCount + this.specService.getGroupSpecsCount((XBCNode)parent));
                break;
            }
            case FORMAT: {
                childrenCount = (int)((long)childrenCount + this.specService.getFormatSpecsCount((XBCNode)parent));
            }
        }
        return childrenCount;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof XBCNode);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int subNodeIndex = this.nodeService.getSubNodes((XBCNode)parent).indexOf(child);
        if (subNodeIndex >= 0) {
            return subNodeIndex;
        }
        int childrenCount = (int)this.nodeService.getSubNodesSeq((XBCNode)parent);
        switch (this.specType) {
            case BLOCK: {
                return this.specService.getBlockSpecs((XBCNode)parent).indexOf(child) + childrenCount;
            }
            case GROUP: {
                return this.specService.getGroupSpecs((XBCNode)parent).indexOf(child) + childrenCount;
            }
            case FORMAT: {
                return this.specService.getFormatSpecs((XBCNode)parent).indexOf(child) + childrenCount;
            }
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.treeModelListeners.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.treeModelListeners.remove(listener);
    }
}

