/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.spec.gui;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;
import org.exbin.framework.data.model.CatalogDefOperationType;
import org.exbin.framework.data.model.CatalogDefsTableItem;
import org.exbin.xbup.core.catalog.base.XBCBlockCons;
import org.exbin.xbup.core.catalog.base.XBCBlockJoin;
import org.exbin.xbup.core.catalog.base.XBCBlockListCons;
import org.exbin.xbup.core.catalog.base.XBCBlockListJoin;
import org.exbin.xbup.core.catalog.base.XBCConsDef;
import org.exbin.xbup.core.catalog.base.XBCJoinDef;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;

@ParametersAreNonnullByDefault
public class CatalogDefsDetailTableModel
extends AbstractTableModel {
    private CatalogDefsTableItem item = null;
    private final String[] columnNames = new String[]{"Property", "Value"};
    private final String[] rowProperties = new String[]{"Name", "Description", "Type", "Type Revision", "Operation", "StringId"};
    private final Class[] columnClasses = new Class[]{String.class, Object.class};

    @Override
    public int getRowCount() {
        if (this.item == null) {
            return 0;
        }
        return 6;
    }

    @Override
    public int getColumnCount() {
        return this.columnClasses.length;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.item == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return this.rowProperties[rowIndex];
            }
            case 1: {
                switch (rowIndex) {
                    case 0: {
                        return this.item.getName();
                    }
                    case 1: {
                        return this.item.getDescription();
                    }
                    case 2: {
                        return this.item.getType();
                    }
                    case 3: {
                        return this.item.getTargetRevision();
                    }
                    case 4: {
                        return this.item.getOperation();
                    }
                    case 5: {
                        return this.item.getStringId();
                    }
                }
            }
        }
        return "";
    }

    @Nullable
    public CatalogDefsTableItem getItem() {
        return this.item;
    }

    public void setItem(CatalogDefsTableItem item) {
        this.item = item;
        this.fireTableDataChanged();
    }

    @Override
    @Nonnull
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    @Nonnull
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    @Nonnull
    public String getOperation(XBCSpecDef specDef) {
        CatalogDefOperationType operation;
        if (specDef instanceof XBCBlockJoin) {
            operation = specDef.getTargetRev().isPresent() ? CatalogDefOperationType.JOIN : CatalogDefOperationType.ATTRIBUTE;
        } else if (specDef instanceof XBCBlockCons) {
            operation = specDef.getTargetRev().isPresent() ? CatalogDefOperationType.CONSIST : CatalogDefOperationType.ANY;
        } else if (specDef instanceof XBCBlockListJoin) {
            operation = specDef.getTargetRev().isPresent() ? CatalogDefOperationType.JOIN_LIST : CatalogDefOperationType.ATTRIBUTE_LIST;
        } else if (specDef instanceof XBCBlockListCons) {
            operation = specDef.getTargetRev().isPresent() ? CatalogDefOperationType.CONSIST_LIST : CatalogDefOperationType.ANY_LIST;
        } else if (specDef instanceof XBCJoinDef) {
            operation = CatalogDefOperationType.JOIN;
        } else if (specDef instanceof XBCConsDef) {
            operation = CatalogDefOperationType.CONSIST;
        } else {
            return "Unknown";
        }
        return operation.getCaption();
    }
}

