/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.spec;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.action.DefaultEditItemActions;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.ComponentModuleApi;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.component.api.toolbar.MoveItemActions;
import org.exbin.framework.component.api.toolbar.MoveItemActionsHandler;
import org.exbin.framework.component.api.toolbar.MoveItemActionsUpdateListener;
import org.exbin.framework.data.model.CatalogDefsTableItem;
import org.exbin.framework.data.model.CatalogDefsTableModel;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.xbup.catalog.item.spec.action.AddItemDefinitionAction;
import org.exbin.framework.xbup.catalog.item.spec.action.EditItemDefinitionAction;
import org.exbin.framework.xbup.catalog.item.spec.action.RemoveItemDefinitionAction;
import org.exbin.framework.xbup.catalog.item.spec.gui.CatalogItemEditDefinitionPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;

@ParametersAreNonnullByDefault
public class CatalogDefinitionEditor {
    private final CatalogItemEditDefinitionPanel catalogEditorPanel;
    private final DefaultEditItemActions editActions;
    private XBApplication application;
    private XBACatalog catalog;
    private JPopupMenu popupMenu;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogDefinitionEditor.class);
    private MoveItemActionsHandler moveItemActionsHandler;
    private AddItemDefinitionAction addDefinitionAction = new AddItemDefinitionAction();
    private EditItemDefinitionAction editDefinitionAction = new EditItemDefinitionAction();
    private RemoveItemDefinitionAction removeDefinitionAction = new RemoveItemDefinitionAction();

    public CatalogDefinitionEditor() {
        this.catalogEditorPanel = new CatalogItemEditDefinitionPanel();
        this.editActions = new DefaultEditItemActions(DefaultEditItemActions.Mode.DIALOG);
        this.editActions.setEditItemActionsHandler(new EditItemActionsHandler(){

            public void performAddItem() {
                CatalogDefinitionEditor.this.addDefinitionAction.actionPerformed(null);
                CatalogDefsTableItem resultDefinition = CatalogDefinitionEditor.this.addDefinitionAction.getResultDefinition();
                if (resultDefinition != null) {
                    CatalogDefinitionEditor.this.catalogEditorPanel.definitionAdded(resultDefinition);
                }
            }

            public void performEditItem() {
                CatalogDefinitionEditor.this.editDefinitionAction.setCurrentDefinition(CatalogDefinitionEditor.this.catalogEditorPanel.getSelectedDefinition());
                CatalogDefinitionEditor.this.editDefinitionAction.actionPerformed(null);
                CatalogDefsTableItem resultDefinition = CatalogDefinitionEditor.this.editDefinitionAction.getResultDefinition();
                if (resultDefinition != null) {
                    CatalogDefinitionEditor.this.catalogEditorPanel.definitionEdited(resultDefinition);
                }
            }

            public void performDeleteItem() {
                CatalogDefinitionEditor.this.removeDefinitionAction.setCurrentDefinition(CatalogDefinitionEditor.this.catalogEditorPanel.getSelectedDefinition());
                CatalogDefinitionEditor.this.removeDefinitionAction.actionPerformed(null);
                CatalogDefsTableItem resultDefinition = CatalogDefinitionEditor.this.editDefinitionAction.getResultDefinition();
                if (resultDefinition != null) {
                    CatalogDefinitionEditor.this.catalogEditorPanel.definitionRemoved(resultDefinition);
                }
            }

            public boolean canAddItem() {
                return true;
            }

            public boolean canEditItem() {
                CatalogDefsTableItem revision = CatalogDefinitionEditor.this.catalogEditorPanel.getSelectedDefinition();
                return revision != null;
            }

            public boolean canDeleteItem() {
                CatalogDefsTableItem revision = CatalogDefinitionEditor.this.catalogEditorPanel.getSelectedDefinition();
                return revision != null;
            }

            public void setUpdateListener(@Nonnull EditItemActionsUpdateListener updateListener) {
                CatalogDefinitionEditor.this.catalogEditorPanel.addSelectionListener(updateListener);
            }
        });
        this.moveItemActionsHandler = new MoveItemActionsHandler(){

            public void performMoveUp() {
                int selectedDefinitionIndex = CatalogDefinitionEditor.this.catalogEditorPanel.getSelectedDefinitionIndex();
                CatalogDefinitionEditor.this.catalogEditorPanel.definitionMovedUp(selectedDefinitionIndex);
            }

            public void performMoveDown() {
                int selectedDefinitionIndex = CatalogDefinitionEditor.this.catalogEditorPanel.getSelectedDefinitionIndex();
                CatalogDefinitionEditor.this.catalogEditorPanel.definitionMovedDown(selectedDefinitionIndex);
            }

            public void performMoveTop() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void performMoveBottom() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean isSelection() {
                return true;
            }

            public boolean isEditable() {
                return true;
            }

            public void setUpdateListener(MoveItemActionsUpdateListener updateListener) {
            }
        };
        this.popupMenu = new JPopupMenu();
        JMenuItem addDefinitionMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getAddItemAction());
        addDefinitionMenuItem.setText(this.resourceBundle.getString("addDefinitionMenuItem.text") + "...");
        this.popupMenu.add(addDefinitionMenuItem);
        JMenuItem editDefinitionMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getEditItemAction());
        editDefinitionMenuItem.setText(this.resourceBundle.getString("editDefinitionMenuItem.text") + "...");
        this.popupMenu.add(editDefinitionMenuItem);
        this.catalogEditorPanel.setPanelPopup(this.popupMenu);
        this.catalogEditorPanel.addToolbarActions((ActionsProvider)this.editActions);
        this.addDefinitionAction.setParentComponent(this.catalogEditorPanel);
        this.editDefinitionAction.setParentComponent(this.catalogEditorPanel);
        this.removeDefinitionAction.setParentComponent(this.catalogEditorPanel);
    }

    public void setCatalogItem(XBCItem item) {
        this.catalogEditorPanel.setCatalogItem(item);
    }

    public void setDefsModel(CatalogDefsTableModel defsTableModel) {
        this.catalogEditorPanel.setDefsModel(defsTableModel);
    }

    @Nonnull
    public CatalogItemEditDefinitionPanel getCatalogEditorPanel() {
        return this.catalogEditorPanel;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.catalogEditorPanel.setApplication(application);
        this.addDefinitionAction.setup(application);
        this.editDefinitionAction.setup(application);
        this.removeDefinitionAction.setup(application);
        ComponentModuleApi componentModule = (ComponentModuleApi)application.getModuleRepository().getModuleByInterface(ComponentModuleApi.class);
        MoveItemActions moveItemActions = componentModule.createMoveItemActions(this.moveItemActionsHandler);
        this.catalogEditorPanel.addToolbarActions(sideToolBar -> sideToolBar.addSeparator());
        this.catalogEditorPanel.addToolbarActions((ActionsProvider)moveItemActions);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.catalogEditorPanel.setCatalog(catalog);
        this.addDefinitionAction.setCatalog(catalog);
        this.editDefinitionAction.setCatalog(catalog);
        this.removeDefinitionAction.setCatalog(catalog);
    }

    public void persist() {
        this.catalogEditorPanel.persist();
    }
}

