/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.revision.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.data.model.CatalogDefsTableModel;
import org.exbin.framework.data.model.CatalogRevsTableItem;
import org.exbin.framework.data.model.CatalogRevsTableModel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.catalog.entity.XBERev;
import org.exbin.xbup.catalog.entity.service.XBEXDescService;
import org.exbin.xbup.catalog.entity.service.XBEXNameService;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;

@ParametersAreNonnullByDefault
public class CatalogItemEditRevsPanel
extends JPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private XBCItem catalogItem;
    private XBCRevService revService;
    private final CatalogRevsTableModel revsModel;
    private CatalogDefsTableModel defsModel;
    private List<CatalogRevsTableItem> removeList;
    private List<CatalogRevsTableItem> updateList;
    private final ToolBarSidePanel toolBarPanel = new ToolBarSidePanel();
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogItemEditRevsPanel.class);
    private JScrollPane itemRevisionsScrollPane;
    private JTable itemRevisionsTable;

    public CatalogItemEditRevsPanel() {
        this.revsModel = new CatalogRevsTableModel();
        this.initComponents();
        this.toolBarPanel.setToolBarPosition(ToolBarSidePanel.ToolBarPosition.RIGHT);
        this.toolBarPanel.add((Component)this.itemRevisionsScrollPane, (Object)"Center");
        this.add((Component)this.toolBarPanel, "Center");
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Nullable
    public CatalogRevsTableItem getSelectedRevision() {
        int selectedRow = this.itemRevisionsTable.getSelectedRow();
        if (selectedRow >= 0) {
            return this.revsModel.getRowItem(selectedRow);
        }
        return null;
    }

    public void addFileActions(ActionsProvider actionsProvider) {
        this.toolBarPanel.addActions(actionsProvider);
    }

    private void initComponents() {
        this.itemRevisionsScrollPane = new JScrollPane();
        this.itemRevisionsTable = new JTable();
        this.itemRevisionsTable.setModel((TableModel)this.revsModel);
        this.itemRevisionsTable.setSelectionMode(0);
        this.itemRevisionsScrollPane.setViewportView(this.itemRevisionsTable);
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogItemEditRevsPanel());
    }

    public void persist() {
        this.updateList.forEach(revItem -> {
            XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
            XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
            XBERev rev = (XBERev)revItem.getRev();
            if (rev == null) {
                rev = (XBERev)this.revService.createRev((XBCSpec)this.catalogItem);
                rev.setXBIndex(revItem.getXbIndex().longValue());
            }
            rev.setXBLimit(revItem.getLimit().longValue());
            this.revService.persistItem((XBCBase)rev);
            ((XBEXNameService)nameService).setDefaultText((XBCItem)rev, revItem.getName());
            ((XBEXDescService)descService).setDefaultText((XBCItem)rev, revItem.getDescription());
        });
        this.removeList.stream().filter(revItem -> revItem.getRev() != null).forEachOrdered(revItem -> this.revService.removeItemDepth(revItem.getRev()));
    }

    public void setCatalogItem(XBCItem catalogItem) {
        this.catalogItem = catalogItem;
        this.revsModel.setSpec((XBCSpec)catalogItem);
        this.updateList = new ArrayList<CatalogRevsTableItem>();
        this.removeList = new ArrayList<CatalogRevsTableItem>();
    }

    public XBCItem getCatalogItem() {
        return this.catalogItem;
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.revService = (XBCRevService)catalog.getCatalogService(XBCRevService.class);
        this.revsModel.setCatalog((XBCatalog)catalog);
    }

    public void setDefsModel(CatalogDefsTableModel defsModel) {
        this.defsModel = defsModel;
        defsModel.setRevsModel(this.revsModel);
    }

    public void revisionAdded(CatalogRevsTableItem resultRevision) {
        CatalogRevsTableItem rewItem;
        long maxXbIndex = 0L;
        if (this.revsModel.getRowCount() > 0 && (rewItem = this.revsModel.getRowItem(this.revsModel.getRowCount() - 1)).getXbIndex() >= maxXbIndex) {
            maxXbIndex = rewItem.getXbIndex() + 1L;
        }
        resultRevision.setXbIndex(Long.valueOf(maxXbIndex));
        if (!this.updateList.contains(resultRevision)) {
            this.updateList.add(resultRevision);
        }
        this.revsModel.getRevs().add(resultRevision);
        this.revsModel.fireTableDataChanged();
        this.defsModel.updateDefRevisions();
    }

    public void revisionEdited(CatalogRevsTableItem resultRevision) {
        if (!this.updateList.contains(resultRevision)) {
            this.updateList.add(resultRevision);
        }
        this.defsModel.updateDefRevisions();
    }

    public void revisionRemoved(CatalogRevsTableItem resultRevision) {
        if (this.updateList.contains(resultRevision)) {
            this.updateList.remove(resultRevision);
        }
        this.removeList.add(resultRevision);
        this.revsModel.getRevs().remove(resultRevision);
        this.revsModel.fireTableDataChanged();
        this.defsModel.updateDefRevisions();
    }

    public void setPanelPopup(JPopupMenu popupMenu) {
        this.itemRevisionsScrollPane.setComponentPopupMenu(popupMenu);
    }

    public void addSelectionListener(EditItemActionsUpdateListener updateListener) {
        this.itemRevisionsTable.getSelectionModel().addListSelectionListener(e -> updateListener.stateChanged());
    }
}

