/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.revision;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.action.DefaultEditItemActions;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsHandler;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.data.model.CatalogDefsTableModel;
import org.exbin.framework.data.model.CatalogRevsTableItem;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.xbup.catalog.item.revision.action.AddItemRevisionAction;
import org.exbin.framework.xbup.catalog.item.revision.action.EditItemRevisionAction;
import org.exbin.framework.xbup.catalog.item.revision.action.RemoveItemRevisionAction;
import org.exbin.framework.xbup.catalog.item.revision.gui.CatalogItemEditRevsPanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;

@ParametersAreNonnullByDefault
public class CatalogRevisionsEditor {
    private final CatalogItemEditRevsPanel catalogEditorPanel;
    private final DefaultEditItemActions editActions;
    private XBApplication application;
    private XBACatalog catalog;
    private JPopupMenu popupMenu;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogRevisionsEditor.class);
    private AddItemRevisionAction addRevisionAction = new AddItemRevisionAction();
    private EditItemRevisionAction editRevisionAction = new EditItemRevisionAction();
    private RemoveItemRevisionAction removeRevisionAction = new RemoveItemRevisionAction();

    public CatalogRevisionsEditor() {
        this.catalogEditorPanel = new CatalogItemEditRevsPanel();
        this.editActions = new DefaultEditItemActions(DefaultEditItemActions.Mode.DIALOG);
        this.editActions.setEditItemActionsHandler(new EditItemActionsHandler(){

            public void performAddItem() {
                CatalogRevisionsEditor.this.addRevisionAction.actionPerformed(null);
                CatalogRevsTableItem resultRevision = CatalogRevisionsEditor.this.addRevisionAction.getResultRevision();
                if (resultRevision != null) {
                    CatalogRevisionsEditor.this.catalogEditorPanel.revisionAdded(resultRevision);
                }
            }

            public void performEditItem() {
                CatalogRevisionsEditor.this.editRevisionAction.setCurrentRevision(CatalogRevisionsEditor.this.catalogEditorPanel.getSelectedRevision());
                CatalogRevisionsEditor.this.editRevisionAction.actionPerformed(null);
                CatalogRevsTableItem resultRevision = CatalogRevisionsEditor.this.editRevisionAction.getResultRevision();
                if (resultRevision != null) {
                    CatalogRevisionsEditor.this.catalogEditorPanel.revisionEdited(resultRevision);
                }
            }

            public void performDeleteItem() {
                CatalogRevisionsEditor.this.removeRevisionAction.setCurrentRevision(CatalogRevisionsEditor.this.catalogEditorPanel.getSelectedRevision());
                CatalogRevisionsEditor.this.removeRevisionAction.actionPerformed(null);
                CatalogRevsTableItem resultRevision = CatalogRevisionsEditor.this.editRevisionAction.getResultRevision();
                if (resultRevision != null) {
                    CatalogRevisionsEditor.this.catalogEditorPanel.revisionRemoved(resultRevision);
                }
            }

            public boolean canAddItem() {
                return true;
            }

            public boolean canEditItem() {
                CatalogRevsTableItem revision = CatalogRevisionsEditor.this.catalogEditorPanel.getSelectedRevision();
                return revision != null;
            }

            public boolean canDeleteItem() {
                CatalogRevsTableItem revision = CatalogRevisionsEditor.this.catalogEditorPanel.getSelectedRevision();
                return revision != null;
            }

            public void setUpdateListener(@Nonnull EditItemActionsUpdateListener updateListener) {
                CatalogRevisionsEditor.this.catalogEditorPanel.addSelectionListener(updateListener);
            }
        });
        this.popupMenu = new JPopupMenu();
        JMenuItem addRevisionMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getAddItemAction());
        addRevisionMenuItem.setText(this.resourceBundle.getString("addRevisionMenuItem.text") + "...");
        this.popupMenu.add(addRevisionMenuItem);
        JMenuItem editRevisionMenuItem = ActionUtils.actionToMenuItem((Action)this.editActions.getEditItemAction());
        editRevisionMenuItem.setText(this.resourceBundle.getString("editRevisionMenuItem.text") + "...");
        this.popupMenu.add(editRevisionMenuItem);
        this.catalogEditorPanel.setPanelPopup(this.popupMenu);
        this.catalogEditorPanel.addFileActions((ActionsProvider)this.editActions);
        this.addRevisionAction.setParentComponent(this.catalogEditorPanel);
        this.editRevisionAction.setParentComponent(this.catalogEditorPanel);
        this.removeRevisionAction.setParentComponent(this.catalogEditorPanel);
    }

    public void setCatalogItem(XBCItem item) {
        this.catalogEditorPanel.setCatalogItem(item);
    }

    public void setDefsModel(CatalogDefsTableModel defsTableModel) {
        this.catalogEditorPanel.setDefsModel(defsTableModel);
    }

    @Nonnull
    public CatalogItemEditRevsPanel getCatalogEditorPanel() {
        return this.catalogEditorPanel;
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.catalogEditorPanel.setApplication(application);
        this.addRevisionAction.setup(application);
        this.editRevisionAction.setup(application);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.catalogEditorPanel.setCatalog(catalog);
        this.addRevisionAction.setCatalog(catalog);
        this.editRevisionAction.setCatalog(catalog);
    }

    public void persist() {
        this.catalogEditorPanel.persist();
    }
}

