/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.property.gui;

import java.awt.Component;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.xbup.catalog.item.plugin.gui.CatalogSelectRowEditorPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogPropertyTableCellPanel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEBlockRev;
import org.exbin.xbup.catalog.entity.XBEXBlockUi;
import org.exbin.xbup.catalog.entity.XBEXPlugUi;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBPlugUiType;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXBlockUi;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCXUiService;

public class CatalogREditorPropertyTableCellPanel
extends CatalogPropertyTableCellPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private long lineId;
    private XBCBlockRev blockRev;
    private XBCXPlugUi plugUi;

    public CatalogREditorPropertyTableCellPanel(XBACatalog catalog) {
        this.catalog = catalog;
        this.init();
    }

    private void init() {
        this.setEditorAction(e -> this.performEditorAction());
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void performEditorAction() {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogSelectRowEditorPanel uiSelectPanel = new CatalogSelectRowEditorPanel();
        uiSelectPanel.setApplication(this.application);
        uiSelectPanel.setCatalog(this.catalog);
        uiSelectPanel.setPlugUi(this.plugUi);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)uiSelectPanel, (JPanel)controlPanel);
        controlPanel.setHandler(actionType -> {
            switch (actionType) {
                case OK: {
                    this.plugUi = uiSelectPanel.getPlugUi();
                    XBEXBlockUi blockUi = new XBEXBlockUi();
                    blockUi.setBlockRev((XBCBlockRev)((XBEBlockRev)this.blockRev));
                    blockUi.setUi((XBCXPlugUi)((XBEXPlugUi)this.plugUi));
                    blockUi.setPriority(0L);
                    EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
                    EntityTransaction transaction = em.getTransaction();
                    transaction.begin();
                    em.persist((Object)blockUi);
                    em.flush();
                    transaction.commit();
                    this.lineId = blockUi.getId();
                    this.setPropertyLabel();
                    break;
                }
            }
            dialog.close();
        });
        dialog.showCentered((Component)((Object)this));
        dialog.dispose();
    }

    public void setCatalogItem(XBCItem catalogItem) {
        XBCXUiService uiService = (XBCXUiService)this.catalog.getCatalogService(XBCXUiService.class);
        XBCRevService revService = (XBCRevService)this.catalog.getCatalogService(XBCRevService.class);
        long maxRev = revService.findMaxRevXB((XBCSpec)((XBCBlockSpec)catalogItem));
        this.blockRev = (XBCBlockRev)revService.findRevByXB((XBCSpec)((XBCBlockSpec)catalogItem), maxRev);
        XBCXBlockUi blockUi = uiService.findUiByPR(this.blockRev, XBPlugUiType.ROW_EDITOR, 0L);
        this.plugUi = blockUi == null ? null : blockUi.getUi();
        this.lineId = blockUi == null ? 0L : blockUi.getId();
        this.setPropertyLabel();
    }

    private void setPropertyLabel() {
        this.setPropertyText(this.lineId > 0L ? String.valueOf(this.lineId) : "");
    }

    public long getLineId() {
        return this.lineId;
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }
}

