/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.property.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.EventObject;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogBIconPropertyTableCellPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogDocPropertyTableCellPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogPEditorPropertyTableCellPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogPViewerPropertyTableCellPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogParentPropertyTableCellPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogREditorPropertyTableCellPanel;
import org.exbin.framework.xbup.catalog.item.property.gui.CatalogSIconPropertyTableCellPanel;
import org.exbin.xbup.catalog.entity.XBEItem;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.XBEXFile;
import org.exbin.xbup.catalog.entity.XBEXHDoc;
import org.exbin.xbup.catalog.entity.XBEXIcon;
import org.exbin.xbup.catalog.entity.XBEXIconMode;
import org.exbin.xbup.catalog.entity.XBEXLanguage;
import org.exbin.xbup.catalog.entity.service.XBEXDescService;
import org.exbin.xbup.catalog.entity.service.XBEXFileService;
import org.exbin.xbup.catalog.entity.service.XBEXHDocService;
import org.exbin.xbup.catalog.entity.service.XBEXIconService;
import org.exbin.xbup.catalog.entity.service.XBEXNameService;
import org.exbin.xbup.catalog.entity.service.XBEXStriService;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXHDoc;
import org.exbin.xbup.core.catalog.base.XBCXIcon;
import org.exbin.xbup.core.catalog.base.XBCXIconMode;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.service.XBCItemService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;
import org.exbin.xbup.core.catalog.base.service.XBCXIconService;
import org.exbin.xbup.core.catalog.base.service.XBCXLangService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;
import sun.swing.DefaultLookup;

@ParametersAreNonnullByDefault
public class CatalogItemEditPropertiesPanel
extends JPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private XBCItem catalogItem;
    private CatalogDocPropertyTableCellPanel docCellPanel = null;
    private CatalogParentPropertyTableCellPanel parentCellPanel = null;
    private CatalogBIconPropertyTableCellPanel bIconCellPanel = null;
    private CatalogSIconPropertyTableCellPanel sIconCellPanel = null;
    private CatalogREditorPropertyTableCellPanel rEditorCellPanel = null;
    private CatalogPViewerPropertyTableCellPanel pViewerCellPanel = null;
    private CatalogPEditorPropertyTableCellPanel pEditorCellPanel = null;
    private JTable propertiesTable;
    private JScrollPane scrollPane;

    public CatalogItemEditPropertiesPanel() {
        this.initComponents();
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.propertiesTable = new JTable(null){

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                boolean result = super.editCellAt(row, column, e);
                final Component editor = this.getEditorComponent();
                if (editor == null || !(editor instanceof JTextComponent)) {
                    return result;
                }
                if (e instanceof MouseEvent) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JTextComponent)editor).selectAll();
                        }
                    });
                } else {
                    ((JTextComponent)editor).selectAll();
                }
                return result;
            }
        };
        this.setLayout(new BorderLayout());
        this.scrollPane.setName("scrollPane");
        this.propertiesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Property", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.propertiesTable.setName("propertiesTable");
        this.scrollPane.setViewportView(this.propertiesTable);
        this.add((Component)this.scrollPane, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogItemEditPropertiesPanel());
    }

    public void setCatalogItem(XBCItem catalogItem) {
        this.catalogItem = catalogItem;
        DefaultTableModel tableModel = (DefaultTableModel)this.propertiesTable.getModel();
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
        for (int i = tableModel.getRowCount() - 1; i > 0; --i) {
            tableModel.removeRow(i);
        }
        String parentId = "";
        if (catalogItem.getParentItem().isPresent()) {
            parentId = String.valueOf(((XBCItem)catalogItem.getParentItem().get()).getId());
        }
        tableModel.addRow(new String[]{"Name", nameService.getDefaultText(catalogItem)});
        tableModel.addRow(new String[]{"Description", descService.getDefaultText(catalogItem)});
        tableModel.addRow(new String[]{"Parent Node", parentId});
        long xbIndex = catalogItem.getXBIndex();
        tableModel.addRow(new String[]{"XBIndex", String.valueOf(xbIndex)});
        String pathName = null;
        XBCXStri stringId = striService.getItemStringId(catalogItem);
        if (stringId != null) {
            pathName = stringId.getText();
        }
        tableModel.addRow(new String[]{"StringId", pathName});
        tableModel.addRow(new String[]{"HDoc", ""});
        tableModel.addRow(new String[]{"Big Icon (32x32)", ""});
        tableModel.addRow(new String[]{"Small Icon (16x16)", ""});
        if (catalogItem instanceof XBCBlockSpec) {
            tableModel.addRow(new String[]{"Row editor", ""});
            tableModel.addRow(new String[]{"Panel Viewer", ""});
            tableModel.addRow(new String[]{"Panel editor", ""});
        }
        TableColumnModel columns = this.propertiesTable.getColumnModel();
        this.docCellPanel = new CatalogDocPropertyTableCellPanel(this.catalog);
        this.docCellPanel.setApplication(this.application);
        this.docCellPanel.setCatalogItem(catalogItem);
        this.parentCellPanel = new CatalogParentPropertyTableCellPanel(this.catalog);
        this.parentCellPanel.setApplication(this.application);
        this.parentCellPanel.setCatalogItem(catalogItem);
        this.bIconCellPanel = new CatalogBIconPropertyTableCellPanel(this.catalog);
        this.bIconCellPanel.setApplication(this.application);
        this.bIconCellPanel.setCatalogItem(catalogItem);
        this.sIconCellPanel = new CatalogSIconPropertyTableCellPanel(this.catalog);
        this.sIconCellPanel.setApplication(this.application);
        this.sIconCellPanel.setCatalogItem(catalogItem);
        if (catalogItem instanceof XBCBlockSpec) {
            this.pEditorCellPanel = new CatalogPEditorPropertyTableCellPanel(this.catalog);
            this.pEditorCellPanel.setApplication(this.application);
            this.pEditorCellPanel.setCatalogItem(catalogItem);
            this.pViewerCellPanel = new CatalogPViewerPropertyTableCellPanel(this.catalog);
            this.pViewerCellPanel.setApplication(this.application);
            this.pViewerCellPanel.setCatalogItem(catalogItem);
            this.rEditorCellPanel = new CatalogREditorPropertyTableCellPanel(this.catalog);
            this.rEditorCellPanel.setApplication(this.application);
            this.rEditorCellPanel.setCatalogItem(catalogItem);
        }
        columns.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                switch (row) {
                    case 2: {
                        CatalogItemEditPropertiesPanel.this.parentCellPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        CatalogItemEditPropertiesPanel.this.parentCellPanel.getCellComponent().setBorder(null);
                        return CatalogItemEditPropertiesPanel.this.parentCellPanel;
                    }
                    case 5: {
                        CatalogItemEditPropertiesPanel.this.docCellPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        CatalogItemEditPropertiesPanel.this.docCellPanel.getCellComponent().setBorder(null);
                        return CatalogItemEditPropertiesPanel.this.docCellPanel;
                    }
                    case 6: {
                        CatalogItemEditPropertiesPanel.this.bIconCellPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        CatalogItemEditPropertiesPanel.this.bIconCellPanel.getCellComponent().setBorder(null);
                        return CatalogItemEditPropertiesPanel.this.bIconCellPanel;
                    }
                    case 7: {
                        CatalogItemEditPropertiesPanel.this.sIconCellPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        CatalogItemEditPropertiesPanel.this.sIconCellPanel.getCellComponent().setBorder(null);
                        return CatalogItemEditPropertiesPanel.this.sIconCellPanel;
                    }
                    case 8: {
                        CatalogItemEditPropertiesPanel.this.rEditorCellPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        CatalogItemEditPropertiesPanel.this.rEditorCellPanel.getCellComponent().setBorder(null);
                        return CatalogItemEditPropertiesPanel.this.rEditorCellPanel;
                    }
                    case 9: {
                        CatalogItemEditPropertiesPanel.this.pViewerCellPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        CatalogItemEditPropertiesPanel.this.pViewerCellPanel.getCellComponent().setBorder(null);
                        return CatalogItemEditPropertiesPanel.this.pViewerCellPanel;
                    }
                    case 10: {
                        CatalogItemEditPropertiesPanel.this.pEditorCellPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        CatalogItemEditPropertiesPanel.this.pEditorCellPanel.getCellComponent().setBorder(null);
                        return CatalogItemEditPropertiesPanel.this.pEditorCellPanel;
                    }
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField()){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                switch (row) {
                    case 2: {
                        CatalogItemEditPropertiesPanel.this.parentCellPanel.setBackground(table.getSelectionBackground());
                        CatalogItemEditPropertiesPanel.this.parentCellPanel.getCellComponent().setBorder(DefaultLookup.getBorder(CatalogItemEditPropertiesPanel.this.parentCellPanel.getCellComponent(), CatalogItemEditPropertiesPanel.this.ui, "Table.focusCellHighlightBorder"));
                        return CatalogItemEditPropertiesPanel.this.parentCellPanel;
                    }
                    case 5: {
                        CatalogItemEditPropertiesPanel.this.docCellPanel.setBackground(table.getSelectionBackground());
                        CatalogItemEditPropertiesPanel.this.docCellPanel.getCellComponent().setBorder(DefaultLookup.getBorder(CatalogItemEditPropertiesPanel.this.docCellPanel.getCellComponent(), CatalogItemEditPropertiesPanel.this.ui, "Table.focusCellHighlightBorder"));
                        return CatalogItemEditPropertiesPanel.this.docCellPanel;
                    }
                    case 6: {
                        CatalogItemEditPropertiesPanel.this.bIconCellPanel.setBackground(table.getSelectionBackground());
                        CatalogItemEditPropertiesPanel.this.bIconCellPanel.getCellComponent().setBorder(DefaultLookup.getBorder(CatalogItemEditPropertiesPanel.this.bIconCellPanel.getCellComponent(), CatalogItemEditPropertiesPanel.this.ui, "Table.focusCellHighlightBorder"));
                        return CatalogItemEditPropertiesPanel.this.bIconCellPanel;
                    }
                    case 7: {
                        CatalogItemEditPropertiesPanel.this.sIconCellPanel.setBackground(table.getSelectionBackground());
                        CatalogItemEditPropertiesPanel.this.sIconCellPanel.getCellComponent().setBorder(DefaultLookup.getBorder(CatalogItemEditPropertiesPanel.this.sIconCellPanel.getCellComponent(), CatalogItemEditPropertiesPanel.this.ui, "Table.focusCellHighlightBorder"));
                        return CatalogItemEditPropertiesPanel.this.sIconCellPanel;
                    }
                    case 8: {
                        CatalogItemEditPropertiesPanel.this.rEditorCellPanel.setBackground(table.getSelectionBackground());
                        CatalogItemEditPropertiesPanel.this.rEditorCellPanel.getCellComponent().setBorder(DefaultLookup.getBorder(CatalogItemEditPropertiesPanel.this.rEditorCellPanel.getCellComponent(), CatalogItemEditPropertiesPanel.this.ui, "Table.focusCellHighlightBorder"));
                        return CatalogItemEditPropertiesPanel.this.rEditorCellPanel;
                    }
                    case 9: {
                        CatalogItemEditPropertiesPanel.this.pViewerCellPanel.setBackground(table.getSelectionBackground());
                        CatalogItemEditPropertiesPanel.this.pViewerCellPanel.getCellComponent().setBorder(DefaultLookup.getBorder(CatalogItemEditPropertiesPanel.this.rEditorCellPanel.getCellComponent(), CatalogItemEditPropertiesPanel.this.ui, "Table.focusCellHighlightBorder"));
                        return CatalogItemEditPropertiesPanel.this.pViewerCellPanel;
                    }
                    case 10: {
                        CatalogItemEditPropertiesPanel.this.pEditorCellPanel.setBackground(table.getSelectionBackground());
                        CatalogItemEditPropertiesPanel.this.pEditorCellPanel.getCellComponent().setBorder(DefaultLookup.getBorder(CatalogItemEditPropertiesPanel.this.pEditorCellPanel.getCellComponent(), CatalogItemEditPropertiesPanel.this.ui, "Table.focusCellHighlightBorder"));
                        return CatalogItemEditPropertiesPanel.this.pEditorCellPanel;
                    }
                }
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
        };
        defaultCellEditor.setClickCountToStart(0);
        columns.getColumn(1).setCellEditor(defaultCellEditor);
        this.propertiesTable.repaint();
    }

    public XBCItem getCatalogItem() {
        return this.catalogItem;
    }

    public void persist() {
        byte[] smallIcon;
        byte[] bigIcon;
        if (this.propertiesTable.getCellEditor() != null) {
            this.propertiesTable.getCellEditor().stopCellEditing();
        }
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        XBCItemService itemService = (XBCItemService)this.catalog.getCatalogService(XBCItemService.class);
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
        DefaultTableModel tableModel = (DefaultTableModel)this.propertiesTable.getModel();
        ((XBEXNameService)nameService).setDefaultText(this.catalogItem, (String)tableModel.getValueAt(0, 1));
        ((XBEXDescService)descService).setDefaultText(this.catalogItem, (String)tableModel.getValueAt(1, 1));
        if (this.catalogItem instanceof XBEItem) {
            String xbIndex = (String)tableModel.getValueAt(3, 1);
            if (xbIndex == null) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            ((XBEItem)this.catalogItem).setXBIndex(Long.parseLong(xbIndex));
            Optional<XBCNode> parentNode = this.parentCellPanel.getParentNode();
            if (parentNode.isPresent() && parentNode.get().equals(((XBEItem)this.catalogItem).getParentItem().orElse(null))) {
                ((XBEItem)this.catalogItem).setParentItem((XBCItem)((XBENode)parentNode.get()));
            }
            itemService.persistItem((XBCBase)this.catalogItem);
        }
        ((XBEXStriService)striService).setItemStringIdText(this.catalogItem, (String)tableModel.getValueAt(4, 1));
        String document = this.docCellPanel.getDocument();
        if (document != null) {
            XBCXFileService fileService = (XBCXFileService)this.catalog.getCatalogService(XBCXFileService.class);
            XBCXHDocService hdocService = (XBCXHDocService)this.catalog.getCatalogService(XBCXHDocService.class);
            XBCXHDoc itemHDoc = hdocService.getDocumentation(this.catalogItem);
            if (document.isEmpty()) {
                if (itemHDoc != null) {
                    fileService.removeItem((XBCBase)itemHDoc.getDocFile());
                    ((XBEXHDoc)itemHDoc).setDocFile(null);
                    hdocService.removeItem((XBCBase)itemHDoc);
                }
            } else {
                XBCXFile itemHDocFile;
                if (itemHDoc == null) {
                    XBCXLangService langService = (XBCXLangService)this.catalog.getCatalogService(XBCXLangService.class);
                    XBCXLanguage defaultLanguage = langService.getDefaultLang();
                    itemHDoc = new XBEXHDoc();
                    ((XBEXHDoc)itemHDoc).setLang((XBCXLanguage)((XBEXLanguage)defaultLanguage));
                    ((XBEXHDoc)itemHDoc).setItem((XBCItem)((XBEItem)this.catalogItem));
                }
                if ((itemHDocFile = itemHDoc.getDocFile()) == null) {
                    XBCXStri stringId = striService.getItemStringId(this.catalogItem);
                    String itemPath = stringId == null ? "" : stringId.getText();
                    itemHDocFile = (XBCXFile)fileService.createItem();
                    ((XBEXFile)itemHDocFile).setFilename("hdoc-" + itemPath);
                    ((XBEXFile)itemHDocFile).setNode((XBCNode)((XBENode)this.catalogItem.getParentItem().get()));
                    ((XBEXHDoc)itemHDoc).setDocFile((XBCXFile)((XBEXFile)itemHDocFile));
                }
                OutputStream fileOutputStream = ((XBEXFileService)fileService).setFile(itemHDocFile);
                OutputStreamWriter writer = new OutputStreamWriter(fileOutputStream);
                try {
                    writer.write(document);
                    writer.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(CatalogItemEditPropertiesPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                ((XBEXFileService)fileService).persistItem((XBCBase)((XBEXFile)itemHDocFile));
                ((XBEXHDocService)hdocService).persistItem((XBCBase)((XBEXHDoc)itemHDoc));
            }
        }
        if ((bigIcon = this.bIconCellPanel.getIcon()) != null) {
            XBCXFileService fileService = (XBCXFileService)this.catalog.getCatalogService(XBCXFileService.class);
            XBCXIconService iconService = (XBCXIconService)this.catalog.getCatalogService(XBCXIconService.class);
            XBCXIcon itemIcon = iconService.getDefaultBigIcon(this.catalogItem);
            if (bigIcon.length == 0) {
                if (itemIcon != null) {
                    fileService.removeItem((XBCBase)itemIcon.getIconFile());
                    ((XBEXIcon)itemIcon).setIconFile(null);
                    iconService.removeItem((XBCBase)itemIcon);
                }
            } else {
                XBCXFile itemIconFile;
                if (itemIcon == null) {
                    itemIcon = new XBEXIcon();
                    ((XBEXIcon)itemIcon).setParent((XBCItem)((XBEItem)this.catalogItem));
                    ((XBEXIcon)itemIcon).setMode((XBCXIconMode)((XBEXIconMode)iconService.getIconMode(Long.valueOf(2L))));
                }
                if ((itemIconFile = itemIcon.getIconFile()) == null) {
                    XBCXStri stringId = striService.getItemStringId(this.catalogItem);
                    String itemPath = stringId == null ? "" : stringId.getText();
                    itemIconFile = (XBCXFile)fileService.createItem();
                    ((XBEXFile)itemIconFile).setFilename("bicon-" + itemPath);
                    ((XBEXFile)itemIconFile).setNode((XBCNode)((XBENode)this.catalogItem.getParentItem().get()));
                    ((XBEXIcon)itemIcon).setIconFile((XBCXFile)((XBEXFile)itemIconFile));
                }
                ((XBEXFile)itemIconFile).setContent(bigIcon);
                ((XBEXFileService)fileService).persistItem((XBCBase)((XBEXFile)itemIconFile));
                ((XBEXIconService)iconService).persistItem((XBCBase)((XBEXIcon)itemIcon));
            }
        }
        if ((smallIcon = this.sIconCellPanel.getIcon()) != null) {
            XBCXFileService fileService = (XBCXFileService)this.catalog.getCatalogService(XBCXFileService.class);
            XBCXIconService iconService = (XBCXIconService)this.catalog.getCatalogService(XBCXIconService.class);
            XBCXIcon itemIcon = iconService.getDefaultSmallIcon(this.catalogItem);
            if (smallIcon.length == 0) {
                if (itemIcon != null) {
                    fileService.removeItem((XBCBase)itemIcon.getIconFile());
                    ((XBEXIcon)itemIcon).setIconFile(null);
                    iconService.removeItem((XBCBase)itemIcon);
                }
            } else {
                XBCXFile itemIconFile;
                if (itemIcon == null) {
                    itemIcon = new XBEXIcon();
                    ((XBEXIcon)itemIcon).setParent((XBCItem)((XBEItem)this.catalogItem));
                    ((XBEXIcon)itemIcon).setMode((XBCXIconMode)((XBEXIconMode)iconService.getIconMode(Long.valueOf(1L))));
                }
                if ((itemIconFile = itemIcon.getIconFile()) == null) {
                    XBCXStri stringId = striService.getItemStringId(this.catalogItem);
                    String itemPath = stringId == null ? "" : stringId.getText();
                    itemIconFile = (XBCXFile)fileService.createItem();
                    ((XBEXFile)itemIconFile).setFilename("sicon-" + itemPath);
                    ((XBEXFile)itemIconFile).setNode((XBCNode)((XBENode)this.catalogItem.getParentItem().get()));
                    ((XBEXIcon)itemIcon).setIconFile((XBCXFile)((XBEXFile)itemIconFile));
                }
                ((XBEXFile)itemIconFile).setContent(smallIcon);
                ((XBEXFileService)fileService).persistItem((XBCBase)((XBEXFile)itemIconFile));
                ((XBEXIconService)iconService).persistItem((XBCBase)((XBEXIcon)itemIcon));
            }
        }
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }
}

