/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.plugin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.plugin.gui.CatalogPluginsTableModel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;

@ParametersAreNonnullByDefault
public class CatalogItemEditPluginsPanel
extends JPanel {
    private final CatalogPluginsTableModel pluginsModel;
    private XBApplication application;
    private XBCNode node;
    private XBACatalog catalog;
    private final ToolBarSidePanel toolBarPanel = new ToolBarSidePanel();
    private JScrollPane scrollPane;
    private JTable table;

    public CatalogItemEditPluginsPanel() {
        this.pluginsModel = new CatalogPluginsTableModel();
        this.initComponents();
        this.toolBarPanel.setToolBarPosition(ToolBarSidePanel.ToolBarPosition.RIGHT);
        this.toolBarPanel.add((Component)this.scrollPane, (Object)"Center");
        this.add((Component)this.toolBarPanel, "Center");
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.pluginsModel.setCatalog((XBCatalog)catalog);
    }

    public void setNode(XBCNode node) {
        this.node = node;
        this.pluginsModel.setNode(node);
    }

    public void addFileActions(ActionsProvider actionsProvider) {
        this.toolBarPanel.addActions(actionsProvider);
    }

    @Nullable
    public XBCXPlugin getSelectedPlugin() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            return this.pluginsModel.getItem(selectedRow);
        }
        return null;
    }

    @Nonnull
    public CatalogPluginsTableModel getPluginsModel() {
        return this.pluginsModel;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.table.setModel(this.pluginsModel);
        this.table.setSelectionMode(0);
        this.scrollPane.setViewportView(this.table);
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogItemEditPluginsPanel());
    }

    public void setPanelPopup(JPopupMenu popupMenu) {
        this.table.setComponentPopupMenu(popupMenu);
    }

    public void addSelectionListener(EditItemActionsUpdateListener updateListener) {
        this.table.getSelectionModel().addListSelectionListener(e -> updateListener.stateChanged());
    }
}

