/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.plugin.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.item.file.gui.CatalogSelectFilePanel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;

@ParametersAreNonnullByDefault
public class CatalogEditNodePluginPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogEditNodePluginPanel.class);
    private XBApplication application;
    private XBACatalog catalog;
    private XBCXFile file;
    private XBCNode node;
    private XBCXPlugin plugin;
    private JLabel fileLabel;
    private JButton fileSelectButton;
    private JTextField fileTextField;
    private JLabel panelEditorsCountLabel;
    private JTextField panelEditorsCountTextField;
    private JLabel panelViewersCountLabel;
    private JTextField panelViewersCountTextField;
    private JLabel rowEditorsCountLabel_;
    private JTextField rowEditorsCountTextField;

    public CatalogEditNodePluginPanel() {
        this.initComponents();
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setNode(XBCNode node) {
        this.node = node;
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public XBCXPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(@Nullable XBCXPlugin plugin) {
        this.plugin = plugin;
        this.file = plugin == null ? null : plugin.getPluginFile();
        this.node = this.file.getNode();
        this.fileTextField.setText(this.file == null ? "" : this.file.getFilename());
    }

    public XBCXFile getFile() {
        return this.file;
    }

    public void setFile(@Nullable XBCXFile file) {
        this.file = file;
        this.fileTextField.setText(file == null ? "" : file.getFilename());
    }

    public long getRowEditorsCount() {
        String text = this.rowEditorsCountTextField.getText();
        return text.isEmpty() ? 0L : Long.valueOf(text);
    }

    public void setRowEditorsCount(long rowEditorsCount) {
        this.rowEditorsCountTextField.setText(String.valueOf(rowEditorsCount));
    }

    public long getPanelViewersCount() {
        String text = this.panelViewersCountTextField.getText();
        return text.isEmpty() ? 0L : Long.valueOf(text);
    }

    public void setPanelViewersCount(long panelViewersCount) {
        this.panelViewersCountTextField.setText(String.valueOf(panelViewersCount));
    }

    public long getPanelEditorsCount() {
        String text = this.panelEditorsCountTextField.getText();
        return text.isEmpty() ? 0L : Long.valueOf(text);
    }

    public void setPanelEditorsCount(long panelEditorsCount) {
        this.panelEditorsCountTextField.setText(String.valueOf(panelEditorsCount));
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.fileSelectButton = new JButton();
        this.rowEditorsCountLabel_ = new JLabel();
        this.rowEditorsCountTextField = new JTextField();
        this.panelViewersCountLabel = new JLabel();
        this.panelViewersCountTextField = new JTextField();
        this.panelEditorsCountLabel = new JLabel();
        this.panelEditorsCountTextField = new JTextField();
        this.fileLabel.setText("File");
        this.fileSelectButton.setText("Select...");
        this.fileSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogEditNodePluginPanel.this.fileSelectButtonActionPerformed(evt);
            }
        });
        this.rowEditorsCountLabel_.setText("Row Editors Count");
        this.panelViewersCountLabel.setText("Panel Viewers Count");
        this.panelEditorsCountLabel.setText("Panel Editors Count");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rowEditorsCountTextField).addGroup(layout.createSequentialGroup().addComponent(this.fileTextField, -1, 390, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileSelectButton)).addComponent(this.panelViewersCountTextField, GroupLayout.Alignment.TRAILING).addComponent(this.panelEditorsCountTextField, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileLabel).addComponent(this.panelViewersCountLabel).addComponent(this.rowEditorsCountLabel_).addComponent(this.panelEditorsCountLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileTextField, -2, -1, -2).addComponent(this.fileSelectButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowEditorsCountLabel_).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowEditorsCountTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelViewersCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelViewersCountTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelEditorsCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelEditorsCountTextField, -2, -1, -2).addContainerGap(137, Short.MAX_VALUE)));
    }

    private void fileSelectButtonActionPerformed(ActionEvent evt) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CatalogSelectFilePanel selectPanel = new CatalogSelectFilePanel();
        selectPanel.setApplication(this.application);
        selectPanel.setCatalog(this.catalog);
        selectPanel.setNode(this.node);
        DefaultControlPanel controlPanel = new DefaultControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)selectPanel, (JPanel)controlPanel);
        controlPanel.setHandler(actionType -> {
            if (actionType == DefaultControlHandler.ControlActionType.OK) {
                this.setFile(selectPanel.getFile().orElse(null));
            }
            dialog.close();
        });
        dialog.showCentered((Component)this);
        dialog.dispose();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogEditNodePluginPanel());
    }
}

