/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.framework.xbup.catalog.item.gui.CatalogSearchTableModel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.service.XBCItemService;
import org.exbin.xbup.core.catalog.base.service.XBItemWithDetail;

public class CatalogItemsTableModel
extends AbstractTableModel {
    private XBCItemService itemService;
    static final String[] columnNames = new String[]{"Name", "StringId", "Type", "Description"};
    static final Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class};
    static final int pageSize = 20;
    private final List<List<XBItemWithDetail>> itemPages = new ArrayList<List<XBItemWithDetail>>();
    private String filterCondition = "";
    private int itemCount = 0;
    private String specType = null;

    @Override
    public int getRowCount() {
        return this.itemCount;
    }

    public XBItemWithDetail getRow(int rowIndex) {
        int pageIndex = rowIndex / 20;
        int rowInPage = rowIndex % 20;
        List page = this.itemPages.get(pageIndex);
        if (page == null) {
            page = this.itemService.findAllPaged(pageIndex * 20, 20, this.filterCondition, null, this.specType);
            this.itemPages.set(pageIndex, page);
        }
        return page.get(rowInPage);
    }

    public void performLoad() {
        this.itemCount = this.itemService.findAllPagedCount(this.filterCondition, this.specType);
        this.itemPages.clear();
        for (int i = 0; i <= this.itemCount / 20; ++i) {
            this.itemPages.add(null);
        }
        this.fireTableDataChanged();
    }

    public void performSearch(CatalogSearchTableModel.CatalogSearchTableItem filter) {
        if (filter != null) {
            StringBuilder builder = new StringBuilder();
            if (filter.getName() != null && !filter.getName().isEmpty()) {
                builder.append("LOWER(name.text) LIKE '%").append(filter.getName().toLowerCase().replace("'", "''")).append("%'");
            }
            if (filter.getDescription() != null && !filter.getDescription().isEmpty()) {
                if (builder.length() > 0) {
                    builder.append(" AND ");
                }
                builder.append("LOWER(desc.text) LIKE '%").append(filter.getDescription().toLowerCase().replace("'", "''")).append("%'");
            }
            if (filter.getStringId() != null && !filter.getStringId().isEmpty()) {
                if (builder.length() > 0) {
                    builder.append(" AND ");
                }
                builder.append("LOWER(stri.text) LIKE '%").append(filter.getStringId().toLowerCase().replace("'", "''")).append("%'");
            }
            if (filter.getType() != null && !filter.getType().isEmpty()) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            this.filterCondition = builder.toString();
        } else {
            this.filterCondition = "";
        }
        this.performLoad();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getRow(rowIndex).getName();
            }
            case 1: {
                return this.getRow(rowIndex).getStringId();
            }
            case 2: {
                return this.getRow(rowIndex).getType();
            }
            case 3: {
                return this.getRow(rowIndex).getDescription();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    public XBCItem getItem(int index) {
        return this.getRow(index).getItem();
    }

    public int getIndexOfItem(XBItemWithDetail item) {
        return this.itemPages.indexOf(item);
    }

    public void setCatalog(XBACatalog catalog) {
        this.itemService = catalog == null ? null : (XBCItemService)catalog.getCatalogService(XBCItemService.class);
    }

    void setSpecType(CatalogItemType catalogSpecType) {
        switch (catalogSpecType) {
            case FORMAT: {
                this.specType = "XBFormatSpec";
                break;
            }
            case GROUP: {
                this.specType = "XBGroupSpec";
                break;
            }
            case BLOCK: {
                this.specType = "XBBlockSpec";
                break;
            }
            case NODE: {
                this.specType = "XBNode";
            }
        }
    }
}

