/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import org.exbin.framework.data.model.CatalogDefsTableItem;
import org.exbin.framework.data.model.CatalogDefsTableModel;
import org.exbin.framework.data.model.CatalogRevsTableModel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.item.file.gui.CatalogFilesTableModel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXHDoc;
import org.exbin.xbup.core.catalog.base.XBCXIcon;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;
import org.exbin.xbup.core.catalog.base.service.XBCXIconService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;

@ParametersAreNonnullByDefault
public class CatalogItemPanel
extends JPanel {
    private XBCItem item;
    private final CatalogDefsTableModel defsModel;
    private final CatalogRevsTableModel revsModel;
    private final CatalogFilesTableModel filesModel;
    private XBCNodeService nodeService;
    private XBCXNameService nameService;
    private XBCXDescService descService;
    private XBCXStriService striService;
    private XBCXHDocService hDocService;
    private XBCXFileService fileService;
    private XBCXIconService iconService;
    private XBCXName itemName;
    private XBCXDesc itemDesc;
    private XBCXHDoc itemHDoc;
    private XBCXIcon itemIcon;
    private JumpActionListener jumpActionListener = null;
    private XBACatalog catalog;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogItemPanel.class);
    private JPanel basicItemDataPanel;
    private JScrollPane basicItemScrollPane;
    private JPanel definitionPanel;
    private JPopupMenu definitionPopupMenu;
    private JPanel documentationPanel;
    private JMenuItem exportFileMenuItem;
    private JPanel filesPanel;
    private JPopupMenu filesPopupMenu;
    private JLabel fullPathLabel;
    private JTextField fullPathTextField;
    private JPanel generalPanel;
    private JPanel iconPanel;
    private JLabel itemCreatedLabel;
    private JTextField itemCreatedTextField;
    private JScrollPane itemDefinitionScrollPane;
    private JTable itemDefinitionTable;
    private JLabel itemDescriptionLabel;
    private JTextField itemDescriptionTextField;
    private JScrollPane itemFilesScrollPane;
    private JTable itemFilesTable;
    private JEditorPane itemHDocEditorPane;
    private JScrollPane itemHDocScrollPane;
    private JLabel itemIconLabel;
    private JLabel itemNameLabel;
    private JTextField itemNameTextField;
    private JLabel itemPathLabel;
    private JTextField itemPathTextField;
    private JScrollPane itemRevisionsScrollPane;
    private JTable itemRevisionsTable;
    private JLabel itemTitleLabel;
    private JLabel itemTypeLabel;
    private JTextField itemTypeTextField;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JMenuItem jumpToMenuItem;
    private JTabbedPane mainTabbedPane;
    private JPanel revisionsPanel;

    public CatalogItemPanel() {
        this.defsModel = new CatalogDefsTableModel();
        this.revsModel = new CatalogRevsTableModel();
        this.filesModel = new CatalogFilesTableModel();
        this.initComponents();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void initComponents() {
        this.definitionPopupMenu = new JPopupMenu();
        this.jumpToMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.filesPopupMenu = new JPopupMenu();
        this.exportFileMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.mainTabbedPane = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.basicItemScrollPane = new JScrollPane();
        this.basicItemDataPanel = new JPanel();
        this.iconPanel = new JPanel();
        this.itemIconLabel = new JLabel();
        this.itemTitleLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.itemNameLabel = new JLabel();
        this.itemNameTextField = new JTextField();
        this.itemPathLabel = new JLabel();
        this.itemPathTextField = new JTextField();
        this.itemTypeLabel = new JLabel();
        this.itemTypeTextField = new JTextField();
        this.itemDescriptionLabel = new JLabel();
        this.itemDescriptionTextField = new JTextField();
        this.fullPathLabel = new JLabel();
        this.fullPathTextField = new JTextField();
        this.itemCreatedLabel = new JLabel();
        this.itemCreatedTextField = new JTextField();
        this.documentationPanel = new JPanel();
        this.itemHDocScrollPane = new JScrollPane();
        this.itemHDocEditorPane = new JEditorPane();
        this.revisionsPanel = new JPanel();
        this.itemRevisionsScrollPane = new JScrollPane();
        this.itemRevisionsTable = new JTable();
        this.definitionPanel = new JPanel();
        this.itemDefinitionScrollPane = new JScrollPane();
        this.itemDefinitionTable = new JTable();
        this.filesPanel = new JPanel();
        this.itemFilesScrollPane = new JScrollPane();
        this.itemFilesTable = new JTable();
        this.definitionPopupMenu.setName("definitionPopupMenu");
        this.jumpToMenuItem.setText("Jump To Type");
        this.jumpToMenuItem.setToolTipText("Navigate to type of selected definition row");
        this.jumpToMenuItem.setEnabled(false);
        this.jumpToMenuItem.setName("jumpToMenuItem");
        this.jumpToMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogItemPanel.this.jumpToMenuItemActionPerformed(evt);
            }
        });
        this.definitionPopupMenu.add(this.jumpToMenuItem);
        this.jSeparator2.setName("jSeparator2");
        this.definitionPopupMenu.add(this.jSeparator2);
        this.filesPopupMenu.setName("filesPopupMenu");
        this.exportFileMenuItem.setText("Export...");
        this.exportFileMenuItem.setToolTipText("Export content of the remote file to local file");
        this.exportFileMenuItem.setEnabled(false);
        this.exportFileMenuItem.setName("exportFileMenuItem");
        this.exportFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogItemPanel.this.exportFileMenuItemActionPerformed(evt);
            }
        });
        this.filesPopupMenu.add(this.exportFileMenuItem);
        this.jSeparator3.setName("jSeparator3");
        this.filesPopupMenu.add(this.jSeparator3);
        this.setLayout(new BorderLayout());
        this.mainTabbedPane.setName("mainTabbedPane");
        this.generalPanel.setName("generalPanel");
        this.generalPanel.setLayout(new BorderLayout());
        this.basicItemScrollPane.setName("basicItemScrollPane");
        this.basicItemDataPanel.setName("basicItemDataPanel");
        this.iconPanel.setBorder(BorderFactory.createEtchedBorder());
        this.iconPanel.setName("iconPanel");
        this.iconPanel.setLayout(new BorderLayout());
        this.itemIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/xbup/catalog/item/resources/images/empty.png")));
        this.itemIconLabel.setName("itemIconLabel");
        this.iconPanel.add((Component)this.itemIconLabel, "Center");
        this.itemTitleLabel.setText("Unknown item");
        this.itemTitleLabel.setName("itemTitleLabel");
        this.jSeparator1.setName("jSeparator1");
        this.itemNameLabel.setText(this.resourceBundle.getString("itemNameLabel.text"));
        this.itemNameLabel.setName("itemNameLabel");
        this.itemNameTextField.setEditable(false);
        this.itemNameTextField.setName("itemNameTextField");
        this.itemPathLabel.setText("StringId");
        this.itemPathLabel.setName("itemPathLabel");
        this.itemPathTextField.setEditable(false);
        this.itemPathTextField.setName("itemPathTextField");
        this.itemTypeLabel.setText("Type");
        this.itemTypeLabel.setName("itemTypeLabel");
        this.itemTypeTextField.setEditable(false);
        this.itemTypeTextField.setName("itemTypeTextField");
        this.itemDescriptionLabel.setText(this.resourceBundle.getString("itemDescriptionLabel.text"));
        this.itemDescriptionLabel.setName("itemDescriptionLabel");
        this.itemDescriptionTextField.setEditable(false);
        this.itemDescriptionTextField.setName("itemDescriptionTextField");
        this.fullPathLabel.setText(this.resourceBundle.getString("fullPathLabel.text"));
        this.fullPathLabel.setName("fullPathLabel");
        this.fullPathTextField.setEditable(false);
        this.fullPathTextField.setName("fullPathTextField");
        this.fullPathTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CatalogItemPanel.this.fullPathTextFieldFocusGained(evt);
            }
        });
        this.itemCreatedLabel.setText(this.resourceBundle.getString("itemCreatedLabel.text"));
        this.itemCreatedLabel.setName("itemCreatedLabel");
        this.itemCreatedTextField.setEditable(false);
        this.itemCreatedTextField.setName("itemCreatedTextField");
        GroupLayout basicItemDataPanelLayout = new GroupLayout(this.basicItemDataPanel);
        this.basicItemDataPanel.setLayout(basicItemDataPanelLayout);
        basicItemDataPanelLayout.setHorizontalGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicItemDataPanelLayout.createSequentialGroup().addContainerGap().addGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicItemDataPanelLayout.createSequentialGroup().addComponent(this.iconPanel, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemTitleLabel, -1, 259, Short.MAX_VALUE)).addComponent(this.jSeparator1).addGroup(basicItemDataPanelLayout.createSequentialGroup().addGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.itemDescriptionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.fullPathLabel, -1, -1, Short.MAX_VALUE).addComponent(this.itemCreatedLabel, -1, -1, Short.MAX_VALUE).addComponent(this.itemTypeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.itemPathLabel, -1, -1, Short.MAX_VALUE).addComponent(this.itemNameLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fullPathTextField).addComponent(this.itemCreatedTextField).addComponent(this.itemPathTextField).addComponent(this.itemTypeTextField).addComponent(this.itemDescriptionTextField).addComponent(this.itemNameTextField)))).addContainerGap()));
        basicItemDataPanelLayout.setVerticalGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicItemDataPanelLayout.createSequentialGroup().addContainerGap().addGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.itemTitleLabel, -1, -1, Short.MAX_VALUE).addComponent(this.iconPanel, -1, 37, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 7, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.itemNameLabel, -2, 19, -2).addComponent(this.itemNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.itemPathLabel, -2, 19, -2).addComponent(this.itemPathTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.itemTypeLabel, -2, 19, -2).addComponent(this.itemTypeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.itemDescriptionLabel, -2, 19, -2).addComponent(this.itemDescriptionTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fullPathTextField).addComponent(this.fullPathLabel, -2, 19, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(basicItemDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.itemCreatedTextField, -2, -1, -2).addComponent(this.itemCreatedLabel, -2, 19, -2)).addContainerGap(56, Short.MAX_VALUE)));
        this.basicItemScrollPane.setViewportView(this.basicItemDataPanel);
        this.generalPanel.add((Component)this.basicItemScrollPane, "Center");
        this.mainTabbedPane.addTab("Basic", this.generalPanel);
        this.documentationPanel.setName("documentationPanel");
        this.itemHDocScrollPane.setName("itemHDocScrollPane");
        this.itemHDocEditorPane.setEditable(false);
        this.itemHDocEditorPane.setContentType("text/html");
        this.itemHDocEditorPane.setName("itemHDocEditorPane");
        this.itemHDocScrollPane.setViewportView(this.itemHDocEditorPane);
        GroupLayout documentationPanelLayout = new GroupLayout(this.documentationPanel);
        this.documentationPanel.setLayout(documentationPanelLayout);
        documentationPanelLayout.setHorizontalGroup(documentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.itemHDocScrollPane, -1, 335, Short.MAX_VALUE));
        documentationPanelLayout.setVerticalGroup(documentationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.itemHDocScrollPane, -1, 270, Short.MAX_VALUE));
        this.mainTabbedPane.addTab("Documentation", this.documentationPanel);
        this.revisionsPanel.setName("revisionsPanel");
        this.revisionsPanel.setLayout(new BorderLayout());
        this.itemRevisionsScrollPane.setName("itemRevisionsScrollPane");
        this.itemRevisionsTable.setModel((TableModel)this.revsModel);
        this.itemRevisionsTable.setName("itemRevisionsTable");
        this.itemRevisionsScrollPane.setViewportView(this.itemRevisionsTable);
        this.revisionsPanel.add((Component)this.itemRevisionsScrollPane, "Center");
        this.mainTabbedPane.addTab("Revisions", this.revisionsPanel);
        this.definitionPanel.setName("definitionPanel");
        this.definitionPanel.setLayout(new BorderLayout());
        this.itemDefinitionScrollPane.setComponentPopupMenu(this.definitionPopupMenu);
        this.itemDefinitionScrollPane.setName("itemDefinitionScrollPane");
        this.itemDefinitionTable.setModel((TableModel)this.defsModel);
        this.itemDefinitionTable.setComponentPopupMenu(this.definitionPopupMenu);
        this.itemDefinitionTable.setName("itemDefinitionTable");
        this.itemDefinitionTable.setSelectionMode(0);
        this.itemDefinitionScrollPane.setViewportView(this.itemDefinitionTable);
        this.definitionPanel.add((Component)this.itemDefinitionScrollPane, "Center");
        this.mainTabbedPane.addTab("Definition", this.definitionPanel);
        this.filesPanel.setName("filesPanel");
        this.filesPanel.setLayout(new BorderLayout());
        this.itemFilesScrollPane.setComponentPopupMenu(this.filesPopupMenu);
        this.itemFilesScrollPane.setName("itemFilesScrollPane");
        this.itemFilesTable.setModel(this.filesModel);
        this.itemFilesTable.setComponentPopupMenu(this.filesPopupMenu);
        this.itemFilesTable.setName("itemFilesTable");
        this.itemFilesScrollPane.setViewportView(this.itemFilesTable);
        this.filesPanel.add((Component)this.itemFilesScrollPane, "Center");
        this.mainTabbedPane.addTab("Files", this.filesPanel);
        this.add((Component)this.mainTabbedPane, "Center");
    }

    private void jumpToMenuItemActionPerformed(ActionEvent evt) {
        CatalogDefsTableModel model = (CatalogDefsTableModel)this.itemDefinitionTable.getModel();
        CatalogDefsTableItem rowItem = model.getRowItem(this.itemDefinitionTable.getSelectedRow());
        XBCRev target = rowItem.getTarget();
        if (this.jumpActionListener != null) {
            this.jumpActionListener.jumpToRev(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportFileMenuItemActionPerformed(ActionEvent evt) {
        XBCXFile file = this.filesModel.getItem(this.itemFilesTable.getSelectedRow());
        JFileChooser exportFileChooser = new JFileChooser(file.getFilename());
        exportFileChooser.setAcceptAllFileFilterUsed(true);
        if (exportFileChooser.showSaveDialog(UiUtils.getFrame((Component)this)) == 0) {
            try (FileOutputStream fileStream = new FileOutputStream(exportFileChooser.getSelectedFile().getAbsolutePath());){
                fileStream.write(file.getContent());
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(CatalogItemPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(CatalogItemPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void fullPathTextFieldFocusGained(FocusEvent evt) {
        this.fullPathTextField.selectAll();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogItemPanel());
    }

    public XBCItem getItem() {
        return this.item;
    }

    public void setItem(XBCItem item) {
        this.item = item;
        this.reloadItem();
    }

    private CatalogItemType getItemType() {
        CatalogItemType itemType = CatalogItemType.NODE;
        if (this.item instanceof XBCBlockSpec) {
            itemType = CatalogItemType.BLOCK;
        } else if (this.item instanceof XBCGroupSpec) {
            itemType = CatalogItemType.GROUP;
        } else if (this.item instanceof XBCFormatSpec) {
            itemType = CatalogItemType.FORMAT;
        }
        return itemType;
    }

    private void reloadItem() {
        if (this.item != null) {
            boolean isSpec = this.item instanceof XBCSpec;
            if (isSpec) {
                if (this.item instanceof XBCFormatSpec) {
                    this.itemTypeTextField.setText("Format Specification");
                } else if (this.item instanceof XBCGroupSpec) {
                    this.itemTypeTextField.setText("Group Specification");
                } else if (this.item instanceof XBCBlockSpec) {
                    this.itemTypeTextField.setText("Block Specification");
                } else {
                    this.itemTypeTextField.setText("Failed to recognize");
                }
            } else {
                this.itemTypeTextField.setText("Node");
            }
            Long xbIndex = this.item.getXBIndex();
            Long itemId = this.item.getId();
            this.itemName = this.nameService.getDefaultItemName(this.item);
            this.itemNameTextField.setText(this.itemName == null ? "" : this.itemName.getText());
            this.itemDesc = this.descService.getDefaultItemDesc(this.item);
            this.itemDescriptionTextField.setText(this.itemDesc == null ? "" : this.itemDesc.getText());
            this.itemTitleLabel.setText((this.itemName == null ? "-" : this.itemName.getText()) + " (" + (xbIndex == null ? "" : xbIndex.toString()) + ")");
            String fullPath = "";
            if (this.item instanceof XBCSpec || this.item instanceof XBCNode) {
                Long[] specPath;
                Long[] longArray = specPath = this.item instanceof XBCNode ? this.nodeService.getNodeXBPath((XBCNode)this.item) : this.catalog.getSpecPath((XBCSpec)this.item);
                if (specPath != null) {
                    StringBuilder pathBuilder = new StringBuilder();
                    for (Long pathIndex : specPath) {
                        if (pathBuilder.length() > 0) {
                            pathBuilder.append(", ");
                        }
                        pathBuilder.append(pathIndex);
                    }
                    fullPath = "{" + pathBuilder.toString() + "}";
                }
            }
            this.fullPathTextField.setText(fullPath);
            XBCXStri stringId = this.striService.getItemStringId(this.item);
            this.itemPathTextField.setText(stringId == null ? "" : stringId.getText());
            this.itemHDocEditorPane.setText(null);
            this.itemHDoc = this.hDocService.getDocumentation(this.item);
            if (this.itemHDoc != null && this.itemHDoc.getDocFile() != null) {
                XBCXFile itemHDocFile = this.itemHDoc.getDocFile();
                InputStream fileStream = this.fileService.getFile(itemHDocFile);
                try {
                    this.itemHDocEditorPane.getEditorKit().createDefaultDocument();
                    this.itemHDocEditorPane.read(fileStream, (Object)this.itemHDocEditorPane.getDocument());
                }
                catch (IOException | RuntimeException ex) {
                    Logger.getLogger(CatalogItemPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.itemIcon = this.iconService.getDefaultIcon(this.item);
            if (this.itemIcon != null) {
                ImageIcon icon = this.iconService.getDefaultImageIcon(this.item);
                this.itemIconLabel.setIcon(icon);
            } else {
                this.itemIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/xbup/catalog/item/resources/images/empty.png")));
            }
        } else {
            this.itemTitleLabel.setText("unknown");
            this.itemTypeTextField.setText("unknown");
            this.itemNameTextField.setText("");
            this.itemDescriptionTextField.setText("");
            this.itemHDocEditorPane.setText("");
            this.fullPathTextField.setText("");
        }
        this.revsModel.setSpec(this.item instanceof XBCSpec ? (XBCSpec)this.item : null);
        this.defsModel.setCatalogItem(this.item);
        this.defsModel.setRevsModel(this.revsModel);
        this.definitionTableUpdated();
        this.filesModel.setNode(this.item instanceof XBCNode ? (XBCNode)this.item : null);
        this.itemFilesTable.revalidate();
        this.fileTableUpdated();
    }

    public JumpActionListener getJumpActionListener() {
        return this.jumpActionListener;
    }

    public void setJumpActionListener(JumpActionListener jumpActionListener) {
        this.jumpActionListener = jumpActionListener;
    }

    private void definitionTableUpdated() {
        int rowIndex;
        if (this.jumpActionListener != null && (rowIndex = this.itemDefinitionTable.getSelectedRow()) >= 0 && this.defsModel.getRowItem(rowIndex).getTarget() != null) {
            this.jumpToMenuItem.setEnabled(true);
            return;
        }
        this.jumpToMenuItem.setEnabled(false);
    }

    private void fileTableUpdated() {
        int rowIndex = this.itemFilesTable.getSelectedRow();
        this.exportFileMenuItem.setEnabled(rowIndex >= 0);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.nodeService = catalog == null ? null : (XBCNodeService)catalog.getCatalogService(XBCNodeService.class);
        this.striService = catalog == null ? null : (XBCXStriService)catalog.getCatalogService(XBCXStriService.class);
        this.nameService = catalog == null ? null : (XBCXNameService)catalog.getCatalogService(XBCXNameService.class);
        this.descService = catalog == null ? null : (XBCXDescService)catalog.getCatalogService(XBCXDescService.class);
        this.hDocService = catalog == null ? null : (XBCXHDocService)catalog.getCatalogService(XBCXHDocService.class);
        this.fileService = catalog == null ? null : (XBCXFileService)catalog.getCatalogService(XBCXFileService.class);
        this.iconService = catalog == null ? null : (XBCXIconService)catalog.getCatalogService(XBCXIconService.class);
        this.defsModel.setCatalog(catalog);
        this.revsModel.setCatalog((XBCatalog)catalog);
        this.filesModel.setCatalog((XBCatalog)catalog);
        this.reloadItem();
    }

    public static interface JumpActionListener {
        public void jumpToRev(XBCRev var1);
    }
}

