/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.xbup.catalog.XBFileType;
import org.exbin.framework.xbup.catalog.YamlFileType;
import org.exbin.xbup.catalog.convert.XBCatalogYaml;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCFormatDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCGroupDecl;
import org.exbin.xbup.core.block.declaration.local.XBLFormatDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatRev;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupRev;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.basic.convert.XBTTypeUndeclaringFilter;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTEventListenerToListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTListenerToEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTToXBEventConvertor;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;

@ParametersAreNonnullByDefault
public class ExportItemAction
extends AbstractAction {
    public static final String ACTION_ID = "exportItemAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ExportItemAction.class);
    private final XBCatalogYaml catalogYaml = new XBCatalogYaml();
    private XBApplication application;
    private XBACatalog catalog;
    private XBCSpecService specService;
    private XBCRevService revService;
    private Component parentComponent;
    private XBCItem currentItem;

    public void setup(XBApplication application, XBACatalog catalog) {
        this.application = application;
        this.catalog = catalog;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    @Nullable
    public XBCItem getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(@Nullable XBCItem currentItem) {
        this.currentItem = currentItem;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(@Nullable ActionEvent arg0) {
        if (this.currentItem == null) return;
        JFileChooser exportFileChooser = new JFileChooser();
        YamlFileType yamlFileType = new YamlFileType();
        XBFileType xbFileType = new XBFileType();
        exportFileChooser.addChoosableFileFilter(yamlFileType);
        exportFileChooser.addChoosableFileFilter(xbFileType);
        exportFileChooser.setAcceptAllFileFilterUsed(true);
        if (exportFileChooser.showSaveDialog(this.parentComponent) != 0) return;
        if (exportFileChooser.getFileFilter() == yamlFileType) {
            try (FileWriter fileWriter = new FileWriter(exportFileChooser.getSelectedFile().getAbsolutePath());){
                this.catalogYaml.exportCatalogItem(this.currentItem, (Writer)fileWriter);
                return;
            }
            catch (IOException ex) {
                Logger.getLogger(ExportItemAction.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
        if (exportFileChooser.getFileFilter() != xbFileType) throw new IllegalStateException("Unknown file type");
        if (!(this.currentItem instanceof XBCSpec)) throw new UnsupportedOperationException("Not supported yet.");
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(exportFileChooser.getSelectedFile().getAbsolutePath());
            long revision = this.revService.findMaxRevXB((XBCSpec)this.currentItem);
            XBCRev specRev = this.revService.findRevByXB((XBCSpec)this.currentItem, revision);
            XBLFormatDecl decl = this.currentItem instanceof XBCFormatSpec ? this.specService.getFormatDeclAsLocal(new XBCFormatDecl((XBCFormatRev)specRev, (XBCatalog)this.catalog)) : (this.currentItem instanceof XBCGroupSpec ? this.specService.getGroupDeclAsLocal(new XBCGroupDecl((XBCGroupRev)specRev, (XBCatalog)this.catalog)) : (this.currentItem instanceof XBCBlockSpec ? this.specService.getBlockDeclAsLocal(new XBCBlockDecl((XBCBlockRev)specRev, (XBCatalog)this.catalog)) : null));
            XBTTypeUndeclaringFilter typeProcessing = new XBTTypeUndeclaringFilter((XBCatalog)this.catalog);
            typeProcessing.attachXBTListener((XBTListener)new XBTEventListenerToListener((XBTEventListener)new XBTToXBEventConvertor((XBEventListener)new XBEventWriter((OutputStream)output))));
            XBPSerialWriter writer = new XBPSerialWriter((XBTEventListener)new XBTListenerToEventListener((XBTListener)typeProcessing));
            writer.write((XBSerializable)decl);
            return;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ExportItemAction.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ExportItemAction.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ExportItemAction.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void setCatalog(@Nullable XBACatalog catalog) {
        this.catalog = catalog;
        this.specService = catalog == null ? null : (XBCSpecService)catalog.getCatalogService(XBCSpecService.class);
        this.revService = catalog == null ? null : (XBCRevService)catalog.getCatalogService(XBCRevService.class);
        this.catalogYaml.setCatalog(catalog);
    }
}

