/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.item.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;

@ParametersAreNonnullByDefault
public class DeleteCatalogItemAction
extends AbstractAction {
    public static final String ACTION_ID = "deleteCatalogItemAction";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(DeleteCatalogItemAction.class);
    private XBApplication application;
    private XBACatalog catalog;
    private Component parentComponent;
    private XBCItem currentItem;

    public void setup(XBApplication application) {
        this.application = application;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    @Nullable
    public XBCItem getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(@Nullable XBCItem currentItem) {
        this.currentItem = currentItem;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Objects.requireNonNull(this.catalog);
        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
        XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        Object[] options = new Object[]{"Delete", "Cancel"};
        int result = JOptionPane.showOptionDialog(this.parentComponent, "Are you sure you want to delete this item?", "Delete Item", 1, 3, null, options, options[0]);
        if (result == 0) {
            EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
            EntityTransaction transaction = em.getTransaction();
            transaction.begin();
            List names = nameService.getItemNames(this.currentItem);
            for (Object name : names) {
                nameService.removeItem((XBCBase)name);
            }
            List descs = descService.getItemDescs(this.currentItem);
            for (XBCXDesc desc : descs) {
                descService.removeItem((XBCBase)desc);
            }
            XBCXStri stri = striService.getItemStringId(this.currentItem);
            if (stri != null) {
                striService.removeItem((XBCBase)stri);
            }
            if (this.currentItem instanceof XBCNode) {
                nodeService.removeItem((XBCBase)((XBCNode)this.currentItem));
            } else {
                specService.removeItem((XBCBase)((XBCSpec)this.currentItem));
            }
            em.flush();
            transaction.commit();
        }
    }
}

