/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.catalog.gui.CatalogExtensionsListModel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.service.XBENodeService;
import org.exbin.xbup.catalog.entity.service.XBERootService;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.service.XBCItemService;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCRootService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;

@ParametersAreNonnullByDefault
public class CatalogStatusPanel
extends JPanel {
    private static final String UNKNOWN = "unknown";
    private XBACatalog catalog;
    private final CatalogExtensionsListModel extModel = new CatalogExtensionsListModel();
    private JLabel blocksCountLabel;
    private JTextField blocksCountTextField;
    private JPanel catalogStatusBorderPanel;
    private JPanel catalogStatusPanel;
    private JLabel defsCountLabel;
    private JTextField defsCountTextField;
    private JPanel extensionsBorderPanel;
    private JList<String> extensionsList;
    private JScrollPane extensionsScrollPane;
    private JLabel formatsCountLabel;
    private JTextField formatsCountTextField;
    private JLabel groupsCountLabel;
    private JTextField groupsCountTextField;
    private JLabel itemsCountLabel;
    private JTextField itemsCountTextField;
    private JLabel lastUpdateLabel;
    private JButton lastUpdateNowButton;
    private JPanel lastUpdatePanel;
    private JTextField lastUpdateTextField;
    private JLabel nodesCountLabel;
    private JTextField nodesCountTextField;
    private JLabel revsCountLabel;
    private JTextField revsCountTextField;
    private JLabel specsCountLabel;
    private JTextField specsCountTextField;

    public CatalogStatusPanel() {
        this.initComponents();
        this.updateCatalog();
        JList<String> newList = new JList<String>();
        newList.setModel(this.extModel);
        this.extensionsList = newList;
        this.extensionsScrollPane.setViewportView(this.extensionsList);
    }

    private void initComponents() {
        this.catalogStatusBorderPanel = new JPanel();
        this.catalogStatusPanel = new JPanel();
        this.itemsCountLabel = new JLabel();
        this.itemsCountTextField = new JTextField();
        this.nodesCountLabel = new JLabel();
        this.nodesCountTextField = new JTextField();
        this.specsCountLabel = new JLabel();
        this.specsCountTextField = new JTextField();
        this.formatsCountLabel = new JLabel();
        this.formatsCountTextField = new JTextField();
        this.groupsCountLabel = new JLabel();
        this.groupsCountTextField = new JTextField();
        this.blocksCountLabel = new JLabel();
        this.blocksCountTextField = new JTextField();
        this.defsCountLabel = new JLabel();
        this.defsCountTextField = new JTextField();
        this.revsCountLabel = new JLabel();
        this.revsCountTextField = new JTextField();
        this.lastUpdateLabel = new JLabel();
        this.lastUpdatePanel = new JPanel();
        this.lastUpdateTextField = new JTextField();
        this.lastUpdateNowButton = new JButton();
        this.extensionsBorderPanel = new JPanel();
        this.extensionsScrollPane = new JScrollPane();
        this.extensionsList = new JList();
        this.catalogStatusBorderPanel.setBorder(BorderFactory.createTitledBorder("Catalog Status"));
        this.catalogStatusPanel.setLayout(new GridLayout(9, 2));
        this.itemsCountLabel.setText("Count of Items");
        this.catalogStatusPanel.add(this.itemsCountLabel);
        this.itemsCountTextField.setEditable(false);
        this.itemsCountTextField.setText(UNKNOWN);
        this.itemsCountTextField.setBorder(null);
        this.catalogStatusPanel.add(this.itemsCountTextField);
        this.nodesCountLabel.setText("Nodes");
        this.catalogStatusPanel.add(this.nodesCountLabel);
        this.nodesCountTextField.setEditable(false);
        this.nodesCountTextField.setText(UNKNOWN);
        this.nodesCountTextField.setBorder(null);
        this.catalogStatusPanel.add(this.nodesCountTextField);
        this.specsCountLabel.setText("Specifications");
        this.catalogStatusPanel.add(this.specsCountLabel);
        this.specsCountTextField.setEditable(false);
        this.specsCountTextField.setText(UNKNOWN);
        this.specsCountTextField.setBorder(null);
        this.catalogStatusPanel.add(this.specsCountTextField);
        this.formatsCountLabel.setText("Formats");
        this.catalogStatusPanel.add(this.formatsCountLabel);
        this.formatsCountTextField.setEditable(false);
        this.formatsCountTextField.setText(UNKNOWN);
        this.formatsCountTextField.setBorder(null);
        this.catalogStatusPanel.add(this.formatsCountTextField);
        this.groupsCountLabel.setText("Groups");
        this.catalogStatusPanel.add(this.groupsCountLabel);
        this.groupsCountTextField.setEditable(false);
        this.groupsCountTextField.setText(UNKNOWN);
        this.groupsCountTextField.setBorder(null);
        this.catalogStatusPanel.add(this.groupsCountTextField);
        this.blocksCountLabel.setText("Blocks");
        this.catalogStatusPanel.add(this.blocksCountLabel);
        this.blocksCountTextField.setEditable(false);
        this.blocksCountTextField.setText(UNKNOWN);
        this.blocksCountTextField.setBorder(null);
        this.catalogStatusPanel.add(this.blocksCountTextField);
        this.defsCountLabel.setText("Defs");
        this.catalogStatusPanel.add(this.defsCountLabel);
        this.defsCountTextField.setEditable(false);
        this.defsCountTextField.setText(UNKNOWN);
        this.defsCountTextField.setBorder(null);
        this.catalogStatusPanel.add(this.defsCountTextField);
        this.revsCountLabel.setText("Revisions");
        this.catalogStatusPanel.add(this.revsCountLabel);
        this.revsCountTextField.setEditable(false);
        this.revsCountTextField.setText(UNKNOWN);
        this.revsCountTextField.setBorder(null);
        this.catalogStatusPanel.add(this.revsCountTextField);
        this.lastUpdateLabel.setText("Last Update");
        this.catalogStatusPanel.add(this.lastUpdateLabel);
        this.lastUpdateTextField.setEditable(false);
        this.lastUpdateTextField.setText(UNKNOWN);
        this.lastUpdateTextField.setBorder(null);
        this.lastUpdateNowButton.setText("Set Now");
        this.lastUpdateNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogStatusPanel.this.lastUpdateNowButtonActionPerformed(evt);
            }
        });
        GroupLayout lastUpdatePanelLayout = new GroupLayout(this.lastUpdatePanel);
        this.lastUpdatePanel.setLayout(lastUpdatePanelLayout);
        lastUpdatePanelLayout.setHorizontalGroup(lastUpdatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lastUpdatePanelLayout.createSequentialGroup().addComponent(this.lastUpdateTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastUpdateNowButton)));
        lastUpdatePanelLayout.setVerticalGroup(lastUpdatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lastUpdateNowButton, -2, 0, Short.MAX_VALUE).addComponent(this.lastUpdateTextField));
        this.catalogStatusPanel.add(this.lastUpdatePanel);
        GroupLayout catalogStatusBorderPanelLayout = new GroupLayout(this.catalogStatusBorderPanel);
        this.catalogStatusBorderPanel.setLayout(catalogStatusBorderPanelLayout);
        catalogStatusBorderPanelLayout.setHorizontalGroup(catalogStatusBorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(catalogStatusBorderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.catalogStatusPanel, -1, 319, Short.MAX_VALUE).addContainerGap()));
        catalogStatusBorderPanelLayout.setVerticalGroup(catalogStatusBorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.catalogStatusPanel, GroupLayout.Alignment.TRAILING, -1, 211, Short.MAX_VALUE));
        this.extensionsBorderPanel.setBorder(BorderFactory.createTitledBorder("Extensions"));
        this.extensionsScrollPane.setViewportView(this.extensionsList);
        GroupLayout extensionsBorderPanelLayout = new GroupLayout(this.extensionsBorderPanel);
        this.extensionsBorderPanel.setLayout(extensionsBorderPanelLayout);
        extensionsBorderPanelLayout.setHorizontalGroup(extensionsBorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, extensionsBorderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.extensionsScrollPane).addContainerGap()));
        extensionsBorderPanelLayout.setVerticalGroup(extensionsBorderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extensionsBorderPanelLayout.createSequentialGroup().addComponent(this.extensionsScrollPane, -1, 152, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.extensionsBorderPanel, -1, -1, Short.MAX_VALUE).addComponent(this.catalogStatusBorderPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.catalogStatusBorderPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extensionsBorderPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void lastUpdateNowButtonActionPerformed(ActionEvent evt) {
        XBCNodeService nodeService;
        XBCRootService rootService = this.catalog == null ? null : (XBCRootService)this.catalog.getCatalogService(XBCRootService.class);
        XBCNodeService xBCNodeService = nodeService = this.catalog == null ? null : (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        if (rootService instanceof XBERootService && nodeService instanceof XBENodeService) {
            EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
            EntityTransaction transaction = em.getTransaction();
            transaction.begin();
            ((XBERootService)rootService).setMainLastUpdateToNow();
            transaction.commit();
            em.refresh((Object)rootService.getMainRoot());
            Optional lastUpdate = rootService.getMainLastUpdate();
            this.lastUpdateTextField.setText(lastUpdate.isPresent() ? ((Date)lastUpdate.get()).toString() : "");
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogStatusPanel());
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.updateCatalog();
    }

    private void updateCatalog() {
        this.extModel.setCatalog(this.catalog);
        XBCRootService rootService = null;
        XBCNodeService nodeService = null;
        XBCSpecService specService = null;
        XBCRevService revService = null;
        if (this.catalog != null) {
            rootService = (XBCRootService)this.catalog.getCatalogService(XBCRootService.class);
            nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
            specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
            revService = (XBCRevService)this.catalog.getCatalogService(XBCRevService.class);
        }
        this.lastUpdateNowButton.setEnabled(this.catalog instanceof XBECatalog);
        Long count = this.catalog == null ? null : Long.valueOf(((XBCItemService)this.catalog.getCatalogService(XBCItemService.class)).getItemsCount());
        this.itemsCountTextField.setText(count == null ? UNKNOWN : count.toString());
        count = nodeService == null ? null : Long.valueOf(nodeService.getItemsCount());
        this.nodesCountTextField.setText(count == null ? UNKNOWN : count.toString());
        count = specService == null ? null : Long.valueOf(specService.getItemsCount());
        this.specsCountTextField.setText(count == null ? UNKNOWN : count.toString());
        count = specService == null ? null : Long.valueOf(specService.getDefsCount());
        this.defsCountTextField.setText(count == null ? UNKNOWN : count.toString());
        count = specService == null ? null : specService.getAllFormatSpecsCount();
        this.formatsCountTextField.setText(count == null ? UNKNOWN : count.toString());
        count = specService == null ? null : specService.getAllGroupSpecsCount();
        this.groupsCountTextField.setText(count == null ? UNKNOWN : count.toString());
        count = specService == null ? null : specService.getAllBlockSpecsCount();
        this.blocksCountTextField.setText(count == null ? UNKNOWN : count.toString());
        count = revService == null ? null : Long.valueOf(revService.getItemsCount());
        this.revsCountTextField.setText(count == null ? UNKNOWN : count.toString());
        count = revService == null ? null : Long.valueOf(revService.getItemsCount());
        this.revsCountTextField.setText(count == null ? UNKNOWN : count.toString());
        Date date = rootService == null ? null : (Date)rootService.getMainLastUpdate().orElse(null);
        this.lastUpdateTextField.setText(date == null ? UNKNOWN : date.toString());
    }
}

