/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import org.exbin.framework.action.api.MenuManagement;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.xbup.catalog.XbupCatalogHandler;
import org.exbin.framework.xbup.catalog.item.gui.CatalogEditItemPanel;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXDesc;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;

@ParametersAreNonnullByDefault
public class CatalogBrowserPanel
extends JPanel {
    private XBApplication application;
    private XBCItem currentItem;
    private XBACatalog catalog;
    private XbupCatalogHandler serviceManagerHandler;
    private XBCNodeService nodeService;
    private XBCSpecService specService;
    private XBCXNameService nameService;
    private XBCXDescService descService;
    private XBCXStriService striService;
    private final Map<String, ActionListener> actionListenerMap = new HashMap<String, ActionListener>();
    private MenuManagement menuManagement;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(CatalogBrowserPanel.class);
    private JSplitPane catalogItemSplitPane;
    private JPopupMenu catalogTreePopupMenu;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSplitPane panelSplitPane;
    private JMenuItem popupEditMenuItem;
    private JMenuItem popupRefreshMenuItem;
    private JLabel temporaryLabel;
    private JPanel temporaryPanel;

    public CatalogBrowserPanel() {
        this.initComponents();
        this.updateItem();
        this.actionListenerMap.put("cut-to-clipboard", e -> this.performCut());
        this.actionListenerMap.put("copy-to-clipboard", e -> this.performCopy());
        this.actionListenerMap.put("paste-from-clipboard", e -> this.performPaste());
        this.actionListenerMap.put("delete-next", e -> this.performDelete());
        this.actionListenerMap.put("delete", e -> this.performDelete());
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    private void initComponents() {
        this.catalogTreePopupMenu = new JPopupMenu();
        this.popupEditMenuItem = new JMenuItem();
        this.popupRefreshMenuItem = new JMenuItem();
        this.panelSplitPane = new JSplitPane();
        this.catalogItemSplitPane = new JSplitPane();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.temporaryPanel = new JPanel();
        this.temporaryLabel = new JLabel();
        this.catalogTreePopupMenu.setName("catalogTreePopupMenu");
        this.popupEditMenuItem.setText(this.resourceBundle.getString("editMenuItem.text"));
        this.popupEditMenuItem.setToolTipText(this.resourceBundle.getString("editMenuItem.toolTipText"));
        this.popupEditMenuItem.setName("popupEditMenuItem");
        this.popupEditMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogBrowserPanel.this.popupEditMenuItemActionPerformed(evt);
            }
        });
        this.catalogTreePopupMenu.add(this.popupEditMenuItem);
        this.popupRefreshMenuItem.setText(this.resourceBundle.getString("refreshMenuItem.text"));
        this.popupRefreshMenuItem.setToolTipText(this.resourceBundle.getString("refreshMenuItem.toolTipText"));
        this.popupRefreshMenuItem.setName("popupRefreshMenuItem");
        this.popupRefreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogBrowserPanel.this.popupRefreshMenuItemActionPerformed(evt);
            }
        });
        this.catalogTreePopupMenu.add(this.popupRefreshMenuItem);
        this.setName("Form");
        this.setLayout(new BorderLayout());
        this.panelSplitPane.setDividerLocation(100);
        this.panelSplitPane.setName("panelSplitPane");
        this.catalogItemSplitPane.setDividerLocation(180);
        this.catalogItemSplitPane.setOrientation(0);
        this.catalogItemSplitPane.setName("catalogItemSplitPane");
        this.jLabel1.setText("Packages");
        this.jLabel1.setName("jLabel1");
        this.catalogItemSplitPane.setTopComponent(this.jLabel1);
        this.jLabel2.setText("Items");
        this.jLabel2.setName("jLabel2");
        this.catalogItemSplitPane.setRightComponent(this.jLabel2);
        this.panelSplitPane.setLeftComponent(this.catalogItemSplitPane);
        this.temporaryPanel.setName("temporaryPanel");
        this.temporaryPanel.setLayout(new BorderLayout());
        this.temporaryLabel.setHorizontalAlignment(0);
        this.temporaryLabel.setText("TBD");
        this.temporaryLabel.setName("temporaryLabel");
        this.temporaryPanel.add((Component)this.temporaryLabel, "Center");
        this.panelSplitPane.setRightComponent(this.temporaryPanel);
        this.add((Component)this.panelSplitPane, "Center");
    }

    private void popupEditMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentItem != null) {
            FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
            CatalogEditItemPanel editPanel = new CatalogEditItemPanel();
            editPanel.setApplication(this.application);
            editPanel.setMenuManagement(this.menuManagement);
            editPanel.setCatalog(this.catalog);
            editPanel.setCatalogItem(this.currentItem);
            DefaultControlPanel controlPanel = new DefaultControlPanel();
            WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)editPanel, (JPanel)controlPanel);
            WindowUtils.addHeaderPanel((Window)dialog.getWindow(), editPanel.getClass(), (ResourceBundle)editPanel.getResourceBundle());
            controlPanel.setHandler(actionType -> {
                if (actionType == DefaultControlHandler.ControlActionType.OK) {
                    EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
                    EntityTransaction transaction = em.getTransaction();
                    transaction.begin();
                    editPanel.persist();
                    this.setItem(this.currentItem);
                    em.flush();
                    transaction.commit();
                }
                dialog.close();
            });
            dialog.showCentered((Component)this);
            dialog.dispose();
        }
    }

    private void popupRefreshMenuItemActionPerformed(ActionEvent evt) {
        Component invoker = this.catalogTreePopupMenu.getInvoker();
        this.reloadNodesTree();
    }

    public void setNode(XBCNode node) {
        this.setItem((XBCItem)node);
    }

    public void setItem(XBCItem item) {
        this.currentItem = item;
        if (this.serviceManagerHandler != null) {
            // empty if block
        }
        this.updateItem();
    }

    public void setServiceManagerHandler(XbupCatalogHandler serviceManagerHandler) {
        this.serviceManagerHandler = serviceManagerHandler;
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new CatalogBrowserPanel());
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.nodeService = catalog == null ? null : (XBCNodeService)catalog.getCatalogService(XBCNodeService.class);
        this.specService = catalog == null ? null : (XBCSpecService)catalog.getCatalogService(XBCSpecService.class);
        this.nameService = catalog == null ? null : (XBCXNameService)catalog.getCatalogService(XBCXNameService.class);
        this.descService = catalog == null ? null : (XBCXDescService)catalog.getCatalogService(XBCXDescService.class);
        this.striService = catalog == null ? null : (XBCXStriService)catalog.getCatalogService(XBCXStriService.class);
        this.reloadNodesTree();
    }

    public void performCut() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performCopy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performPaste() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performDelete() {
        Object[] options = new Object[]{"Delete", "Cancel"};
        int result = JOptionPane.showOptionDialog(this, "Are you sure you want to delete this item?", "Delete Item", 1, 3, null, options, options[0]);
        if (result == 0) {
            EntityManager em = ((XBECatalog)this.catalog).getEntityManager();
            EntityTransaction transaction = em.getTransaction();
            transaction.begin();
            List names = this.nameService.getItemNames(this.currentItem);
            for (Object name : names) {
                this.nameService.removeItem((XBCBase)name);
            }
            List descs = this.descService.getItemDescs(this.currentItem);
            for (XBCXDesc desc : descs) {
                this.descService.removeItem((XBCBase)desc);
            }
            XBCXStri stri = this.striService.getItemStringId(this.currentItem);
            if (stri != null) {
                this.striService.removeItem((XBCBase)stri);
            }
            if (this.currentItem instanceof XBCNode) {
                this.nodeService.removeItem((XBCBase)((XBCNode)this.currentItem));
            } else {
                this.specService.removeItem((XBCBase)((XBCSpec)this.currentItem));
            }
            em.flush();
            transaction.commit();
            this.repaint();
        }
    }

    public static String getExtension(File file) {
        String ext = null;
        String str = file.getName();
        int i = str.lastIndexOf(46);
        if (i > 0 && i < str.length() - 1) {
            ext = str.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public void setMenuManagement(MenuManagement menuManagement) {
        this.menuManagement = menuManagement;
        menuManagement.insertMainPopupMenu(this.catalogTreePopupMenu, 4);
    }

    private void reloadNodesTree() {
    }

    private void updateItem() {
        this.popupEditMenuItem.setEnabled(this.currentItem != null);
    }
}

