/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog.gui;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;

@ParametersAreNonnullByDefault
public class AddCatalogPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AddCatalogPanel.class);
    private XBACatalog catalog;
    private XBApplication application;
    private ButtonGroup buttonGroup;
    private JLabel catalogUrlLabel;
    private JTextField catalogUrlTextField;
    private JRadioButton newRadioButton;
    private JComboBox<String> publicCatalogsComboBox;
    private JRadioButton publicRadioButton;
    private JRadioButton urlRadioButton;

    public AddCatalogPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.urlRadioButton.addChangeListener(e -> this.catalogUrlTextField.setEnabled(this.urlRadioButton.isSelected()));
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.newRadioButton = new JRadioButton();
        this.urlRadioButton = new JRadioButton();
        this.catalogUrlLabel = new JLabel();
        this.catalogUrlTextField = new JTextField();
        this.publicRadioButton = new JRadioButton();
        this.publicCatalogsComboBox = new JComboBox();
        this.buttonGroup.add(this.newRadioButton);
        this.newRadioButton.setSelected(true);
        this.newRadioButton.setText("Create new catalog");
        this.buttonGroup.add(this.urlRadioButton);
        this.urlRadioButton.setText("Download from URL");
        this.catalogUrlLabel.setText("URL");
        this.catalogUrlTextField.setEnabled(false);
        this.buttonGroup.add(this.publicRadioButton);
        this.publicRadioButton.setText("Public Catalogs");
        this.publicCatalogsComboBox.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.catalogUrlLabel, -2, 29, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.publicCatalogsComboBox, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newRadioButton).addComponent(this.urlRadioButton).addComponent(this.publicRadioButton)).addGap(0, 657, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.catalogUrlTextField))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.newRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.urlRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogUrlLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogUrlTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.publicRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.publicCatalogsComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        AddCatalogPanel addCatalogPanel = new AddCatalogPanel();
        WindowUtils.invokeDialog((JComponent)addCatalogPanel);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    @Nonnull
    public String getCatalogUrl() {
        if (this.urlRadioButton.isSelected()) {
            return this.catalogUrlTextField.getText();
        }
        return "";
    }
}

