/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.catalog;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.filechooser.FileFilter;
import org.exbin.framework.file.api.FileType;

@ParametersAreNonnullByDefault
public class XBFileType
extends FileFilter
implements FileType {
    public static final String XB_FILE_TYPE = "XBFileType";

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String extension = XBFileType.getExtension(file);
        if (extension != null) {
            return "xb".equals(extension);
        }
        return false;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "XB File (*.xb)";
    }

    @Nonnull
    public String getFileTypeId() {
        return XB_FILE_TYPE;
    }

    @Nullable
    public static String getExtension(File file) {
        String ext = null;
        String str = file.getName();
        int extPos = str.lastIndexOf(46);
        if (extPos > 0 && extPos < str.length() - 1) {
            ext = str.substring(extPos + 1).toLowerCase();
        }
        return ext;
    }
}

