/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.inspector.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinEdFileHandler;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.inspector.BinEdComponentInspector;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.file.api.FileDependentAction;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class ShowParsingPanelAction
extends AbstractAction
implements FileDependentAction {
    public static final String ACTION_ID = "showParsingPanelAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
        ActionUtils.setupAction((Action)this, (ResourceBundle)resourceBundle, (String)ACTION_ID);
        this.putValue("type", ActionUtils.ActionType.CHECK);
    }

    public void updateForActiveFile() {
        Optional activeFile = this.editorProvider.getActiveFile();
        Boolean showParsingPanel = null;
        if (activeFile.isPresent()) {
            BinEdComponentPanel component = ((BinEdFileHandler)activeFile.get()).getComponent();
            BinEdComponentInspector componentExtension = (BinEdComponentInspector)component.getComponentExtension(BinEdComponentInspector.class);
            showParsingPanel = componentExtension.isShowParsingPanel();
        }
        this.setEnabled(activeFile.isPresent());
        if (showParsingPanel != null) {
            this.putValue("SwingSelectedKey", showParsingPanel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        BinEdComponentPanel component = ((BinEdFileHandler)activeFile.get()).getComponent();
        BinEdComponentInspector componentExtension = (BinEdComponentInspector)component.getComponentExtension(BinEdComponentInspector.class);
        this.setShowValuesPanel(!componentExtension.isShowParsingPanel());
    }

    public void setShowValuesPanel(boolean show) {
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            throw new IllegalStateException();
        }
        BinEdComponentPanel component = ((BinEdFileHandler)activeFile.get()).getComponent();
        BinEdComponentInspector componentExtension = (BinEdComponentInspector)component.getComponentExtension(BinEdComponentInspector.class);
        componentExtension.setShowParsingPanel(show);
        this.putValue("SwingSelectedKey", show);
    }
}

