/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.data.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;
import org.exbin.framework.data.model.CatalogDefOperationType;
import org.exbin.framework.data.model.CatalogDefsTableItem;
import org.exbin.framework.data.model.CatalogRevsTableModel;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockCons;
import org.exbin.xbup.core.catalog.base.XBCBlockJoin;
import org.exbin.xbup.core.catalog.base.XBCBlockListCons;
import org.exbin.xbup.core.catalog.base.XBCBlockListJoin;
import org.exbin.xbup.core.catalog.base.XBCConsDef;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCJoinDef;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;

@ParametersAreNonnullByDefault
public class CatalogDefsTableModel
extends AbstractTableModel {
    private XBACatalog catalog;
    private XBCSpec spec = null;
    private XBCItem catalogItem = null;
    private CatalogRevsTableModel revsModel = null;
    private final List<CatalogDefsTableItem> items = new ArrayList<CatalogDefsTableItem>();
    private final String[] columnNames = new String[]{"#", "Name", "Type", "Revision"};
    private final Class[] columnClasses = new Class[]{Long.class, String.class, String.class, Long.class};

    @Override
    public int getRowCount() {
        if (this.spec == null) {
            return 0;
        }
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnClasses.length;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.spec == null) {
            return null;
        }
        CatalogDefsTableItem item = this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item.getXbIndex();
            }
            case 1: {
                return item.getName();
            }
            case 2: {
                return item.getType();
            }
            case 3: {
                return item.getRevision();
            }
        }
        return "";
    }

    @Override
    @Nonnull
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    @Nonnull
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    @Nonnull
    public List<CatalogDefsTableItem> getDefs() {
        return this.items;
    }

    public void setCatalogItem(XBCItem item) {
        this.catalogItem = item;
        this.items.clear();
        if (item instanceof XBCSpec) {
            XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
            XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
            XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
            XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
            this.spec = (XBCSpec)item;
            List specDefs = specService.getSpecDefs(this.spec);
            for (XBCSpecDef specDef : specDefs) {
                CatalogDefsTableItem tableItem = new CatalogDefsTableItem();
                tableItem.setSpecDef(specDef);
                tableItem.setXbIndex(specDef.getXBIndex());
                tableItem.setOperation(this.getOperation(specDef));
                tableItem.setDefType(specDef.getType());
                tableItem.setType("");
                Optional targetRev = specDef.getTargetRev();
                if (targetRev.isPresent()) {
                    tableItem.setTarget((XBCRev)targetRev.get());
                    XBCSpec targetSpec = ((XBCRev)targetRev.get()).getParent();
                    XBCXName name = nameService.getDefaultItemName((XBCItem)targetSpec);
                    if (name != null) {
                        tableItem.setType(name.getText());
                    }
                }
                tableItem.setName(nameService.getDefaultText((XBCItem)specDef));
                tableItem.setDescription(descService.getDefaultText((XBCItem)specDef));
                tableItem.setStringId(striService.getItemStringIdText((XBCItem)specDef));
                this.items.add(tableItem);
            }
            this.updateDefRevisions();
        }
        this.fireTableDataChanged();
    }

    @Nonnull
    public String getOperation(XBCSpecDef specDef) {
        CatalogDefOperationType operation;
        if (specDef instanceof XBCBlockJoin) {
            operation = specDef.getTargetRev().isPresent() ? CatalogDefOperationType.JOIN : CatalogDefOperationType.ATTRIBUTE;
        } else if (specDef instanceof XBCBlockCons) {
            operation = specDef.getTargetRev().isPresent() ? CatalogDefOperationType.CONSIST : CatalogDefOperationType.ANY;
        } else if (specDef instanceof XBCBlockListJoin) {
            operation = specDef.getTargetRev().isPresent() ? CatalogDefOperationType.JOIN_LIST : CatalogDefOperationType.ATTRIBUTE_LIST;
        } else if (specDef instanceof XBCBlockListCons) {
            operation = specDef.getTargetRev().isPresent() ? CatalogDefOperationType.CONSIST_LIST : CatalogDefOperationType.ANY_LIST;
        } else if (specDef instanceof XBCJoinDef) {
            operation = CatalogDefOperationType.JOIN;
        } else if (specDef instanceof XBCConsDef) {
            operation = CatalogDefOperationType.CONSIST;
        } else {
            return "Unknown";
        }
        return operation.getCaption();
    }

    public CatalogDefsTableItem getRowItem(int rowIndex) {
        return this.items.get(rowIndex);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        if (this.catalogItem != null) {
            this.setCatalogItem(this.catalogItem);
        }
    }

    public void addDefs(CatalogDefsTableItem defItem) {
        this.items.add(defItem);
        defItem.setRevision(this.revsModel.getRevisionForIndex(defItem.getXbIndex()));
    }

    public void removeItem(XBCSpecDef specDef) {
        for (int i = 0; i < this.items.size(); ++i) {
            CatalogDefsTableItem item = this.items.get(i);
            if (item.getSpecDef() != specDef) continue;
            this.items.remove(item);
            break;
        }
    }

    public void moveItemDown(int itemPos) {
        CatalogDefsTableItem item = this.items.get(itemPos);
        CatalogDefsTableItem nextItem = this.items.get(itemPos + 1);
        Long prevIndex = item.getXbIndex();
        item.setXbIndex(nextItem.getXbIndex());
        nextItem.setXbIndex(prevIndex);
        if (this.revsModel != null) {
            item.setRevision(this.revsModel.getRevisionForIndex(item.getXbIndex()));
            nextItem.setRevision(this.revsModel.getRevisionForIndex(nextItem.getXbIndex()));
        }
        this.items.remove(item);
        this.items.add(itemPos + 1, item);
    }

    public void setRevsModel(CatalogRevsTableModel revsModel) {
        this.revsModel = revsModel;
        if (this.catalogItem != null) {
            this.setCatalogItem(this.catalogItem);
        }
    }

    public void updateDefRevisions() {
        for (CatalogDefsTableItem tableItem : this.items) {
            if (this.revsModel != null) {
                tableItem.setRevision(this.revsModel.getRevisionForIndex(tableItem.getXbIndex()));
                continue;
            }
            tableItem.setRevision(null);
        }
        this.fireTableDataChanged();
    }
}

