/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.IOException;
import java.util.Optional;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.client.stub.XBPXHDocStub;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXHDoc;
import org.exbin.xbup.core.catalog.base.service.XBCItemService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;

public class XBPXHDocSkeleton
implements XBPCatalogSkeleton {
    private XBAECatalog catalog;

    public XBPXHDocSkeleton(XBAECatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void registerProcedures(XBServiceServer remoteServer) {
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXHDocStub.OWNER_HDOC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXHDocService hdocService = (XBCXHDocService)XBPXHDocSkeleton.this.catalog.getCatalogService(XBCXHDocService.class);
                Optional hdoc = hdocService.getItem(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(hdoc.isPresent() ? new UBNat32(((XBCXHDoc)hdoc.get()).getItem().getId()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXHDocStub.ITEM_HDOC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCItemService itemService = (XBCItemService)XBPXHDocSkeleton.this.catalog.getCatalogService(XBCItemService.class);
                XBCXHDocService hdocService = (XBCXHDocService)XBPXHDocSkeleton.this.catalog.getCatalogService(XBCXHDocService.class);
                Optional item = itemService.getItem(index.getNaturalLong());
                XBCXHDoc hdoc = item.isPresent() ? hdocService.getDocumentation((XBCItem)item.get()) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(hdoc == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(hdoc.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXHDocStub.FILE_HDOC_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXHDocService hdocService = (XBCXHDocService)XBPXHDocSkeleton.this.catalog.getCatalogService(XBCXHDocService.class);
                Optional hdoc = hdocService.getItem(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(hdoc.isPresent() ? new UBNat32(((XBCXHDoc)hdoc.get()).getDocFile().getId()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
    }

    @Override
    public void setCatalog(XBAECatalog catalog) {
        this.catalog = catalog;
    }
}

