/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.client.stub.XBPNodeStub;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCRoot;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCRootService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;

public class XBPNodeSkeleton
implements XBPCatalogSkeleton {
    private XBAECatalog catalog;

    public XBPNodeSkeleton(XBAECatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void registerProcedures(XBServiceServer remoteServer) {
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.ROOT_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long rootId = provider.pullLongAttribute();
                provider.end();
                XBCRootService rootService = (XBCRootService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCRootService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                Optional root = rootService.getItem(rootId);
                listener.process((XBSerializable)(root.isPresent() ? new UBNat32(((XBCRoot)root.get()).getNode().getId()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.MAINROOT_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                XBCNode node = (XBCNode)nodeService.getMainRootNode().get();
                listener.process((XBSerializable)new UBNat32(node.getId()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.SUBNODE_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                long xbIndex = provider.pullLongAttribute();
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBCNode subNode = nodeService.getSubNode((XBCNode)node.get(), xbIndex);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(subNode == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(subNode.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.SUBNODES_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                List subNodes = nodeService.getSubNodes((XBCNode)node.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.matchType();
                listener.putAttribute(subNodes.size());
                for (XBCNode subNode : subNodes) {
                    listener.putAttribute(subNode.getId());
                }
                listener.end();
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.SUBNODESCOUNT_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(nodeService.getSubNodesCount((XBCNode)node.get())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.FINDOWNER_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long count = provider.pullLongAttribute();
                Long[] nodePath = new Long[(int)count];
                int i = 0;
                while ((long)i < count) {
                    nodePath[i] = provider.pullLongAttribute();
                    ++i;
                }
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                XBENode owner = nodeService.findOwnerByXBPath(nodePath).getParent().orElse(null);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(owner == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(owner.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.PATHNODE_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                Long[] nodePath = nodeService.getNodeXBPath((XBCNode)node.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.matchType();
                listener.putAttribute(nodePath.length);
                for (Long pathId : nodePath) {
                    listener.putAttribute(pathId.longValue());
                }
                listener.end();
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.FINDNODE_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long count = provider.pullLongAttribute();
                Long[] nodePath = new Long[(int)count];
                int i = 0;
                while ((long)i < count) {
                    nodePath[i] = provider.pullLongAttribute();
                    ++i;
                }
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                XBENode node = (XBENode)nodeService.findNodeByXBPath(nodePath);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(node == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(node.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.MAXSUBNODE_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(nodeService.findMaxSubNodeXB((XBCNode)node.get()).longValue()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.NODESCOUNT_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(nodeService.getItemsCount()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.SUBNODESEQ_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                long orderIndex = provider.pullLongAttribute();
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBENode subNode = node.isPresent() ? (XBENode)nodeService.getSubNodeSeq((XBCNode)node.get(), orderIndex) : null;
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(subNode == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(subNode.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPNodeStub.SUBNODESEQCNT_NODE_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long nodeId = provider.pullLongAttribute();
                provider.end();
                XBCNodeService nodeService = (XBCNodeService)XBPNodeSkeleton.this.catalog.getCatalogService(XBCNodeService.class);
                Optional node = nodeService.getItem(nodeId);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(nodeService.getSubNodesSeq((XBCNode)node.get())));
            }
        });
    }

    @Override
    public void setCatalog(XBAECatalog catalog) {
        this.catalog = catalog;
    }
}

