/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRRoot;
import org.exbin.xbup.client.stub.XBPBaseProcedureType;
import org.exbin.xbup.client.stub.XBPBaseStub;
import org.exbin.xbup.client.stub.XBPItemStub;
import org.exbin.xbup.client.stub.XBPStubUtils;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCRoot;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.type.XBDateTime;

@ParametersAreNonnullByDefault
public class XBPRootStub
extends XBPBaseStub<XBCRoot> {
    public static long[] ROOT_PROCEDURE = new long[]{0L, 2L, 4L, 29L, 0L};
    public static long[] CATALOG_ROOT_PROCEDURE = new long[]{0L, 2L, 4L, 30L, 0L};
    public static long[] LASTUPDATE_ROOT_PROCEDURE = new long[]{0L, 2L, 4L, 31L, 0L};
    public static long[] CATALOG_MAIN_EXPORT_PROCEDURE = new long[]{0L, 2L, 4L, 32L, 0L};
    private final XBCatalogServiceClient client;

    public XBPRootStub(XBCatalogServiceClient client) {
        super(client, XBRRoot::new, new XBPBaseProcedureType(null, null, null, null, null));
        this.client = client;
    }

    @Nonnull
    public Optional<Date> getRootLastUpdate(long rootId) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(LASTUPDATE_ROOT_PROCEDURE));
            serialInput.putAttribute(rootId);
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                XBDateTime dateTime = new XBDateTime();
                serialOutput.process((XBSerializable)dateTime);
                return Optional.of(dateTime.getValue());
            }
            procedureCall.execute();
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Optional.empty();
    }

    public XBCRoot getMainRoot() {
        Long index = XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(CATALOG_ROOT_PROCEDURE));
        return index == null ? null : new XBRRoot(this.client, index);
    }

    public XBCRoot getRoot(long rootId) {
        Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(ROOT_PROCEDURE), rootId);
        return index == null ? null : new XBRRoot(this.client, index);
    }

    @Nonnull
    public Optional<Date> getMainLastUpdate() {
        return this.getRootLastUpdate(this.getMainRoot().getId());
    }

    @Nonnull
    public InputStream getMainRootExport() {
        return XBPStubUtils.voidToDataMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(CATALOG_MAIN_EXPORT_PROCEDURE));
    }
}

