/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRItem;
import org.exbin.xbup.client.stub.XBPBaseProcedureType;
import org.exbin.xbup.client.stub.XBPBaseStub;
import org.exbin.xbup.client.stub.XBPStubUtils;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.type.XBString;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBPItemStub
extends XBPBaseStub<XBCItem> {
    public static long[] OWNER_ITEM_PROCEDURE = new long[]{0L, 2L, 3L, 0L, 0L};
    public static long[] XBINDEX_ITEM_PROCEDURE = new long[]{0L, 2L, 3L, 1L, 0L};
    public static long[] ITEMSCOUNT_ITEM_PROCEDURE = new long[]{0L, 2L, 3L, 2L, 0L};
    public static long[] FIND_ALL_PAGED_ITEM_PROCEDURE = new long[]{0L, 2L, 3L, 3L, 0L};
    private final XBCatalogServiceClient client;

    public XBPItemStub(XBCatalogServiceClient client) {
        super(client, XBRItem::new, new XBPBaseProcedureType(null, null, null, null, (XBBlockType)new XBDeclBlockType(ITEMSCOUNT_ITEM_PROCEDURE)));
        this.client = client;
    }

    @Nonnull
    public Optional<XBCItem> getParent(Long itemId) {
        Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(OWNER_ITEM_PROCEDURE), itemId);
        return index == null ? Optional.empty() : Optional.of(this.constructItem(index));
    }

    public Long getXBIndex(Long itemId) {
        return XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(XBINDEX_ITEM_PROCEDURE), itemId);
    }

    @Nullable
    public Integer findAllPagedCount(String filterCondition, String specType) {
        XBCallHandler procedureCall = this.client.procedureCall();
        try {
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(FIND_ALL_PAGED_ITEM_PROCEDURE));
            serialInput.putAppend((XBSerializable)new XBString(filterCondition));
            serialInput.putAppend((XBSerializable)new XBString(specType));
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                UBNat32 result = new UBNat32();
                serialOutput.process((XBSerializable)result);
                return result.getInt();
            }
            procedureCall.execute();
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}

