/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.client.XBCallException;
import org.exbin.xbup.client.XBCallLogListener;
import org.exbin.xbup.client.XBLoggingInputStream;
import org.exbin.xbup.client.XBLoggingOutputStream;
import org.exbin.xbup.client.stub.XBPServiceStub;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTEventTypeUndeclaringFilterNoDeclaration;
import org.exbin.xbup.core.parser.token.event.convert.XBTPrintEventFilter;
import org.exbin.xbup.core.parser.token.event.convert.XBTToXBEventConvertor;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBPullReader;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPrintPullFilter;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPullPreLoader;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPullTypeDeclaringFilterNoDeclaration;
import org.exbin.xbup.core.parser.token.pull.convert.XBToXBTPullConvertor;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.remote.XBServiceClient;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;

@ParametersAreNonnullByDefault
public class XBTCPServiceClient
implements XBServiceClient {
    public static final int DEFAULT_PORT = 22594;
    public static final int DEFAULT_DEV_PORT = 22595;
    public static final String MAIN_CATALOG_HOST = "catalog.exbin.org";
    public static final String MAIN_DEV_CATALOG_HOST = "catalog-dev.exbin.org";
    public static long[] XBSERVICE_FORMAT = new long[]{0L, 2L, 0L, 0L};
    public static long[] SERVICE_INVOCATION_SUCCESSFUL = new long[]{0L, 2L, 0L, 0L};
    public static long[] SERVICE_INVOCATION_FAILED = new long[]{0L, 2L, 1L, 0L};
    private XBCatalog catalog;
    private Socket socket = null;
    private XBInput currentInput = null;
    private XBOutput currentOutput = null;
    private boolean debugMode = false;
    private final String host;
    private final int port;
    private final XBPServiceStub serviceStub;
    private XBCallLogListener callLogListener = null;

    public XBTCPServiceClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.serviceStub = new XBPServiceStub(this);
    }

    @Nonnull
    public XBCallHandler procedureCall() throws XBCallException {
        try {
            InputStream loggingInputStream;
            if (this.socket == null) {
                this.socket = new Socket(this.getHost(), this.getPort());
                XBHead.writeXBUPHead((OutputStream)this.socket.getOutputStream());
            }
            final OutputStream loggingOutputStream = this.debugMode ? new XBLoggingOutputStream(this.socket.getOutputStream()) : this.socket.getOutputStream();
            InputStream inputStream = loggingInputStream = this.debugMode ? new XBLoggingInputStream(this.socket.getInputStream()) : this.socket.getInputStream();
            if (this.currentInput != null) {
                this.currentInput = null;
            }
            if (this.currentOutput != null) {
                this.currentOutput = null;
            }
            return new XBCallHandler(){

                public XBInput getParametersInput() throws XBProcessingException, IOException {
                    XBTCPServiceClient.this.currentInput = (XBInput)new XBTEventTypeUndeclaringFilterNoDeclaration(XBTCPServiceClient.this.catalog, (XBTEventListener)new XBTPrintEventFilter("O", (XBTEventListener)new XBTToXBEventConvertor((XBEventListener)new XBEventWriter(loggingOutputStream, XBParserMode.SINGLE_BLOCK))));
                    return XBTCPServiceClient.this.currentInput;
                }

                public XBOutput getResultOutput() throws XBProcessingException, IOException {
                    if (XBTCPServiceClient.this.currentInput != null) {
                        XBTCPServiceClient.this.currentInput = null;
                    }
                    XBTCPServiceClient.this.currentOutput = (XBOutput)new XBTPullPreLoader((XBTPullProvider)new XBTPullTypeDeclaringFilterNoDeclaration(XBTCPServiceClient.this.catalog, (XBTPullProvider)new XBTPrintPullFilter("I", (XBTPullProvider)new XBToXBTPullConvertor((XBPullProvider)new XBPullReader(loggingInputStream, XBParserMode.SINGLE_BLOCK)))));
                    XBTPullPreLoader output = (XBTPullPreLoader)XBTCPServiceClient.this.currentOutput;
                    XBTToken beginToken = output.pullXBTToken();
                    if (beginToken.getTokenType() != XBTTokenType.BEGIN) {
                        throw new XBProcessingException("Begin token was expected", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    XBTToken typeToken = output.pullXBTToken();
                    if (typeToken.getTokenType() != XBTTokenType.TYPE) {
                        throw new XBProcessingException("Type token was expected", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    return XBTCPServiceClient.this.currentOutput;
                }

                public void execute() throws XBProcessingException, IOException {
                    XBTToken endToken = ((XBTPullPreLoader)XBTCPServiceClient.this.currentOutput).pullXBTToken();
                    if (endToken.getTokenType() != XBTTokenType.END) {
                        throw new XBProcessingException("End token was expected", XBProcessingExceptionType.UNEXPECTED_ORDER);
                    }
                    if (XBTCPServiceClient.this.debugMode && XBTCPServiceClient.this.callLogListener != null) {
                        XBTCPServiceClient.this.callLogListener.callPerformed((BinaryData)((XBLoggingInputStream)loggingInputStream).getData(), (BinaryData)((XBLoggingOutputStream)loggingOutputStream).getData());
                    }
                }
            };
        }
        catch (IOException | XBProcessingException ex) {
            throw new XBCallException("Procedure call failed", ex);
        }
    }

    public int login(String user, char[] password) {
        return this.serviceStub.login(user, password);
    }

    public String getVersion() {
        return this.serviceStub.getVersion();
    }

    public void stop() {
        this.serviceStub.stop();
    }

    public void close() {
        try {
            this.getSocket().close();
        }
        catch (IOException ex) {
            Logger.getLogger(XBTCPServiceClient.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean ping() {
        return this.serviceStub.ping();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public XBCatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBCatalog catalog) {
        this.catalog = catalog;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getLocalAddress() {
        return this.getSocket().getLocalAddress().getHostAddress();
    }

    public String getHostAddress() {
        return this.getSocket().getInetAddress().getHostAddress();
    }

    public XBCallLogListener getCallLogListener() {
        return this.callLogListener;
    }

    public void setCallLogListener(XBCallLogListener callLogListener) {
        this.callLogListener = callLogListener;
    }

    public boolean validate() {
        try {
            Socket callSocket = new Socket(this.getHost(), this.getPort());
            callSocket.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public Socket getSocket() {
        return this.socket;
    }
}

