/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.exbin.xbup.core.type.XBData;

public class XBLoggingOutputStream
extends OutputStream {
    @Nonnull
    private final XBData data = new XBData();
    @Nonnull
    private final OutputStream targetOutputStream;

    public XBLoggingOutputStream(@Nonnull OutputStream targetOutputStream) {
        this.targetOutputStream = targetOutputStream;
    }

    @Override
    public void write(int bufferData) throws IOException {
        this.targetOutputStream.write(bufferData);
        long dataSize = this.data.getDataSize();
        this.data.insert(dataSize, 1L);
        this.data.setByte(dataSize, (byte)bufferData);
    }

    @Override
    public void write(@Nonnull byte[] bufferData, int offset, int length) throws IOException {
        this.targetOutputStream.write(bufferData, offset, length);
        this.data.insert(this.data.getDataSize(), bufferData, offset, length);
    }

    @Override
    public void write(@Nonnull byte[] bufferData) throws IOException {
        this.targetOutputStream.write(bufferData);
        this.data.insert(this.data.getDataSize(), bufferData);
    }

    @Nonnull
    public XBData getData() {
        return this.data;
    }
}

