/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.visual.picture;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.serial.param.XBPInputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPOutputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSerializable;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.visual.picture.XBWritableRaster;

public class XBBufferedImage
implements XBPSerializable {
    private BufferedImage image;
    public static long[] XBUP_BLOCKREV_CATALOGPATH = new long[]{1L, 4L, 0L, 0L, 2L, 0L};
    public static long[] XBUP_FORMATREV_CATALOGPATH = new long[]{1L, 4L, 0L, 1L, 0L};

    public XBBufferedImage() {
        this.image = null;
    }

    public XBBufferedImage(BufferedImage image) {
        this.image = image;
    }

    public XBBufferedImage(int width, int height, int imageType, IndexColorModel cm) {
        this.image = new BufferedImage(width, height, imageType, cm);
    }

    public XBBufferedImage(int width, int height, int imageType) {
        this.image = new BufferedImage(width, height, imageType);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void serializeFromXB(XBPInputSerialHandler serial) throws XBProcessingException, IOException {
        serial.pullBegin();
        serial.matchType((XBBlockType)new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        UBNatural width = serial.pullAttribute().convertToNatural();
        UBNatural height = serial.pullAttribute().convertToNatural();
        BufferedImage result = new BufferedImage(width.getInt(), height.getInt(), 1);
        serial.pullConsist(XBWritableRaster.getXBWritableRasterSerializator(result.getRaster()));
        this.setImage(result);
        serial.pullEnd();
    }

    public void serializeToXB(XBPOutputSerialHandler serial) throws XBProcessingException, IOException {
        serial.putBegin(XBBlockTerminationMode.SIZE_SPECIFIED);
        serial.putType((XBBlockType)new XBDeclBlockType(XBUP_BLOCKREV_CATALOGPATH));
        WritableRaster raster = this.image.getRaster();
        serial.putAttribute((XBAttribute)new UBNat32(raster.getWidth()));
        serial.putAttribute((XBAttribute)new UBNat32(raster.getHeight()));
        serial.putConsist(XBWritableRaster.getXBWritableRasterSerializator(raster));
        serial.putEnd();
    }
}

