/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.MultiEditorUndoHandler;
import org.exbin.framework.editor.action.CloseAllFileAction;
import org.exbin.framework.editor.action.CloseFileAction;
import org.exbin.framework.editor.action.CloseOtherFileAction;
import org.exbin.framework.editor.action.EditorActions;
import org.exbin.framework.editor.api.EditorModuleApi;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.api.MultiEditorPopupMenu;
import org.exbin.framework.editor.api.MultiEditorProvider;
import org.exbin.framework.editor.gui.MultiEditorPanel;
import org.exbin.framework.editor.xbup.gui.BlockPropertiesPanel;
import org.exbin.framework.editor.xbup.viewer.DocumentItemSelectionListener;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.framework.file.api.AllFileTypes;
import org.exbin.framework.file.api.FileActionsApi;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.file.api.FileTypes;
import org.exbin.framework.file.api.UsedDirectoryApi;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.CloseControlPanel;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.operation.undo.XBUndoUpdateListener;
import org.exbin.xbup.parser_tree.XBTTreeDocument;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class XbupMultiEditorProvider
implements XbupEditorProvider,
MultiEditorProvider,
ClipboardActionsHandler {
    private final XBApplication application;
    private FileTypes fileTypes;
    private final MultiEditorPanel multiEditorPanel = new MultiEditorPanel();
    private XBACatalog catalog;
    private PropertyChangeListener propertyChangeListener = null;
    private int lastIndex = 0;
    private int lastNewFileIndex = 0;
    private final Map<Integer, Integer> newFilesMap = new HashMap<Integer, Integer>();
    private MultiEditorUndoHandler undoHandler = new MultiEditorUndoHandler();
    private ClipboardActionsHandler activeHandler;
    private XBPluginRepository pluginRepository;
    private final List<MultiEditorProvider.ActiveFileChangeListener> activeFileChangeListeners = new ArrayList<MultiEditorProvider.ActiveFileChangeListener>();
    private final List<DocumentItemSelectionListener> itemSelectionListeners = new ArrayList<DocumentItemSelectionListener>();
    private ClipboardActionsUpdateListener clipboardActionsUpdateListener;
    @Nullable
    private XbupFileHandler activeFile = null;
    private boolean devMode = false;
    @Nullable
    private File lastUsedDirectory;

    public XbupMultiEditorProvider(XBApplication application) {
        this.application = application;
        this.init();
    }

    private void init() {
        this.multiEditorPanel.setController(new MultiEditorPanel.Controller(){

            public void activeIndexChanged(int index) {
                XbupMultiEditorProvider.this.activeFileChanged();
            }

            public void showPopupMenu(int index, Component component, int positionX, int positionY) {
                if (index < 0) {
                    return;
                }
                FileHandler fileHandler = XbupMultiEditorProvider.this.multiEditorPanel.getFileHandler(index);
                EditorModuleApi editorModule = (EditorModuleApi)XbupMultiEditorProvider.this.application.getModuleRepository().getModuleByInterface(EditorModuleApi.class);
                EditorPopupMenu fileTabPopupMenu = new EditorPopupMenu(fileHandler);
                CloseFileAction closeFileAction = (CloseFileAction)editorModule.getCloseFileAction();
                JMenuItem closeMenuItem = new JMenuItem((Action)closeFileAction);
                fileTabPopupMenu.add(closeMenuItem);
                CloseAllFileAction closeAllFileAction = (CloseAllFileAction)editorModule.getCloseAllFileAction();
                JMenuItem closeAllMenuItem = new JMenuItem((Action)closeAllFileAction);
                fileTabPopupMenu.add(closeAllMenuItem);
                CloseOtherFileAction closeOtherFileAction = (CloseOtherFileAction)editorModule.getCloseOtherFileAction();
                JMenuItem closeOtherMenuItem = new JMenuItem((Action)closeOtherFileAction);
                fileTabPopupMenu.add(closeOtherMenuItem);
                fileTabPopupMenu.show(component, positionX, positionY);
            }
        });
        this.fileTypes = new AllFileTypes();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.addFlavorListener(e -> {});
    }

    @Nonnull
    public JComponent getEditorComponent() {
        return this.multiEditorPanel;
    }

    @Nonnull
    public Optional<FileHandler> getActiveFile() {
        return Optional.ofNullable(this.activeFile);
    }

    @Nonnull
    public Optional<File> getLastUsedDirectory() {
        return Optional.ofNullable(this.lastUsedDirectory);
    }

    public void setLastUsedDirectory(@Nullable File directory) {
        this.lastUsedDirectory = directory;
    }

    public void updateRecentFilesList(URI fileUri, FileType fileType) {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.updateRecentFilesList(fileUri, fileType);
    }

    public XBUndoHandler getUndoHandler() {
        return this.undoHandler;
    }

    private void activeFileChanged() {
        Optional optActiveFile = this.multiEditorPanel.getActiveFile();
        this.activeFile = optActiveFile.orElse(null);
        this.undoHandler.setActiveFile((FileHandler)this.activeFile);
        this.notifyActiveFileChanged(this.activeFile);
        if (this.clipboardActionsUpdateListener != null) {
            // empty if block
        }
    }

    public void setModificationListener(EditorProvider.EditorModificationListener editorModificationListener) {
    }

    @Override
    @Nonnull
    public XBACatalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        if (this.activeFile != null) {
            this.activeFile.setCatalog(catalog);
        }
    }

    @Override
    @Nonnull
    public XBApplication getApplication() {
        return this.application;
    }

    @Override
    @Nonnull
    public XBPluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    @Override
    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
        for (int i = 0; i < this.multiEditorPanel.getFileHandlersCount(); ++i) {
            XbupFileHandler fileHandler = (XbupFileHandler)this.multiEditorPanel.getFileHandler(i);
            fileHandler.setPluginRepository(pluginRepository);
        }
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
    }

    @Nonnull
    public String getWindowTitle(String frameTitle) {
        XBTTreeDocument treeDocument = this.activeFile.getDocument();
        String title = treeDocument.getFileName();
        if (!"".equals(title)) {
            int pos;
            int newpos = 0;
            while ((newpos = title.indexOf(File.separatorChar, pos = newpos) + 1) > 0) {
            }
            return title.substring(pos) + " - " + frameTitle;
        }
        return frameTitle;
    }

    public void performCut() {
        this.activeHandler.performCut();
    }

    public void performCopy() {
        this.activeHandler.performCopy();
    }

    public void performPaste() {
        this.activeHandler.performPaste();
    }

    public void performDelete() {
        this.activeHandler.performDelete();
    }

    public void performSelectAll() {
        this.activeHandler.performSelectAll();
    }

    public boolean isSelection() {
        return this.activeHandler.isSelection();
    }

    public boolean isEditable() {
        return this.activeHandler.isEditable();
    }

    public boolean canSelectAll() {
        return this.activeHandler.canSelectAll();
    }

    public boolean canPaste() {
        return this.activeHandler.canPaste();
    }

    public boolean canDelete() {
        return this.activeHandler.canDelete();
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
        this.clipboardActionsUpdateListener = updateListener;
    }

    public void actionItemProperties() {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        BlockPropertiesPanel panel = new BlockPropertiesPanel();
        panel.setApplication(this.application);
        panel.setCatalog(this.catalog);
        if (this.activeFile != null) {
            panel.setBlock(this.activeFile.getSelectedItem().orElse(null));
        }
        CloseControlPanel controlPanel = new CloseControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
        controlPanel.setHandler(() -> {
            dialog.close();
            dialog.dispose();
        });
        dialog.showCentered(null);
    }

    @Override
    public void addItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.add(listener);
    }

    @Override
    public void removeItemSelectionListener(DocumentItemSelectionListener listener) {
        this.itemSelectionListeners.remove(listener);
    }

    private void notifyItemSelectionChanged(@Nullable XBTBlock item) {
        this.itemSelectionListeners.forEach(listener -> listener.itemSelected(item));
    }

    public void newFile() {
        int fileIndex = ++this.lastIndex;
        this.newFilesMap.put(fileIndex, ++this.lastNewFileIndex);
        XbupFileHandler newFile = this.createFileHandler(fileIndex);
        newFile.clearFile();
        this.multiEditorPanel.addFileHandler((FileHandler)newFile, this.getName(newFile));
    }

    public void openFile(URI fileUri, FileType fileType) {
        XbupFileHandler file = this.createFileHandler(++this.lastIndex);
        file.loadFromFile(fileUri, fileType);
        this.multiEditorPanel.addFileHandler((FileHandler)file, file.getTitle());
    }

    @Nonnull
    private XbupFileHandler createFileHandler(int id) {
        XbupFileHandler fileHandler = new XbupFileHandler(id);
        fileHandler.setApplication(this.application);
        fileHandler.addItemSelectionListener(block -> {
            if (this.activeFile == fileHandler) {
                this.notifyItemSelectionChanged(block);
            }
        });
        fileHandler.setCatalog(this.catalog);
        fileHandler.setPluginRepository(this.pluginRepository);
        fileHandler.getUndoHandler().addUndoUpdateListener(new XBUndoUpdateListener(){

            public void undoCommandPositionChanged() {
                XbupMultiEditorProvider.this.undoHandler.notifyUndoUpdate();
            }

            public void undoCommandAdded(Command cmnd) {
                XbupMultiEditorProvider.this.undoHandler.notifyUndoCommandAdded(cmnd);
            }
        });
        return fileHandler;
    }

    public void openFile() {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        FileActionsApi fileActions = fileModule.getFileActions();
        FileActionsApi.OpenFileResult openFileResult = fileActions.showOpenFileDialog(this.fileTypes, (UsedDirectoryApi)this);
        if (openFileResult.dialogResult == 0) {
            this.openFile(((File)CodeAreaUtils.requireNonNull((Object)openFileResult.selectedFile)).toURI(), openFileResult.fileType);
        }
    }

    public void loadFromFile(String fileName) throws URISyntaxException {
        URI fileUri = new URI(fileName);
        this.openFile(fileUri, null);
    }

    public void loadFromFile(URI fileUri, FileType fileType) {
        this.openFile(fileUri, fileType);
    }

    public boolean canSave() {
        if (this.activeFile == null) {
            return false;
        }
        return this.activeFile.isSaveSupported() && this.activeFile.isEditable();
    }

    public void saveFile() {
        if (this.activeFile == null) {
            throw new IllegalStateException();
        }
        this.saveFile(this.activeFile);
    }

    public void saveFile(FileHandler fileHandler) {
        if (this.activeFile == fileHandler) {
            fileHandler.saveToFile((URI)fileHandler.getFileUri().get(), (FileType)fileHandler.getFileType().orElse(null));
        } else {
            FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
            fileModule.getFileActions().saveFile(fileHandler, this.fileTypes, (UsedDirectoryApi)this);
        }
    }

    public void saveAsFile() {
        if (this.activeFile == null) {
            throw new IllegalStateException();
        }
        this.saveAsFile(this.activeFile);
    }

    public void saveAsFile(FileHandler fileHandler) {
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        fileModule.getFileActions().saveAsFile(fileHandler, this.fileTypes, (UsedDirectoryApi)this);
    }

    public boolean releaseFile(FileHandler fileHandler) {
        if (fileHandler.isModified()) {
            FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
            return fileModule.getFileActions().showAskForSaveDialog(fileHandler, null, (UsedDirectoryApi)this);
        }
        return true;
    }

    public boolean releaseAllFiles() {
        return this.releaseOtherFiles(null);
    }

    private boolean releaseOtherFiles(@Nullable FileHandler excludedFile) {
        int fileHandlersCount = this.multiEditorPanel.getFileHandlersCount();
        if (fileHandlersCount == 0) {
            return true;
        }
        if (fileHandlersCount == 1) {
            FileHandler activeFile = this.getActiveFile().get();
            return activeFile == excludedFile || this.releaseFile(activeFile);
        }
        ArrayList<FileHandler> modifiedFiles = new ArrayList<FileHandler>();
        for (int i = 0; i < fileHandlersCount; ++i) {
            FileHandler fileHandler = this.multiEditorPanel.getFileHandler(i);
            if (!fileHandler.isModified() || fileHandler == excludedFile) continue;
            modifiedFiles.add(fileHandler);
        }
        if (modifiedFiles.isEmpty()) {
            return true;
        }
        EditorModuleApi editorModule = (EditorModuleApi)this.application.getModuleRepository().getModuleByInterface(EditorModuleApi.class);
        EditorActions editorActions = (EditorActions)editorModule.getEditorActions();
        return editorActions.showAskForSaveDialog(modifiedFiles);
    }

    @Nonnull
    public List<FileHandler> getFileHandlers() {
        ArrayList<FileHandler> fileHandlers = new ArrayList<FileHandler>();
        for (int i = 0; i < this.multiEditorPanel.getFileHandlersCount(); ++i) {
            fileHandlers.add(this.multiEditorPanel.getFileHandler(i));
        }
        return fileHandlers;
    }

    @Nonnull
    public String getName(FileHandler fileHandler) {
        String name = fileHandler.getTitle();
        if (!name.isEmpty()) {
            return name;
        }
        return "New File " + this.newFilesMap.get(fileHandler.getId());
    }

    public void closeFile() {
        if (this.activeFile == null) {
            throw new IllegalStateException();
        }
        this.closeFile(this.activeFile);
    }

    public void closeFile(FileHandler file) {
        if (this.releaseFile(file)) {
            this.multiEditorPanel.removeFileHandler(file);
            this.newFilesMap.remove(file.getId());
        }
    }

    public void closeOtherFiles(FileHandler exceptHandler) {
        if (this.releaseOtherFiles(exceptHandler)) {
            this.multiEditorPanel.removeAllFileHandlersExceptFile(exceptHandler);
            int exceptionFileId = exceptHandler.getId();
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(exceptionFileId);
            this.newFilesMap.keySet().retainAll(list);
        }
    }

    public void closeAllFiles() {
        if (this.releaseAllFiles()) {
            this.multiEditorPanel.removeAllFileHandlers();
            this.newFilesMap.clear();
        }
    }

    public void saveAllFiles() {
        int fileHandlersCount = this.multiEditorPanel.getFileHandlersCount();
        if (fileHandlersCount == 0) {
            return;
        }
        ArrayList<FileHandler> modifiedFiles = new ArrayList<FileHandler>();
        for (int i = 0; i < fileHandlersCount; ++i) {
            FileHandler fileHandler = this.multiEditorPanel.getFileHandler(i);
            if (!fileHandler.isModified()) continue;
            modifiedFiles.add(fileHandler);
        }
        if (modifiedFiles.isEmpty()) {
            return;
        }
        EditorModuleApi editorModule = (EditorModuleApi)this.application.getModuleRepository().getModuleByInterface(EditorModuleApi.class);
        EditorActions editorActions = (EditorActions)editorModule.getEditorActions();
        editorActions.showAskForSaveDialog(modifiedFiles);
    }

    public void addActiveFileChangeListener(MultiEditorProvider.ActiveFileChangeListener listener) {
        this.activeFileChangeListeners.add(listener);
    }

    public void removeActiveFileChangeListener(MultiEditorProvider.ActiveFileChangeListener listener) {
        this.activeFileChangeListeners.remove(listener);
    }

    private void notifyActiveFileChanged(@Nullable FileHandler fileHandler) {
        for (MultiEditorProvider.ActiveFileChangeListener listener : this.activeFileChangeListeners) {
            listener.activeFileChanged(fileHandler);
        }
        if (fileHandler == null) {
            this.notifyItemSelectionChanged(null);
        } else {
            this.notifyItemSelectionChanged(((XbupFileHandler)fileHandler).getSelectedItem().orElse(null));
        }
    }

    private class EditorPopupMenu
    extends JPopupMenu
    implements MultiEditorPopupMenu {
        @Nullable
        private final FileHandler selectedFile;

        public EditorPopupMenu(FileHandler selectedFile) {
            this.selectedFile = selectedFile;
        }

        @Nonnull
        public Optional<FileHandler> getSelectedFile() {
            return Optional.ofNullable(this.selectedFile);
        }
    }
}

