/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.bined.EditOperation;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.bined.BinaryStatusApi;
import org.exbin.framework.bined.BinedModule;
import org.exbin.framework.bined.action.ClipboardCodeActions;
import org.exbin.framework.bined.action.GoToPositionAction;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.gui.BinaryStatusPanel;
import org.exbin.framework.bined.handler.CodeAreaPopupMenuHandler;
import org.exbin.framework.editor.text.EncodingsHandler;
import org.exbin.framework.editor.xbup.gui.BinaryToolbarPanel;
import org.exbin.framework.editor.xbup.gui.SimpleMessagePanel;
import org.exbin.framework.editor.xbup.viewer.BlockViewer;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class BinaryViewer
implements BlockViewer,
ClipboardActionsHandler {
    private final JPanel wrapperPanel = new JPanel(new BorderLayout());
    private final SimpleMessagePanel messagePanel = new SimpleMessagePanel();
    private final BinEdComponentPanel binaryPanel = new BinEdComponentPanel();
    private final BinaryToolbarPanel binaryToolbarPanel = new BinaryToolbarPanel();
    private final BinaryStatusPanel binaryStatusPanel = new BinaryStatusPanel();
    private XBTBlock block = null;
    private GoToPositionAction goToPositionAction;
    private EncodingsHandler encodingsHandler;
    private ClipboardCodeActions clipboardCodeActions;

    public BinaryViewer() {
        this.init();
    }

    private void init() {
        this.wrapperPanel.add((Component)this.messagePanel, "Center");
        this.binaryToolbarPanel.setCodeArea(this.binaryPanel.getCodeArea());
        this.binaryPanel.add((Component)this.binaryToolbarPanel, (Object)"North");
        this.binaryStatusPanel.setStatusControlHandler(new BinaryStatusPanel.StatusControlHandler(){

            public void changeEditOperation(EditOperation operation) {
                BinaryViewer.this.binaryPanel.getCodeArea().setEditOperation(operation);
            }

            public void changeCursorPosition() {
                if (BinaryViewer.this.goToPositionAction != null) {
                    BinaryViewer.this.goToPositionAction.actionPerformed(null);
                }
            }

            public void cycleEncodings() {
                if (BinaryViewer.this.encodingsHandler != null) {
                    BinaryViewer.this.encodingsHandler.cycleEncodings();
                }
            }

            public void encodingsPopupEncodingsMenu(MouseEvent mouseEvent) {
                if (BinaryViewer.this.encodingsHandler != null) {
                    BinaryViewer.this.encodingsHandler.popupEncodingsMenu(mouseEvent);
                }
            }

            public void changeMemoryMode(BinaryStatusApi.MemoryMode memoryMode) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        ExtCodeArea codeArea = this.binaryPanel.getCodeArea();
        codeArea.addSelectionChangedListener(() -> this.binaryStatusPanel.setSelectionRange(codeArea.getSelection()));
        codeArea.addCaretMovedListener(caretPosition -> this.binaryStatusPanel.setCursorPosition(caretPosition));
        codeArea.addEditModeChangedListener((mode, operation) -> this.binaryStatusPanel.setEditMode(mode, operation));
        this.binaryPanel.add((Component)this.binaryStatusPanel, (Object)"South");
        this.binaryPanel.revalidate();
        this.binaryPanel.repaint();
    }

    @Override
    public void setApplication(XBApplication application) {
        final BinedModule binedModule = (BinedModule)application.getModuleRepository().getModuleByInterface(BinedModule.class);
        final CodeAreaPopupMenuHandler codeAreaPopupMenuHandler = binedModule.createCodeAreaPopupMenuHandler(BinedModule.PopupMenuVariant.NORMAL);
        JPopupMenu popupMenu = new JPopupMenu(){

            @Override
            public void show(Component invoker, int x, int y) {
                int clickedX = x;
                int clickedY = y;
                if (invoker instanceof JViewport) {
                    clickedX += ((JViewport)invoker).getParent().getX();
                    clickedY += ((JViewport)invoker).getParent().getY();
                }
                ExtCodeArea codeArea = BinaryViewer.this.binaryPanel.getCodeArea();
                JPopupMenu popupMenu = codeAreaPopupMenuHandler.createPopupMenu(codeArea, BinedModule.BINARY_POPUP_MENU_ID + ".BinaryViewer", clickedX, clickedY);
                popupMenu.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        codeAreaPopupMenuHandler.dropPopupMenu(BinedModule.BINARY_POPUP_MENU_ID + ".BinaryViewer");
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                });
                binedModule.updateActionStatus((CodeAreaCore)codeArea);
                BinaryViewer.this.clipboardCodeActions.updateForActiveCodeArea((CodeAreaCore)codeArea);
                popupMenu.show(invoker, x, y);
            }
        };
        this.binaryPanel.setPopupMenu(popupMenu);
        binedModule.getFileManager().initComponentPanel(this.binaryPanel);
        this.goToPositionAction = binedModule.getGoToPositionAction();
        this.goToPositionAction.updateForActiveCodeArea((CodeAreaCore)this.binaryPanel.getCodeArea());
        this.clipboardCodeActions = binedModule.getClipboardCodeActions();
        this.binaryToolbarPanel.setGoToPositionAction((ActionListener)this.goToPositionAction);
        this.encodingsHandler = binedModule.getEncodingsHandler();
    }

    @Override
    public void setCatalog(XBACatalog catalog) {
    }

    @Override
    public void setPluginRepository(XBPluginRepository pluginRepository) {
    }

    @Override
    public void setBlock(@Nullable XBTBlock block) {
        if (this.block != block) {
            if (block != null) {
                ByteArrayEditableData byteArrayData = new ByteArrayEditableData();
                try (OutputStream dataOutputStream = byteArrayData.getDataOutputStream();){
                    ((XBTTreeNode)block).toStreamUB(dataOutputStream);
                }
                catch (IOException ex) {
                    Logger.getLogger(BinaryViewer.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.binaryPanel.setContentData((BinaryData)byteArrayData);
            }
            if (block == null && this.block != null) {
                this.wrapperPanel.remove((Component)this.binaryPanel);
                this.wrapperPanel.add((Component)this.messagePanel, "Center");
                this.wrapperPanel.revalidate();
                this.wrapperPanel.repaint();
            } else if (block != null && this.block == null) {
                this.wrapperPanel.remove(this.messagePanel);
                this.wrapperPanel.add((Component)this.binaryPanel, "Center");
                this.wrapperPanel.revalidate();
                this.wrapperPanel.repaint();
            }
            this.block = block;
        }
    }

    @Override
    @Nonnull
    public String getName() {
        return "Binary";
    }

    @Override
    @Nonnull
    public Optional<ImageIcon> getIcon() {
        return Optional.of(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/binary-16x16.png")));
    }

    @Override
    @Nonnull
    public JComponent getComponent() {
        return this.wrapperPanel;
    }

    public void performCut() {
        this.binaryPanel.getCodeArea().cut();
    }

    public void performCopy() {
        this.binaryPanel.getCodeArea().copy();
    }

    public void performPaste() {
        this.binaryPanel.getCodeArea().paste();
    }

    public void performDelete() {
        this.binaryPanel.getCodeArea().delete();
    }

    public void performSelectAll() {
        this.binaryPanel.getCodeArea().selectAll();
    }

    public boolean isSelection() {
        return this.binaryPanel.getCodeArea().hasSelection();
    }

    public boolean isEditable() {
        return this.binaryPanel.getCodeArea().isEditable();
    }

    public boolean canSelectAll() {
        return true;
    }

    public boolean canPaste() {
        return this.binaryPanel.getCodeArea().canPaste();
    }

    public boolean canDelete() {
        return this.isEditable();
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
    }
}

