/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.preferences;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.editor.xbup.options.ServiceConnectionOptions;

@ParametersAreNonnullByDefault
public class ServiceConnectionPreferences
implements ServiceConnectionOptions {
    public static final String PREFERENCES_SERVICE_CONNECTION_ALLOWED = "serviceConnectionAllowed";
    public static final String PREFERENCES_SERVICE_CONNECTION_URL = "serviceConnectionURL";
    public static final String PREFERENCES_CATALOG_UPDATE_ALLOWED = "catalogUpdateAllowed";
    public static final String PREFERENCES_CATALOG_UPDATE_URL = "catalogUpdateURL";
    private final Preferences preferences;

    public ServiceConnectionPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public boolean isServiceConnectionAllowed() {
        return this.preferences.getBoolean(PREFERENCES_SERVICE_CONNECTION_ALLOWED, true);
    }

    @Override
    public void setServiceConnectionAllowed(boolean allowed) {
        this.preferences.putBoolean(PREFERENCES_SERVICE_CONNECTION_ALLOWED, allowed);
    }

    @Override
    @Nonnull
    public Optional<String> getServiceConnectionUrl() {
        return this.preferences.get(PREFERENCES_SERVICE_CONNECTION_URL);
    }

    @Override
    public void setServiceConnectionUrl(String connectionUrl) {
        this.preferences.put(PREFERENCES_SERVICE_CONNECTION_URL, connectionUrl);
    }

    @Override
    public boolean isCatalogUpdateAllowed() {
        return this.preferences.getBoolean(PREFERENCES_CATALOG_UPDATE_ALLOWED, true);
    }

    @Override
    public void setCatalogUpdateAllowed(boolean allowed) {
        this.preferences.putBoolean(PREFERENCES_CATALOG_UPDATE_ALLOWED, allowed);
    }

    @Override
    @Nonnull
    public Optional<String> getCatalogUpdateUrl() {
        return this.preferences.get(PREFERENCES_CATALOG_UPDATE_URL);
    }

    @Override
    public void setCatalogUpdateUrl(String updateUrl) {
        this.preferences.put(PREFERENCES_CATALOG_UPDATE_URL, updateUrl);
    }
}

