/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableCellPanel;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableItem;
import org.exbin.framework.editor.xbup.gui.XBPropertyTableModel;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.parser_tree.XBTTreeDocument;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class XBPropertyTableCellRenderer
implements TableCellRenderer {
    private XBACatalog catalog;
    private XBPluginRepository pluginRepository;
    private XBTTreeNode node;
    private final XBTTreeDocument doc;

    public XBPropertyTableCellRenderer(XBTTreeNode node, XBTTreeDocument doc) {
        this.node = node;
        this.doc = doc;
    }

    @Override
    @Nonnull
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        XBPropertyTableItem tableItem = ((XBPropertyTableModel)table.getModel()).getRow(row);
        JComponent component = tableItem.getRowEditor() == null ? null : tableItem.getRowEditor().getViewer();
        XBPropertyTableCellPanel cellPanel = component == null ? new XBPropertyTableCellPanel(this.catalog, this.pluginRepository, this.node, row) : new XBPropertyTableCellPanel(component, this.catalog, this.pluginRepository, this.node, row);
        cellPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        cellPanel.getCellComponent().setBorder(null);
        return cellPanel;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public void setBlock(XBTBlock block) {
        this.node = (XBTTreeNode)block;
    }
}

