/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import org.exbin.framework.editor.xbup.gui.XBDocTreePanel;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class XBDocTreeTransferHandler
extends TransferHandler {
    public static final DataFlavor XB_DATA_FLAVOR = new DataFlavor("others/x-xbup", "XBUP Document");
    private final XBDocTreePanel docTreePanel;
    private XBTTreeNode sourceNode;

    public XBDocTreeTransferHandler(XBDocTreePanel docTreePanel) {
        this.docTreePanel = docTreePanel;
        this.sourceNode = null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    @Nullable
    public Transferable createTransferable(JComponent c) {
        if (c instanceof JTree) {
            this.sourceNode = this.docTreePanel.getSelectedItem();
            return new XBTSelection(this.sourceNode);
        }
        return null;
    }

    @Override
    public void exportDone(JComponent c, Transferable t, int action) {
        if (action == 2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (action == 1) {
            // empty if block
        }
        this.sourceNode = null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport supp) {
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport supp) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public static class XBTSelection
    implements Transferable,
    ClipboardOwner {
        private ByteArrayOutputStream data;

        public XBTSelection(XBTTreeNode node) {
            if (node != null) {
                this.data = new ByteArrayOutputStream();
                try {
                    node.toStreamUB((OutputStream)this.data);
                }
                catch (IOException ex) {
                    Logger.getLogger(XBDocTreeTransferHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        @Override
        @Nonnull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] result = new DataFlavor[]{XB_DATA_FLAVOR};
            return result;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(XB_DATA_FLAVOR);
        }

        @Override
        @Nullable
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(XB_DATA_FLAVOR)) {
                return this.data;
            }
            return null;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

