/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import org.exbin.framework.client.api.ConnectionStatus;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class XBDocStatusPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(XBDocStatusPanel.class);
    private JPanel activityPanel;
    private JProgressBar activityProgressBar;
    private JLabel connectionStatusLabel;
    private JPanel connectionStatusPanel;
    private JPanel defaultPanel;
    private JPanel mainPanel;
    private JPanel operationPanel;
    private JProgressBar operationProgressBar;
    private JButton operationStopButton;

    public XBDocStatusPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.connectionStatusPanel = new JPanel();
        this.connectionStatusLabel = new JLabel();
        this.mainPanel = new JPanel();
        this.defaultPanel = new JPanel();
        this.operationPanel = new JPanel();
        this.operationProgressBar = new JProgressBar();
        this.operationStopButton = new JButton();
        this.activityPanel = new JPanel();
        this.activityProgressBar = new JProgressBar();
        this.setLayout(new BorderLayout());
        this.connectionStatusLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/images/status/network-offline.png")));
        GroupLayout connectionStatusPanelLayout = new GroupLayout(this.connectionStatusPanel);
        this.connectionStatusPanel.setLayout(connectionStatusPanelLayout);
        connectionStatusPanelLayout.setHorizontalGroup(connectionStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectionStatusLabel));
        connectionStatusPanelLayout.setVerticalGroup(connectionStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectionStatusLabel, -1, 27, Short.MAX_VALUE));
        this.add((Component)this.connectionStatusPanel, "East");
        this.mainPanel.setLayout(new CardLayout());
        GroupLayout defaultPanelLayout = new GroupLayout(this.defaultPanel);
        this.defaultPanel.setLayout(defaultPanelLayout);
        defaultPanelLayout.setHorizontalGroup(defaultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 401, Short.MAX_VALUE));
        defaultPanelLayout.setVerticalGroup(defaultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 27, Short.MAX_VALUE));
        this.mainPanel.add((Component)this.defaultPanel, "default");
        this.operationProgressBar.setIndeterminate(true);
        this.operationProgressBar.setMinimumSize(new Dimension(10, 10));
        this.operationProgressBar.setRequestFocusEnabled(false);
        this.operationProgressBar.setStringPainted(true);
        this.operationStopButton.setText("Stop");
        this.operationStopButton.setEnabled(false);
        this.operationStopButton.setMinimumSize(new Dimension(67, 15));
        this.operationStopButton.setPreferredSize(new Dimension(75, 20));
        GroupLayout operationPanelLayout = new GroupLayout(this.operationPanel);
        this.operationPanel.setLayout(operationPanelLayout);
        operationPanelLayout.setHorizontalGroup(operationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, operationPanelLayout.createSequentialGroup().addComponent(this.operationProgressBar, -1, 320, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.operationStopButton, -2, 75, -2)));
        operationPanelLayout.setVerticalGroup(operationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(operationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.operationStopButton, -1, 26, Short.MAX_VALUE).addComponent(this.operationProgressBar, -1, 26, Short.MAX_VALUE)));
        this.mainPanel.add((Component)this.operationPanel, "operation");
        this.activityProgressBar.setIndeterminate(true);
        this.activityProgressBar.setName("");
        this.activityProgressBar.setRequestFocusEnabled(false);
        this.activityProgressBar.setStringPainted(true);
        GroupLayout activityPanelLayout = new GroupLayout(this.activityPanel);
        this.activityPanel.setLayout(activityPanelLayout);
        activityPanelLayout.setHorizontalGroup(activityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.activityProgressBar, -1, 401, Short.MAX_VALUE));
        activityPanelLayout.setVerticalGroup(activityPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.activityProgressBar, GroupLayout.Alignment.TRAILING, -1, 27, Short.MAX_VALUE));
        this.mainPanel.add((Component)this.activityPanel, "activity");
        this.add((Component)this.mainPanel, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new XBDocStatusPanel());
    }

    public void setConnectionStatus(ConnectionStatus status) {
        this.connectionStatusLabel.setIcon(new ImageIcon(this.getClass().getResource(this.resourceBundle.getString("connectionStatus" + status.name() + ".icon"))));
        this.connectionStatusLabel.setToolTipText(this.resourceBundle.getString("connectionStatus" + status.name() + ".toolTipText"));
        switch (status) {
            case CONNECTING: {
                this.activityProgressBar.setString("Connection in progress...");
                ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, "activity");
                break;
            }
            case INITIALIZING: {
                this.activityProgressBar.setString("Initializing catalog...");
                ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, "activity");
                break;
            }
            case UPDATING: {
                this.activityProgressBar.setString("Updating catalog...");
                ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, "activity");
                break;
            }
            default: {
                ((CardLayout)this.mainPanel.getLayout()).show(this.mainPanel, "default");
            }
        }
    }
}

