/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.gui.ContextTypeChoicePanel;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemType;
import org.exbin.framework.xbup.catalog.item.revision.gui.CatalogSelectRevPanel;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBDBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTEditableBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclaration;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCGroupDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockRev;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTListenerToEventListener;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.parser_tree.XBTTreeNode;
import org.exbin.xbup.parser_tree.XBTTreeReader;

@ParametersAreNonnullByDefault
public class AddBlockPanel
extends JPanel {
    private XBApplication application;
    @Nullable
    private XBTTreeNode parentNode;
    private XBTTreeNode workNode = null;
    private XBACatalog catalog;
    private XBBlockType contextBlockType = null;
    private XBBlockType catalogBlockType = null;
    private ActionStateListener actionStateListener = null;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AddBlockPanel.class);
    private JComboBox<String> basicTypeComboBox;
    private JRadioButton basicTypeRadioButton;
    private ButtonGroup blockTypeButtonGroup;
    private JRadioButton catalogTypeRadioButton;
    private JButton catalogTypeSelectButton;
    private JTextField catalogTypeTextField;
    private JPanel conditionsPanel;
    private JRadioButton contextTypeRadioButton;
    private JButton contextTypeSelectButton;
    private JTextField contextTypeTextField;
    private JRadioButton dataRadioButton;
    private JCheckBox generateDeclarationCheckBox;
    private JCheckBox prefillCheckBox;
    private JPanel typePanel;

    public AddBlockPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.reloadBasicTypes();
        ((CardLayout)this.getLayout()).show(this, "type");
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setActionStateListener(ActionStateListener listener) {
        this.actionStateListener = listener;
    }

    private void initComponents() {
        this.blockTypeButtonGroup = new ButtonGroup();
        this.typePanel = new JPanel();
        this.dataRadioButton = new JRadioButton();
        this.basicTypeRadioButton = new JRadioButton();
        this.basicTypeComboBox = new JComboBox();
        this.contextTypeRadioButton = new JRadioButton();
        this.contextTypeSelectButton = new JButton();
        this.contextTypeTextField = new JTextField();
        this.catalogTypeRadioButton = new JRadioButton();
        this.catalogTypeSelectButton = new JButton();
        this.catalogTypeTextField = new JTextField();
        this.conditionsPanel = new JPanel();
        this.generateDeclarationCheckBox = new JCheckBox();
        this.prefillCheckBox = new JCheckBox();
        this.setLayout(new CardLayout());
        this.typePanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("typePanel.border.title")));
        this.blockTypeButtonGroup.add(this.dataRadioButton);
        this.dataRadioButton.setText(this.resourceBundle.getString("dataRadioButton.text"));
        this.dataRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.blockTypeButtonGroup.add(this.basicTypeRadioButton);
        this.basicTypeRadioButton.setSelected(true);
        this.basicTypeRadioButton.setText(this.resourceBundle.getString("basicTypeRadioButton.text"));
        this.basicTypeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.basicTypeRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AddBlockPanel.this.basicTypeRadioButtonStateChanged(evt);
            }
        });
        this.blockTypeButtonGroup.add(this.contextTypeRadioButton);
        this.contextTypeRadioButton.setText(this.resourceBundle.getString("contextTypeRadioButton.text"));
        this.contextTypeRadioButton.setEnabled(false);
        this.contextTypeRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AddBlockPanel.this.contextTypeRadioButtonStateChanged(evt);
            }
        });
        this.contextTypeSelectButton.setText(this.resourceBundle.getString("contextTypeSelectButton.text"));
        this.contextTypeSelectButton.setEnabled(false);
        this.contextTypeSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddBlockPanel.this.contextTypeSelectButtonActionPerformed(evt);
            }
        });
        this.contextTypeTextField.setEditable(false);
        this.blockTypeButtonGroup.add(this.catalogTypeRadioButton);
        this.catalogTypeRadioButton.setText(this.resourceBundle.getString("catalogTypeRadioButton.text"));
        this.catalogTypeRadioButton.setEnabled(false);
        this.catalogTypeRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AddBlockPanel.this.catalogTypeRadioButtonStateChanged(evt);
            }
        });
        this.catalogTypeSelectButton.setText(this.resourceBundle.getString("catalogTypeSelectButton.text"));
        this.catalogTypeSelectButton.setEnabled(false);
        this.catalogTypeSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddBlockPanel.this.catalogTypeSelectButtonActionPerformed(evt);
            }
        });
        this.catalogTypeTextField.setEditable(false);
        this.catalogTypeTextField.setEnabled(false);
        GroupLayout typePanelLayout = new GroupLayout(this.typePanel);
        this.typePanel.setLayout(typePanelLayout);
        typePanelLayout.setHorizontalGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, typePanelLayout.createSequentialGroup().addContainerGap().addGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.contextTypeRadioButton, -1, -1, Short.MAX_VALUE).addComponent(this.catalogTypeRadioButton, GroupLayout.Alignment.LEADING, -1, 378, Short.MAX_VALUE).addComponent(this.dataRadioButton, -1, -1, Short.MAX_VALUE).addComponent(this.basicTypeRadioButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(typePanelLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.catalogTypeTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogTypeSelectButton)).addGroup(GroupLayout.Alignment.LEADING, typePanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.basicTypeComboBox, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, typePanelLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.contextTypeTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contextTypeSelectButton))).addContainerGap()));
        typePanelLayout.setVerticalGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(typePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.dataRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.basicTypeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.basicTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contextTypeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contextTypeSelectButton).addComponent(this.contextTypeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogTypeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(typePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.catalogTypeSelectButton).addComponent(this.catalogTypeTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.typePanel, "type");
        this.generateDeclarationCheckBox.setSelected(true);
        this.generateDeclarationCheckBox.setText(this.resourceBundle.getString("generateDeclarationCheckBox.text"));
        this.prefillCheckBox.setText(this.resourceBundle.getString("prefillCheckBox.text"));
        this.prefillCheckBox.setEnabled(false);
        GroupLayout conditionsPanelLayout = new GroupLayout(this.conditionsPanel);
        this.conditionsPanel.setLayout(conditionsPanelLayout);
        conditionsPanelLayout.setHorizontalGroup(conditionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(conditionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(conditionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.generateDeclarationCheckBox, -1, 388, Short.MAX_VALUE).addGroup(conditionsPanelLayout.createSequentialGroup().addComponent(this.prefillCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        conditionsPanelLayout.setVerticalGroup(conditionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(conditionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.generateDeclarationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.prefillCheckBox).addContainerGap(234, Short.MAX_VALUE)));
        this.add((Component)this.conditionsPanel, "cond");
    }

    private void basicTypeRadioButtonStateChanged(ChangeEvent evt) {
        this.basicTypeComboBox.setEnabled(this.basicTypeRadioButton.isSelected());
    }

    private void contextTypeRadioButtonStateChanged(ChangeEvent evt) {
        this.contextTypeSelectButton.setEnabled(this.contextTypeRadioButton.isSelected());
        this.updateActionState();
    }

    private void contextTypeSelectButtonActionPerformed(ActionEvent evt) {
        if (this.catalog != null) {
            FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
            DefaultControlPanel controlPanel = new DefaultControlPanel();
            ContextTypeChoicePanel panel = new ContextTypeChoicePanel(this.catalog, this.parentNode);
            panel.setCanProceedListener(controlPanel.createEnablementListener());
            WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
            controlPanel.setHandler(actionType -> {
                switch (actionType) {
                    case OK: {
                        this.contextBlockType = panel.getBlockType();
                        XBCBlockDecl blockDecl = (XBCBlockDecl)((XBDeclBlockType)this.contextBlockType).getBlockDecl();
                        XBCBlockSpec blockSpec = blockDecl.getBlockSpecRev().getParent();
                        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
                        String targetCaption = nameService.getItemNamePath((XBCItem)blockSpec);
                        targetCaption = targetCaption == null ? "" : targetCaption + " ";
                        targetCaption = targetCaption + "(" + Long.toString(blockSpec.getId()) + ")";
                        this.contextTypeTextField.setText(targetCaption);
                        dialog.close();
                        dialog.dispose();
                        break;
                    }
                    case CANCEL: {
                        dialog.close();
                        dialog.dispose();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected action type " + actionType.name());
                    }
                }
            });
            dialog.showCentered((Component)this);
        }
        this.updateActionState();
    }

    private void catalogTypeRadioButtonStateChanged(ChangeEvent evt) {
        this.catalogTypeTextField.setEnabled(this.catalogTypeRadioButton.isSelected());
        this.catalogTypeSelectButton.setEnabled(this.catalogTypeRadioButton.isSelected());
        if (this.actionStateListener != null) {
            this.actionStateListener.nextEnabled(this.catalogTypeRadioButton.isSelected());
        }
        this.updateActionState();
    }

    private void catalogTypeSelectButtonActionPerformed(ActionEvent evt) {
        if (this.catalog != null) {
            FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
            CatalogSelectRevPanel panel = new CatalogSelectRevPanel(this.catalog, CatalogItemType.BLOCK);
            panel.setApplication(this.application);
            DefaultControlPanel controlPanel = new DefaultControlPanel();
            WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel, (JPanel)controlPanel);
            controlPanel.setHandler(actionType -> {
                switch (actionType) {
                    case OK: {
                        XBCRev blockRev = panel.getTarget();
                        this.catalogBlockType = new XBDeclBlockType((XBBlockDecl)new XBCBlockDecl((XBCBlockRev)blockRev, (XBCatalog)this.catalog));
                        XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
                        String targetCaption = nameService.getItemNamePath((XBCItem)blockRev.getParent());
                        targetCaption = targetCaption == null ? "" : targetCaption + " ";
                        targetCaption = targetCaption + "(" + Long.toString(blockRev.getId()) + ")";
                        this.catalogTypeTextField.setText(targetCaption);
                        dialog.close();
                        dialog.dispose();
                        break;
                    }
                    case CANCEL: {
                        dialog.close();
                        dialog.dispose();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected action type " + actionType.name());
                    }
                }
            });
            dialog.showCentered((Component)this);
        }
        this.updateActionState();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new AddBlockPanel());
    }

    @Nonnull
    public XBTTreeNode getWorkNode() {
        this.workNode = new XBTTreeNode();
        if (this.parentNode != null) {
            this.workNode.setContext(this.parentNode.getContext());
        }
        if (this.dataRadioButton.isSelected()) {
            this.workNode.setDataMode(XBBlockDataMode.DATA_BLOCK);
        } else if (this.basicTypeRadioButton.isSelected()) {
            this.workNode.setBlockType((XBBlockType)new XBFixedBlockType(XBBasicBlockType.valueOf((int)this.basicTypeComboBox.getSelectedIndex())));
        } else if (this.contextTypeRadioButton.isSelected()) {
            this.workNode.setBlockType(this.contextBlockType);
        } else if (this.catalogTypeRadioButton.isSelected()) {
            if (this.generateDeclarationCheckBox.isSelected()) {
                XBPSerialWriter writer = new XBPSerialWriter((XBTEventListener)new XBTListenerToEventListener((XBTListener)new XBTTreeReader((XBTEditableBlock)this.workNode)));
                XBDeclaration newDeclaration = new XBDeclaration(((XBDBlockType)this.catalogBlockType).getBlockDecl());
                writer.write((XBSerializable)newDeclaration);
                XBTTreeNode newNode = new XBTTreeNode();
                newNode.setBlockType(this.catalogBlockType);
                this.workNode.setChildAt((XBTBlock)newNode, this.workNode.getChildrenCount());
            } else {
                this.workNode.setBlockType(this.catalogBlockType);
            }
        }
        return this.workNode;
    }

    public void setWorkNode(XBTTreeNode workNode) {
        this.workNode = workNode;
    }

    private void updateActionState() {
        if (this.actionStateListener != null) {
            this.actionStateListener.finishEnabled(!this.contextTypeRadioButton.isSelected() && !this.catalogTypeRadioButton.isSelected() || this.contextBlockType != null && this.contextTypeRadioButton.isSelected() || this.catalogBlockType != null && this.catalogTypeRadioButton.isSelected());
        }
    }

    public void setParentNode(@Nullable XBTTreeNode parentNode) {
        this.parentNode = parentNode;
        this.contextTypeRadioButton.setEnabled(parentNode != null && parentNode.getContext().getGroupsCount() > 1);
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.reloadBasicTypes();
        this.fireCatalogUpdate();
    }

    private void fireCatalogUpdate() {
        this.catalogTypeRadioButton.setEnabled(this.catalog != null);
    }

    private void reloadBasicTypes() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.basicTypeComboBox.getModel();
        model.removeAllElements();
        if (this.catalog != null) {
            Long[] basicGroupPath = new Long[]{0L, 0L};
            List list = this.catalog.getBlocks(((XBCGroupDecl)this.catalog.findGroupTypeByPath(basicGroupPath, 0)).getGroupSpecRev().getParent());
            XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
            for (XBBlockDecl decl : list) {
                model.addElement(nameService.getDefaultText((XBCItem)((XBCBlockDecl)decl).getBlockSpecRev().getParent()));
            }
        }
    }

    public static interface ActionStateListener {
        public void finishEnabled(boolean var1);

        public void nextEnabled(boolean var1);
    }
}

