/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.api.toolbar.EditItemActionsUpdateListener;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.editor.xbup.def.model.ParametersTableModel;
import org.exbin.framework.editor.xbup.gui.ParametersTableItem;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.catalog.XBACatalog;

@ParametersAreNonnullByDefault
public class ParametersPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ParametersPanel.class);
    private ParametersTableModel parametersTableModel = new ParametersTableModel();
    private XBApplication application;
    private final ToolBarSidePanel toolBarPanel = new ToolBarSidePanel();
    private JScrollPane parametersScrollPane;
    private JTable parametersTable;

    public ParametersPanel() {
        this.initComponents();
        this.toolBarPanel.setToolBarPosition(ToolBarSidePanel.ToolBarPosition.RIGHT);
        this.toolBarPanel.add((Component)this.parametersScrollPane, (Object)"Center");
        this.add((Component)this.toolBarPanel, "Center");
    }

    public void setParametersTableModel(ParametersTableModel parametersTableModel) {
        this.parametersTableModel = parametersTableModel;
        this.parametersTable.setModel(parametersTableModel);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    @Nonnull
    public JTable getParametersTable() {
        return this.parametersTable;
    }

    private void initComponents() {
        this.parametersScrollPane = new JScrollPane();
        this.parametersTable = new JTable(this.parametersTableModel){

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                boolean result = super.editCellAt(row, column, e);
                final Component editor = this.getEditorComponent();
                if (editor == null || !(editor instanceof JTextComponent)) {
                    return result;
                }
                if (e instanceof MouseEvent) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JTextComponent)editor).selectAll();
                        }
                    });
                } else {
                    ((JTextComponent)editor).selectAll();
                }
                return result;
            }
        };
        this.parametersTable.setModel(this.parametersTableModel);
        this.parametersTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ParametersPanel.this.parametersTablePropertyChange(evt);
            }
        });
        this.parametersScrollPane.setViewportView(this.parametersTable);
        this.setLayout(new BorderLayout());
    }

    private void parametersTablePropertyChange(PropertyChangeEvent evt) {
        this.parametersTable.repaint();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ParametersPanel());
    }

    public void setCatalog(XBACatalog catalog) {
    }

    public void addFileActions(ActionsProvider actionsProvider) {
        this.toolBarPanel.addActions(actionsProvider);
    }

    public void setPanelPopup(JPopupMenu popupMenu) {
        this.parametersTable.setComponentPopupMenu(popupMenu);
    }

    public void addSelectionListener(EditItemActionsUpdateListener updateListener) {
        this.parametersTable.getSelectionModel().addListSelectionListener(e -> updateListener.stateChanged());
    }

    @Nullable
    public ParametersTableItem getSelectedRow() {
        int selectedRow = this.parametersTable.getSelectedRow();
        if (selectedRow >= 0) {
            return this.parametersTableModel.getRow(selectedRow);
        }
        return null;
    }
}

