/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.api.XBApplicationModuleRepository;
import org.exbin.framework.bined.BinEdFileHandler;
import org.exbin.framework.bined.BinedModule;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.component.api.ActionsProvider;
import org.exbin.framework.component.gui.ToolBarSidePanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class BinaryDataPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BinaryDataPanel.class);
    private final ToolBarSidePanel toolBarPanel = new ToolBarSidePanel();
    private BinEdComponentPanel componentPanel = null;
    private JPopupMenu dataPopupMenu;
    private XBApplication application;

    public BinaryDataPanel() {
        this.initComponents();
    }

    public void setApplication(XBApplication application) {
        this.application = application;
        this.toolBarPanel.setToolBarPosition(ToolBarSidePanel.ToolBarPosition.RIGHT);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BinaryDataPanel());
    }

    public void addActions(ActionsProvider actionsProvider) {
        this.toolBarPanel.addActions(actionsProvider);
    }

    public void setDataPopupMenu(JPopupMenu popupMenu) {
        this.dataPopupMenu = popupMenu;
        if (this.componentPanel != null) {
            this.componentPanel.setPopupMenu(popupMenu);
        }
    }

    @Nonnull
    public BinEdComponentPanel getComponentPanel() {
        return this.componentPanel;
    }

    public void setFileHandler(BinEdFileHandler binaryDataFile) {
        if (this.componentPanel != null) {
            this.remove((Component)this.componentPanel);
        }
        this.componentPanel = binaryDataFile.getComponent();
        this.toolBarPanel.add((Component)this.componentPanel, (Object)"Center");
        this.toolBarPanel.revalidate();
        this.toolBarPanel.repaint();
        this.add((Component)this.toolBarPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    public void setContentData(BinaryData binaryData) {
        if (this.componentPanel instanceof BinEdComponentPanel) {
            this.componentPanel.setContentData(binaryData);
            return;
        }
        if (this.componentPanel != null) {
            this.remove((Component)this.componentPanel);
        }
        XBApplicationModuleRepository moduleRepository = this.application.getModuleRepository();
        BinedModule binedModule = (BinedModule)moduleRepository.getModuleByInterface(BinedModule.class);
        this.componentPanel = new BinEdComponentPanel();
        this.componentPanel.getCodeArea().setBorder(BorderFactory.createLoweredBevelBorder());
        binedModule.getFileManager().initComponentPanel(this.componentPanel);
        if (this.dataPopupMenu != null) {
            this.componentPanel.setPopupMenu(this.dataPopupMenu);
        }
        this.componentPanel.setContentData(binaryData);
        this.toolBarPanel.add((Component)this.componentPanel, (Object)"Center");
        this.toolBarPanel.revalidate();
        this.toolBarPanel.repaint();
        this.add((Component)this.toolBarPanel, "Center");
        this.revalidate();
        this.repaint();
    }
}

